/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.utils.ArcCurveFit;
import androidx.constraintlayout.core.motion.utils.LinearCurveFit;
import androidx.constraintlayout.core.motion.utils.MonotonicCurveFit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b'\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH&J\u0018\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH&J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\r\u001a\u00020\bH&\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/motion/utils/CurveFit;", "", "()V", "getPos", "", "t", "", "v", "", "", "j", "", "getSlope", "getTimePoints", "Companion", "compose"})
@StabilityInferred(parameters=1)
public abstract class CurveFit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    public static final int SPLINE = 0;
    public static final int LINEAR = 1;
    public static final int CONSTANT = 2;

    public abstract void getPos(double var1, @NotNull double[] var3);

    public abstract void getPos(double var1, @NotNull float[] var3);

    public abstract double getPos(double var1, int var3);

    public abstract void getSlope(double var1, @NotNull double[] var3);

    public abstract double getSlope(double var1, int var3);

    @NotNull
    public abstract double[] getTimePoints();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/constraintlayout/core/motion/utils/CurveFit$Companion;", "", "()V", "CONSTANT", "", "LINEAR", "SPLINE", "get", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "type", "time", "", "y", "", "(I[D[[D)Landroidx/constraintlayout/core/motion/utils/CurveFit;", "getArc", "arcModes", "", "([I[D[[D)Landroidx/constraintlayout/core/motion/utils/CurveFit;", "Constant", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CurveFit get(int type, @NotNull double[] time, @NotNull double[][] y) {
            CurveFit curveFit;
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            int type2 = type;
            if (time.length == 1) {
                type2 = 2;
            }
            switch (type2) {
                case 0: {
                    curveFit = new MonotonicCurveFit(time, y);
                    break;
                }
                case 2: {
                    curveFit = new Constant(time[0], y[0]);
                    break;
                }
                default: {
                    curveFit = new LinearCurveFit(time, y);
                }
            }
            return curveFit;
        }

        @NotNull
        public final CurveFit getArc(@NotNull int[] arcModes, @NotNull double[] time, @NotNull double[][] y) {
            Intrinsics.checkNotNullParameter((Object)arcModes, (String)"arcModes");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            return new ArcCurveFit(arcModes, time, y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Landroidx/constraintlayout/core/motion/utils/CurveFit$Companion$Constant;", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "time", "", "value", "", "(D[D)V", "mTime", "getMTime", "()D", "setMTime", "(D)V", "mValue", "getMValue", "()[D", "setMValue", "([D)V", "getPos", "", "t", "v", "", "j", "", "getSlope", "getTimePoints", "compose"})
        @StabilityInferred(parameters=0)
        public static final class Constant
        extends CurveFit {
            private double mTime;
            @NotNull
            private double[] mValue;
            public static final int $stable = 8;

            public Constant(double time, @NotNull double[] value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.mTime = time;
                this.mValue = value;
            }

            public final double getMTime() {
                return this.mTime;
            }

            public final void setMTime(double d) {
                this.mTime = d;
            }

            @NotNull
            public final double[] getMValue() {
                return this.mValue;
            }

            public final void setMValue(@NotNull double[] dArray) {
                Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
                this.mValue = dArray;
            }

            @Override
            public void getPos(double t, @NotNull double[] v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                ArraysKt.copyInto$default((double[])this.mValue, (double[])v, (int)0, (int)0, (int)0, (int)8, null);
            }

            @Override
            public void getPos(double t, @NotNull float[] v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                int n = this.mValue.length;
                for (int i = 0; i < n; ++i) {
                    v[i] = (float)this.mValue[i];
                }
            }

            @Override
            public double getPos(double t, int j) {
                return this.mValue[j];
            }

            @Override
            public void getSlope(double t, @NotNull double[] v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                int n = this.mValue.length;
                for (int i = 0; i < n; ++i) {
                    v[i] = 0.0;
                }
            }

            @Override
            public double getSlope(double t, int j) {
                return 0.0;
            }

            @Override
            @NotNull
            public double[] getTimePoints() {
                double[] dArray = new double[]{this.mTime};
                return dArray;
            }
        }
    }
}

