/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\b'\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u001d\u001a\u00020\u001e2\"\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 `\u0007H&J\n\u0010!\u001a\u0004\u0018\u00010\u0000H&J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0016J \u0010$\u001a\u00020\u001e2\u0016\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u00050&j\b\u0012\u0004\u0012\u00020\u0005`'H&J\b\u0010(\u001a\u00020\rH\u0016J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0005H\u0016J\"\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020*H\u0016J\"\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0016J\"\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\rH\u0016J\"\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\rH\u0016J4\u00103\u001a\u00020\u001e2*\u00104\u001a&\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0004j\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r`\u0007H\u0016J\u0018\u00105\u001a\u00020*2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020*H\u0016J\u0018\u00105\u001a\u00020*2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00105\u001a\u00020*2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\rH\u0016J\u0018\u00105\u001a\u00020*2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\rH\u0016J\u0010\u00108\u001a\u00020*2\u0006\u0010/\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0002002\u0006\u0010/\u001a\u000209H\u0016J\u0010\u0010;\u001a\u00020\r2\u0006\u0010/\u001a\u000209H\u0016R:\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0011\u00a8\u0006="}, d2={"Landroidx/constraintlayout/core/motion/key/MotionKey;", "Landroidx/constraintlayout/core/motion/utils/TypedValues;", "()V", "mCustom", "Ljava/util/HashMap;", "", "Landroidx/constraintlayout/core/motion/CustomVariable;", "Lkotlin/collections/HashMap;", "getMCustom", "()Ljava/util/HashMap;", "setMCustom", "(Ljava/util/HashMap;)V", "mFramePosition", "", "getMFramePosition", "()I", "setMFramePosition", "(I)V", "mTargetId", "getMTargetId", "setMTargetId", "mTargetString", "getMTargetString", "()Ljava/lang/String;", "setMTargetString", "(Ljava/lang/String;)V", "mType", "getMType", "setMType", "addValues", "", "splines", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "clone", "copy", "src", "getAttributeNames", "attributes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getFramePosition", "matches", "", "constraintTag", "setCustomAttribute", "name", "type", "value", "", "setFramePosition", "pos", "setInterpolation", "interpolation", "setValue", "setViewId", "id", "toBoolean", "", "toFloat", "toInt", "Companion", "compose"})
@StabilityInferred(parameters=0)
public abstract class MotionKey
implements TypedValues {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mFramePosition = -1;
    private int mTargetId = -1;
    @Nullable
    private String mTargetString;
    private int mType;
    @Nullable
    private HashMap<String, CustomVariable> mCustom;
    public static final int $stable = 8;
    public static final int UNSET = -1;
    @NotNull
    public static final String ALPHA = "alpha";
    @NotNull
    public static final String ELEVATION = "elevation";
    @NotNull
    public static final String ROTATION = "rotationZ";
    @NotNull
    public static final String ROTATION_X = "rotationX";
    @NotNull
    public static final String TRANSITION_PATH_ROTATE = "transitionPathRotate";
    @NotNull
    public static final String SCALE_X = "scaleX";
    @NotNull
    public static final String SCALE_Y = "scaleY";
    @NotNull
    public static final String TRANSLATION_X = "translationX";
    @NotNull
    public static final String TRANSLATION_Y = "translationY";
    @NotNull
    public static final String CUSTOM = "CUSTOM";
    @NotNull
    public static final String VISIBILITY = "visibility";

    public final int getMFramePosition() {
        return this.mFramePosition;
    }

    public final void setMFramePosition(int n) {
        this.mFramePosition = n;
    }

    public final int getMTargetId() {
        return this.mTargetId;
    }

    public final void setMTargetId(int n) {
        this.mTargetId = n;
    }

    @Nullable
    public final String getMTargetString() {
        return this.mTargetString;
    }

    public final void setMTargetString(@Nullable String string2) {
        this.mTargetString = string2;
    }

    public final int getMType() {
        return this.mType;
    }

    public final void setMType(int n) {
        this.mType = n;
    }

    @Nullable
    public final HashMap<String, CustomVariable> getMCustom() {
        return this.mCustom;
    }

    public final void setMCustom(@Nullable HashMap<String, CustomVariable> hashMap) {
        this.mCustom = hashMap;
    }

    public abstract void getAttributeNames(@NotNull HashSet<String> var1);

    public boolean matches(@Nullable String constraintTag) {
        boolean bl;
        if (this.mTargetString == null || constraintTag == null) {
            bl = false;
        } else {
            CharSequence charSequence = constraintTag;
            String string2 = this.mTargetString;
            Intrinsics.checkNotNull((Object)string2);
            bl = new Regex(string2).matches(charSequence);
        }
        return bl;
    }

    public abstract void addValues(@NotNull HashMap<String, SplineSet> var1);

    public float toFloat(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value instanceof Float ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
    }

    public int toInt(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value instanceof Integer ? ((Number)value).intValue() : Integer.parseInt(value.toString());
    }

    public boolean toBoolean(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value instanceof Boolean ? (Boolean)value : StringsKt.toBooleanStrict((String)value.toString());
    }

    public void setInterpolation(@NotNull HashMap<String, Integer> interpolation) {
        Intrinsics.checkNotNullParameter(interpolation, (String)"interpolation");
    }

    @NotNull
    public MotionKey copy(@NotNull MotionKey src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.mFramePosition = src.mFramePosition;
        this.mTargetId = src.mTargetId;
        this.mTargetString = src.mTargetString;
        this.mType = src.mType;
        return this;
    }

    @Nullable
    public abstract MotionKey clone();

    @NotNull
    public MotionKey setViewId(int id) {
        this.mTargetId = id;
        return this;
    }

    public void setFramePosition(int pos) {
        this.mFramePosition = pos;
    }

    public int getFramePosition() {
        return this.mFramePosition;
    }

    @Override
    public boolean setValue(int type, int value) {
        if (type == 100) {
            this.mFramePosition = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(int type, float value) {
        return false;
    }

    @Override
    public boolean setValue(int type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (type == 101) {
            this.mTargetString = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(int type, boolean value) {
        return false;
    }

    public void setCustomAttribute(@Nullable String name, int type, float value) {
        HashMap<String, CustomVariable> hashMap = this.mCustom;
        Intrinsics.checkNotNull(hashMap);
        Map map = hashMap;
        String string2 = name;
        Intrinsics.checkNotNull((Object)string2);
        map.put(string2, new CustomVariable(name, type, value));
    }

    public void setCustomAttribute(@Nullable String name, int type, int value) {
        HashMap<String, CustomVariable> hashMap = this.mCustom;
        Intrinsics.checkNotNull(hashMap);
        Map map = hashMap;
        String string2 = name;
        Intrinsics.checkNotNull((Object)string2);
        map.put(string2, new CustomVariable(name, type, value));
    }

    public void setCustomAttribute(@Nullable String name, int type, boolean value) {
        HashMap<String, CustomVariable> hashMap = this.mCustom;
        Intrinsics.checkNotNull(hashMap);
        Map map = hashMap;
        String string2 = name;
        Intrinsics.checkNotNull((Object)string2);
        map.put(string2, new CustomVariable(name, type, value));
    }

    public void setCustomAttribute(@Nullable String name, int type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        HashMap<String, CustomVariable> hashMap = this.mCustom;
        Intrinsics.checkNotNull(hashMap);
        Map map = hashMap;
        String string2 = name;
        Intrinsics.checkNotNull((Object)string2);
        map.put(string2, new CustomVariable(name, type, value));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/constraintlayout/core/motion/key/MotionKey$Companion;", "", "()V", "ALPHA", "", "CUSTOM", "ELEVATION", "ROTATION", "ROTATION_X", "SCALE_X", "SCALE_Y", "TRANSITION_PATH_ROTATE", "TRANSLATION_X", "TRANSLATION_Y", "UNSET", "", "VISIBILITY", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

