/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.ext;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B-\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u0017"}, d2={"Landroidx/constraintlayout/core/ext/Rectangle;", "", "rectangle", "(Landroidx/constraintlayout/core/ext/Rectangle;)V", "x", "", "y", "width", "height", "(IIII)V", "getHeight", "()I", "setHeight", "(I)V", "getWidth", "setWidth", "getX", "setX", "getY", "setY", "intersects", "", "union", "compose"})
@StabilityInferred(parameters=0)
public final class Rectangle {
    private int x;
    private int y;
    private int width;
    private int height;
    public static final int $stable = 8;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public /* synthetic */ Rectangle(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public Rectangle(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @NotNull
    public final Rectangle union(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        long tx2 = this.width;
        long ty2 = this.height;
        if ((tx2 | ty2) < 0L) {
            return new Rectangle(rectangle);
        }
        long rx2 = rectangle.width;
        long ry2 = rectangle.height;
        if ((rx2 | ry2) < 0L) {
            return new Rectangle(this);
        }
        int tx1 = this.x;
        int ty1 = this.y;
        tx2 += (long)tx1;
        ty2 += (long)ty1;
        int rx1 = rectangle.x;
        int ry1 = rectangle.y;
        rx2 += (long)rx1;
        ry2 += (long)ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) > Integer.MAX_VALUE) {
            tx2 = Integer.MAX_VALUE;
        }
        if (ty2 > Integer.MAX_VALUE) {
            ty2 = Integer.MAX_VALUE;
        }
        return new Rectangle(tx1, ty1, (int)tx2, (int)ty2);
    }

    public final boolean intersects(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        int tw = this.width;
        int th = this.height;
        int rw = rectangle.width;
        int rh = rectangle.height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.x;
        int ty = this.y;
        int rx = rectangle.x;
        int ry = rectangle.y;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    public Rectangle() {
        this(0, 0, 0, 0, 15, null);
    }
}

