/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.dsl.Constraint;
import androidx.constraintlayout.core.dsl.Helper;
import androidx.constraintlayout.core.dsl.Ref;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0003\u0016\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Landroidx/constraintlayout/core/dsl/Chain;", "Landroidx/constraintlayout/core/dsl/Helper;", "name", "", "(Ljava/lang/String;)V", "mStyle", "Landroidx/constraintlayout/core/dsl/Chain$Style;", "references", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/dsl/Ref;", "Lkotlin/collections/ArrayList;", "getReferences", "()Ljava/util/ArrayList;", "setReferences", "(Ljava/util/ArrayList;)V", "addReference", "ref", "getStyle", "referencesToString", "setStyle", "", "style", "Anchor", "Companion", "Style", "compose"})
@StabilityInferred(parameters=0)
public class Chain
extends Helper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Style mStyle;
    @NotNull
    private ArrayList<Ref> references;
    public static final int $stable = 8;
    @NotNull
    private static final Map<Style, String> styleMap;

    public Chain(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, new Helper.HelperType(""));
        this.references = new ArrayList();
    }

    @NotNull
    protected final ArrayList<Ref> getReferences() {
        return this.references;
    }

    protected final void setReferences(@NotNull ArrayList<Ref> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.references = arrayList;
    }

    @Nullable
    public final Style getStyle() {
        return this.mStyle;
    }

    public final void setStyle(@NotNull Style style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        this.mStyle = style;
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        String string2 = styleMap.get((Object)style);
        Intrinsics.checkNotNull((Object)string2);
        map.put("style", string2);
    }

    @NotNull
    public final String referencesToString() {
        if (this.references.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("[");
        for (Ref ref : this.references) {
            builder.append(String.valueOf(ref));
        }
        builder.append("]");
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final Chain addReference(@Nullable Ref ref) {
        this.references.add(ref);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("contains", this.referencesToString());
        return this;
    }

    @NotNull
    public final Chain addReference(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.addReference(Ref.Companion.parseStringToRef(ref));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)Style.SPREAD), (Object)"'spread'"), TuplesKt.to((Object)((Object)Style.SPREAD_INSIDE), (Object)"'spread_inside'"), TuplesKt.to((Object)((Object)Style.PACKED), (Object)"'packed'")};
        styleMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0016R \u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/constraintlayout/core/dsl/Chain$Anchor;", "", "side", "Landroidx/constraintlayout/core/dsl/Constraint$Side;", "(Landroidx/constraintlayout/core/dsl/Chain;Landroidx/constraintlayout/core/dsl/Constraint$Side;)V", "mConnection", "Landroidx/constraintlayout/core/dsl/Constraint$Anchor;", "Landroidx/constraintlayout/core/dsl/Constraint;", "getMConnection", "()Landroidx/constraintlayout/core/dsl/Constraint$Anchor;", "setMConnection", "(Landroidx/constraintlayout/core/dsl/Constraint$Anchor;)V", "mGoneMargin", "", "getMGoneMargin", "()I", "setMGoneMargin", "(I)V", "mMargin", "getMMargin", "setMMargin", "mSide", "build", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getId", "", "toString", "compose"})
    public class Anchor {
        @NotNull
        private final Constraint.Side mSide;
        @Nullable
        private Constraint.Anchor mConnection;
        private int mMargin;
        private int mGoneMargin;

        public Anchor(Constraint.Side side) {
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            this.mSide = side;
            this.mGoneMargin = Integer.MIN_VALUE;
        }

        @Nullable
        public final Constraint.Anchor getMConnection() {
            return this.mConnection;
        }

        public final void setMConnection(@Nullable Constraint.Anchor anchor) {
            this.mConnection = anchor;
        }

        public final int getMMargin() {
            return this.mMargin;
        }

        public final void setMMargin(int n) {
            this.mMargin = n;
        }

        public final int getMGoneMargin() {
            return this.mGoneMargin;
        }

        public final void setMGoneMargin(int n) {
            this.mGoneMargin = n;
        }

        @NotNull
        public final String getId() {
            return Chain.this.getName();
        }

        public final void build(@NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (this.mConnection != null) {
                String string2 = this.mSide.toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                builder.append(string2).append(":").append(this).append(",\n");
            }
        }

        @NotNull
        public String toString() {
            StringBuilder ret = new StringBuilder("[");
            if (this.mConnection != null) {
                StringBuilder stringBuilder = ret.append("'");
                Constraint.Anchor anchor = this.mConnection;
                Intrinsics.checkNotNull((Object)anchor);
                StringBuilder stringBuilder2 = stringBuilder.append(anchor.getId()).append("',").append("'");
                Constraint.Anchor anchor2 = this.mConnection;
                Intrinsics.checkNotNull((Object)anchor2);
                String string2 = anchor2.getMSide().toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                stringBuilder2.append(string2).append("'");
            }
            if (this.mMargin != 0) {
                ret.append(",").append(this.mMargin);
            }
            if (this.mGoneMargin != Integer.MIN_VALUE) {
                if (this.mMargin == 0) {
                    ret.append(",0,").append(this.mGoneMargin);
                } else {
                    ret.append(",").append(this.mGoneMargin);
                }
            }
            ret.append("]");
            String string3 = ret.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return string3;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/constraintlayout/core/dsl/Chain$Companion;", "", "()V", "styleMap", "", "Landroidx/constraintlayout/core/dsl/Chain$Style;", "", "getStyleMap", "()Ljava/util/Map;", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Map<Style, String> getStyleMap() {
            return styleMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/dsl/Chain$Style;", "", "(Ljava/lang/String;I)V", "PACKED", "SPREAD", "SPREAD_INSIDE", "compose"})
    public static final class Style
    extends Enum<Style> {
        public static final /* enum */ Style PACKED = new Style();
        public static final /* enum */ Style SPREAD = new Style();
        public static final /* enum */ Style SPREAD_INSIDE = new Style();
        private static final /* synthetic */ Style[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }

        public static Style valueOf(String value) {
            return Enum.valueOf(Style.class, value);
        }

        @NotNull
        public static EnumEntries<Style> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = styleArray = new Style[]{Style.PACKED, Style.SPREAD, Style.SPREAD_INSIDE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

