/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.dsl.Constraint;
import androidx.constraintlayout.core.dsl.Helper;
import androidx.constraintlayout.core.dsl.Ref;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010\u0011\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r0\fj\n\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/constraintlayout/core/dsl/Barrier;", "Landroidx/constraintlayout/core/dsl/Helper;", "name", "", "(Ljava/lang/String;)V", "config", "(Ljava/lang/String;Ljava/lang/String;)V", "mDirection", "Landroidx/constraintlayout/core/dsl/Constraint$Side;", "mMargin", "", "references", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/dsl/Ref;", "Lkotlin/collections/ArrayList;", "addReference", "ref", "getDirection", "getMargin", "referencesToString", "setDirection", "", "direction", "setMargin", "margin", "compose"})
@StabilityInferred(parameters=0)
public final class Barrier
extends Helper {
    @Nullable
    private Constraint.Side mDirection;
    private int mMargin;
    @NotNull
    private final ArrayList<Ref> references;
    public static final int $stable = 8;

    public Barrier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = Helper.getTypeMap().get((Object)Helper.Type.BARRIER);
        Intrinsics.checkNotNull((Object)string2);
        super(name, new Helper.HelperType(string2));
        this.mMargin = Integer.MIN_VALUE;
        this.references = new ArrayList();
    }

    public Barrier(@NotNull String name, @NotNull String config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string2 = Helper.getTypeMap().get((Object)Helper.Type.BARRIER);
        Intrinsics.checkNotNull((Object)string2);
        super(name, new Helper.HelperType(string2), config);
        this.mMargin = Integer.MIN_VALUE;
        this.references = new ArrayList();
        Map<String, String> map = this.convertConfigToMap();
        Intrinsics.checkNotNull(map);
        this.setConfigMap(MapsKt.toMutableMap(map));
        Map<String, String> map2 = this.getConfigMap();
        Intrinsics.checkNotNull(map2);
        if (map2.containsKey("contains")) {
            Map<String, String> map3 = this.getConfigMap();
            Intrinsics.checkNotNull(map3);
            Ref.Companion.addStringToReferences(map3.get("contains"), this.references);
        }
    }

    @Nullable
    public final Constraint.Side getDirection() {
        return this.mDirection;
    }

    public final void setDirection(@NotNull Constraint.Side direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.mDirection = direction;
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        String string2 = Helper.getSideMap().get((Object)direction);
        Intrinsics.checkNotNull((Object)string2);
        map.put("direction", string2);
    }

    public final int getMargin() {
        return this.mMargin;
    }

    public final void setMargin(int margin) {
        this.mMargin = margin;
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("margin", String.valueOf(margin));
    }

    @NotNull
    public final String referencesToString() {
        if (this.references.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("[");
        for (Ref ref : this.references) {
            builder.append(String.valueOf(ref));
        }
        builder.append("]");
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final Barrier addReference(@Nullable Ref ref) {
        this.references.add(ref);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("contains", this.referencesToString());
        return this;
    }

    @NotNull
    public final Barrier addReference(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.addReference(Ref.Companion.parseStringToRef(ref));
    }
}

