/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J$\u0010#\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010%\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0004R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/constraintlayout/core/PriorityGoalRow;", "Landroidx/constraintlayout/core/ArrayRow;", "mCache", "Landroidx/constraintlayout/core/Cache;", "(Landroidx/constraintlayout/core/Cache;)V", "isEmpty", "", "()Z", "mAccessor", "Landroidx/constraintlayout/core/PriorityGoalRow$GoalVariableAccessor;", "mArrayGoals", "", "Landroidx/constraintlayout/core/SolverVariable;", "[Landroidx/constraintlayout/core/SolverVariable;", "getMCache", "()Landroidx/constraintlayout/core/Cache;", "setMCache", "mNumGoals", "", "mSortArray", "mTableSize", "addError", "", "error", "addToGoal", "variable", "clear", "getPivotCandidate", "system", "Landroidx/constraintlayout/core/LinearSystem;", "avoid", "", "removeGoal", "toString", "", "updateFromRow", "definition", "removeFromDefinition", "Companion", "GoalVariableAccessor", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPriorityGoalRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityGoalRow.kt\nandroidx/constraintlayout/core/PriorityGoalRow\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,244:1\n37#2,2:245\n*S KotlinDebug\n*F\n+ 1 PriorityGoalRow.kt\nandroidx/constraintlayout/core/PriorityGoalRow\n*L\n182#1:245,2\n*E\n"})
public final class PriorityGoalRow
extends ArrayRow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Cache mCache;
    private final int mTableSize;
    @NotNull
    private SolverVariable[] mArrayGoals;
    @NotNull
    private SolverVariable[] mSortArray;
    private int mNumGoals;
    @NotNull
    private GoalVariableAccessor mAccessor;
    public static final int $stable = 8;
    private static final float EPSILON = 1.0E-4f;
    private static final boolean DEBUG;
    public static final int NOT_FOUND = -1;

    public PriorityGoalRow(@NotNull Cache mCache) {
        Intrinsics.checkNotNullParameter((Object)mCache, (String)"mCache");
        super(mCache);
        this.mCache = mCache;
        this.mTableSize = 128;
        this.mArrayGoals = new SolverVariable[this.mTableSize];
        this.mSortArray = new SolverVariable[this.mTableSize];
        this.mAccessor = new GoalVariableAccessor(this);
    }

    @NotNull
    public final Cache getMCache() {
        return this.mCache;
    }

    public final void setMCache(@NotNull Cache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"<set-?>");
        this.mCache = cache;
    }

    @Override
    public void clear() {
        this.mNumGoals = 0;
        this.setMConstantValue(0.0f);
    }

    @Override
    public boolean isEmpty() {
        return this.mNumGoals == 0;
    }

    @Override
    @Nullable
    public SolverVariable getPivotCandidate(@Nullable LinearSystem system, @Nullable boolean[] avoid) {
        int pivot = -1;
        int n = this.mNumGoals;
        for (int i = 0; i < n; ++i) {
            SolverVariable variable;
            Intrinsics.checkNotNull((Object)this.mArrayGoals[i]);
            Intrinsics.checkNotNull((Object)avoid);
            if (avoid[variable.getId()]) continue;
            this.mAccessor.init(variable);
            if (pivot == -1) {
                if (!this.mAccessor.isNegative()) continue;
                pivot = i;
                continue;
            }
            SolverVariable solverVariable = this.mArrayGoals[pivot];
            Intrinsics.checkNotNull((Object)solverVariable);
            if (!this.mAccessor.isSmallerThan(solverVariable)) continue;
            pivot = i;
        }
        return pivot == -1 ? null : this.mArrayGoals[pivot];
    }

    @Override
    public void addError(@Nullable SolverVariable error) {
        this.mAccessor.init(error);
        this.mAccessor.reset();
        SolverVariable solverVariable = error;
        Intrinsics.checkNotNull((Object)solverVariable);
        solverVariable.getMGoalStrengthVector()[error.getStrength()] = 1.0f;
        this.addToGoal(error);
    }

    private final void addToGoal(SolverVariable variable) {
        if (this.mNumGoals + 1 > this.mArrayGoals.length) {
            SolverVariable[] solverVariableArray = Arrays.copyOf(this.mArrayGoals, this.mArrayGoals.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)solverVariableArray, (String)"copyOf(...)");
            this.mArrayGoals = solverVariableArray;
            SolverVariable[] solverVariableArray2 = Arrays.copyOf(this.mArrayGoals, this.mArrayGoals.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)solverVariableArray2, (String)"copyOf(...)");
            this.mSortArray = solverVariableArray2;
        }
        this.mArrayGoals[this.mNumGoals] = variable;
        int n = this.mNumGoals;
        this.mNumGoals = n + 1;
        if (this.mNumGoals > 1) {
            SolverVariable solverVariable = this.mArrayGoals[this.mNumGoals - 1];
            Intrinsics.checkNotNull((Object)solverVariable);
            if (solverVariable.getId() > variable.getId()) {
                int n2 = this.mNumGoals;
                for (int i = 0; i < n2; ++i) {
                    this.mSortArray[i] = this.mArrayGoals[i];
                }
                Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])this.mSortArray);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ArraysKt.sort((Comparable[])thisCollection$iv.toArray(new SolverVariable[0]), (int)0, (int)this.mNumGoals);
                n2 = this.mNumGoals;
                for (int i = 0; i < n2; ++i) {
                    this.mArrayGoals[i] = this.mSortArray[i];
                }
            }
        }
        variable.setInGoal(true);
        variable.addToRow(this);
    }

    private final void removeGoal(SolverVariable variable) {
        int n = this.mNumGoals;
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)this.mArrayGoals[i], (Object)variable)) continue;
            int n2 = this.mNumGoals - 1;
            for (int j = i; j < n2; ++j) {
                this.mArrayGoals[j] = this.mArrayGoals[j + 1];
            }
            int n3 = this.mNumGoals;
            this.mNumGoals = n3 + -1;
            variable.setInGoal(false);
            return;
        }
    }

    @Override
    public void updateFromRow(@Nullable LinearSystem system, @Nullable ArrayRow definition, boolean removeFromDefinition) {
        ArrayRow.ArrayRowVariables rowVariables;
        ArrayRow arrayRow = definition;
        Intrinsics.checkNotNull((Object)arrayRow);
        SolverVariable solverVariable = arrayRow.getMVariable();
        if (solverVariable == null) {
            return;
        }
        SolverVariable goalVariable = solverVariable;
        ArrayRow.ArrayRowVariables arrayRowVariables = rowVariables = definition.getVariables();
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        int currentSize = arrayRowVariables.getCurrentSize();
        for (int i = 0; i < currentSize; ++i) {
            SolverVariable solverVariable2 = rowVariables.getVariable(i);
            float value = rowVariables.getVariableValue(i);
            this.mAccessor.init(solverVariable2);
            if (this.mAccessor.addToGoal(goalVariable, value)) {
                SolverVariable solverVariable3 = solverVariable2;
                Intrinsics.checkNotNull((Object)solverVariable3);
                this.addToGoal(solverVariable3);
            }
            this.setMConstantValue(this.getMConstantValue() + definition.getMConstantValue() * value);
        }
        this.removeGoal(goalVariable);
    }

    @Override
    @NotNull
    public String toString() {
        Object result = "";
        result = (String)result + " goal -> (" + this.getMConstantValue() + ") : ";
        int n = this.mNumGoals;
        for (int i = 0; i < n; ++i) {
            SolverVariable v;
            Intrinsics.checkNotNull((Object)this.mArrayGoals[i]);
            this.mAccessor.init(v);
            result = (String)result + this.mAccessor + " ";
        }
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/PriorityGoalRow$Companion;", "", "()V", "DEBUG", "", "getDEBUG$annotations", "EPSILON", "", "NOT_FOUND", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getDEBUG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00068F\u00a2\u0006\f\u0012\u0004\b\t\u0010\n\u001a\u0004\b\b\u0010\u0007R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/constraintlayout/core/PriorityGoalRow$GoalVariableAccessor;", "", "row", "Landroidx/constraintlayout/core/PriorityGoalRow;", "(Landroidx/constraintlayout/core/PriorityGoalRow;Landroidx/constraintlayout/core/PriorityGoalRow;)V", "isNegative", "", "()Z", "isNull", "isNull$annotations", "()V", "mRow", "getMRow$annotations", "mVariable", "Landroidx/constraintlayout/core/SolverVariable;", "add", "", "other", "addToGoal", "value", "", "init", "variable", "isSmallerThan", "reset", "toString", "", "compose"})
    public final class GoalVariableAccessor {
        @Nullable
        private SolverVariable mVariable;
        @Nullable
        private PriorityGoalRow mRow;

        public GoalVariableAccessor(PriorityGoalRow row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            this.mRow = row;
        }

        private static /* synthetic */ void getMRow$annotations() {
        }

        public final void init(@Nullable SolverVariable variable) {
            this.mVariable = variable;
        }

        public final boolean addToGoal(@NotNull SolverVariable other, float value) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            SolverVariable solverVariable = this.mVariable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (solverVariable.getInGoal()) {
                boolean empty = true;
                for (int i = 0; i < 9; ++i) {
                    SolverVariable solverVariable2 = this.mVariable;
                    Intrinsics.checkNotNull((Object)solverVariable2);
                    float[] fArray = solverVariable2.getMGoalStrengthVector();
                    int n = i;
                    fArray[n] = fArray[n] + other.getMGoalStrengthVector()[i] * value;
                    SolverVariable solverVariable3 = this.mVariable;
                    Intrinsics.checkNotNull((Object)solverVariable3);
                    float v = solverVariable3.getMGoalStrengthVector()[i];
                    if (Math.abs(v) < 1.0E-4f) {
                        SolverVariable solverVariable4 = this.mVariable;
                        Intrinsics.checkNotNull((Object)solverVariable4);
                        solverVariable4.getMGoalStrengthVector()[i] = 0.0f;
                        continue;
                    }
                    empty = false;
                }
                if (empty) {
                    SolverVariable solverVariable5 = this.mVariable;
                    Intrinsics.checkNotNull((Object)solverVariable5);
                    PriorityGoalRow.this.removeGoal(solverVariable5);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    float strength = other.getMGoalStrengthVector()[i];
                    if (!(strength == 0.0f)) {
                        float v = value * strength;
                        if (Math.abs(v) < 1.0E-4f) {
                            v = 0.0f;
                        }
                        SolverVariable solverVariable6 = this.mVariable;
                        Intrinsics.checkNotNull((Object)solverVariable6);
                        solverVariable6.getMGoalStrengthVector()[i] = v;
                        continue;
                    }
                    SolverVariable solverVariable7 = this.mVariable;
                    Intrinsics.checkNotNull((Object)solverVariable7);
                    solverVariable7.getMGoalStrengthVector()[i] = 0.0f;
                }
                return true;
            }
            return false;
        }

        public final void add(@NotNull SolverVariable other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            for (int i = 0; i < 9; ++i) {
                SolverVariable solverVariable = this.mVariable;
                Intrinsics.checkNotNull((Object)solverVariable);
                float[] fArray = solverVariable.getMGoalStrengthVector();
                int n = i;
                fArray[n] = fArray[n] + other.getMGoalStrengthVector()[i];
                SolverVariable solverVariable2 = this.mVariable;
                Intrinsics.checkNotNull((Object)solverVariable2);
                float value = solverVariable2.getMGoalStrengthVector()[i];
                if (!(Math.abs(value) < 1.0E-4f)) continue;
                SolverVariable solverVariable3 = this.mVariable;
                Intrinsics.checkNotNull((Object)solverVariable3);
                solverVariable3.getMGoalStrengthVector()[i] = 0.0f;
            }
        }

        public final boolean isNegative() {
            for (int i = 8; -1 < i; --i) {
                SolverVariable solverVariable = this.mVariable;
                Intrinsics.checkNotNull((Object)solverVariable);
                float value = solverVariable.getMGoalStrengthVector()[i];
                if (value > 0.0f) {
                    return false;
                }
                if (!(value < 0.0f)) continue;
                return true;
            }
            return false;
        }

        public final boolean isSmallerThan(@NotNull SolverVariable other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            for (int i = 8; -1 < i; --i) {
                float comparedValue = other.getMGoalStrengthVector()[i];
                SolverVariable solverVariable = this.mVariable;
                Intrinsics.checkNotNull((Object)solverVariable);
                float value = solverVariable.getMGoalStrengthVector()[i];
                if (value == comparedValue) continue;
                return value < comparedValue;
            }
            return false;
        }

        public final boolean isNull() {
            for (int i = 0; i < 9; ++i) {
                SolverVariable solverVariable = this.mVariable;
                Intrinsics.checkNotNull((Object)solverVariable);
                if (solverVariable.getMGoalStrengthVector()[i] == 0.0f) continue;
                return false;
            }
            return true;
        }

        public static /* synthetic */ void isNull$annotations() {
        }

        public final void reset() {
            SolverVariable solverVariable = this.mVariable;
            Intrinsics.checkNotNull((Object)solverVariable);
            ArraysKt.fill$default((float[])solverVariable.getMGoalStrengthVector(), (float)0.0f, (int)0, (int)0, (int)6, null);
        }

        @NotNull
        public String toString() {
            Object result = "[ ";
            if (this.mVariable != null) {
                for (int i = 0; i < 9; ++i) {
                    SolverVariable solverVariable = this.mVariable;
                    Intrinsics.checkNotNull((Object)solverVariable);
                    result = (String)result + solverVariable.getMGoalStrengthVector()[i] + " ";
                }
            }
            result = (String)result + "] " + this.mVariable;
            return result;
        }
    }
}

