/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.PriorityGoalRow;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.SolverVariableValues;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b-\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0007\u0018\u0000 \u0087\u00012\u00020\u0001:\u0006\u0087\u0001\u0088\u0001\u0089\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u000102H\u0002J&\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0017JF\u0010F\u001a\u00020?2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020\u00172\u0006\u0010J\u001a\u00020D2\u0006\u0010K\u001a\u00020$2\u0006\u0010L\u001a\u00020$2\u0006\u0010M\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017J\u0010\u0010O\u001a\u00020?2\b\u0010P\u001a\u0004\u0018\u00010(J(\u0010Q\u001a\u0004\u0018\u00010(2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010R\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017J\u0016\u0010Q\u001a\u00020?2\u0006\u0010G\u001a\u00020$2\u0006\u0010S\u001a\u00020\u0017J&\u0010T\u001a\u00020?2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010R\u001a\u00020\u00172\u0006\u0010U\u001a\u00020\u0004J*\u0010V\u001a\u00020?2\b\u0010G\u001a\u0004\u0018\u00010$2\b\u0010H\u001a\u0004\u0018\u00010$2\u0006\u0010R\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017J&\u0010W\u001a\u00020?2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010R\u001a\u00020\u00172\u0006\u0010U\u001a\u00020\u0004J&\u0010X\u001a\u00020?2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010R\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017J6\u0010Y\u001a\u00020?2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010K\u001a\u00020$2\u0006\u0010L\u001a\u00020$2\u0006\u0010Z\u001a\u00020D2\u0006\u0010N\u001a\u00020\u0017J\u0010\u0010[\u001a\u00020?2\u0006\u0010P\u001a\u00020(H\u0002J\u001e\u0010\\\u001a\u00020?2\u0006\u0010P\u001a\u00020(2\u0006\u0010]\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017J\u001e\u0010^\u001a\u00020?2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010R\u001a\u00020\u0017J\u0006\u0010_\u001a\u00020?J\b\u0010`\u001a\u00020?H\u0002J\u0018\u0010a\u001a\u00020$2\u0006\u0010N\u001a\u00020\u00172\b\u0010=\u001a\u0004\u0018\u000102J\u0006\u0010b\u001a\u00020$J\u0012\u0010c\u001a\u0004\u0018\u00010$2\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u0006\u0010e\u001a\u00020(J\u0006\u0010f\u001a\u00020$J\u0018\u0010g\u001a\u00020$2\u0006\u0010h\u001a\u0002022\u0006\u0010;\u001a\u00020<H\u0002J\u0006\u0010i\u001a\u00020?J\b\u0010j\u001a\u00020?H\u0002J\b\u0010k\u001a\u00020?H\u0002J\u0006\u0010l\u001a\u00020?J\u0006\u0010m\u001a\u00020?J\u0010\u0010n\u001a\u00020\u00172\u0006\u0010o\u001a\u00020\u0015H\u0002J\u000e\u0010p\u001a\u00020?2\u0006\u0010q\u001a\u00020rJ\u0006\u0010s\u001a\u00020\u000fJ\u0010\u0010t\u001a\u0002022\u0006\u0010u\u001a\u00020\u0017H\u0002J\u0010\u0010v\u001a\u0002022\u0006\u0010N\u001a\u00020\u0017H\u0002J\b\u0010w\u001a\u0004\u0018\u00010\u0015J\u0006\u0010x\u001a\u00020\u0017J\u0006\u0010y\u001a\u00020\u0017J\u0006\u0010z\u001a\u00020\u0017J\u000e\u0010{\u001a\u00020\u00172\u0006\u0010|\u001a\u00020\u0001J\u0010\u0010}\u001a\u0004\u0018\u00010(2\u0006\u0010u\u001a\u00020\u0017J\u0010\u0010~\u001a\u00020D2\b\u0010h\u001a\u0004\u0018\u000102J\u001a\u0010\u007f\u001a\u00020$2\b\u0010h\u001a\u0004\u0018\u0001022\b\u0010;\u001a\u0004\u0018\u00010<J\t\u0010\u0080\u0001\u001a\u00020?H\u0002J\u0007\u0010\u0081\u0001\u001a\u00020?J\u000f\u0010\u0082\u0001\u001a\u00020?2\u0006\u0010o\u001a\u00020\u0015J\u0019\u0010\u0083\u0001\u001a\u00020\u00172\u0006\u0010o\u001a\u00020\u00152\u0006\u0010H\u001a\u00020\u0004H\u0002J\t\u0010\u0084\u0001\u001a\u00020?H\u0002J\u000f\u0010\u0085\u0001\u001a\u00020?2\u0006\u0010P\u001a\u00020(J\u0007\u0010\u0086\u0001\u001a\u00020?R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0#X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010&\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010'\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010#X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010-\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010.\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u00100\u001a\"\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020$\u0018\u000101j\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020$\u0018\u0001`3X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001b\"\u0004\b6\u0010\u001dR\u001a\u00107\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0006\"\u0004\b9\u0010\b\u00a8\u0006\u008a\u0001"}, d2={"Landroidx/constraintlayout/core/LinearSystem;", "", "()V", "graphOptimizer", "", "getGraphOptimizer", "()Z", "setGraphOptimizer", "(Z)V", "hasSimpleDefinition", "getHasSimpleDefinition", "setHasSimpleDefinition", "mAlreadyTestedCandidates", "", "mCache", "Landroidx/constraintlayout/core/Cache;", "getMCache", "()Landroidx/constraintlayout/core/Cache;", "setMCache", "(Landroidx/constraintlayout/core/Cache;)V", "mGoal", "Landroidx/constraintlayout/core/LinearSystem$Row;", "mMaxColumns", "", "mMaxRows", "mNumColumns", "getMNumColumns", "()I", "setMNumColumns", "(I)V", "mNumRows", "getMNumRows", "setMNumRows", "mPoolSize", "mPoolVariables", "", "Landroidx/constraintlayout/core/SolverVariable;", "[Landroidx/constraintlayout/core/SolverVariable;", "mPoolVariablesCount", "mRows", "Landroidx/constraintlayout/core/ArrayRow;", "getMRows", "()[Landroidx/constraintlayout/core/ArrayRow;", "setMRows", "([Landroidx/constraintlayout/core/ArrayRow;)V", "[Landroidx/constraintlayout/core/ArrayRow;", "mTableSize", "mTempGoal", "mVariables", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "mVariablesID", "getMVariablesID", "setMVariablesID", "newGraphOptimizer", "getNewGraphOptimizer", "setNewGraphOptimizer", "acquireSolverVariable", "type", "Landroidx/constraintlayout/core/SolverVariable$Type;", "prefix", "addCenterPoint", "", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "target", "angle", "", "radius", "addCentering", "a", "b", "m1", "bias", "c", "d", "m2", "strength", "addConstraint", "row", "addEquality", "margin", "value", "addGreaterBarrier", "hasMatchConstraintWidgets", "addGreaterThan", "addLowerBarrier", "addLowerThan", "addRatio", "ratio", "addRow", "addSingleError", "sign", "addSynonym", "cleanupRows", "computeValues", "createErrorVariable", "createExtraVariable", "createObjectVariable", "anchor", "createRow", "createSlackVariable", "createVariable", "name", "displayReadableRows", "displayRows", "displaySolverVariables", "displaySystemInformation", "displayVariablesReadableRows", "enforceBFS", "goal", "fillMetrics", "metrics", "Landroidx/constraintlayout/core/Metrics;", "getCache", "getDisplaySize", "n", "getDisplayStrength", "getGoal", "getMemoryUsed", "getNumEquations", "getNumVariables", "getObjectVariableValue", "obj", "getRow", "getValueFor", "getVariable", "increaseTableSize", "minimize", "minimizeGoal", "optimize", "releaseRows", "removeRow", "reset", "Companion", "Row", "ValuesRow", "compose"})
@StabilityInferred(parameters=0)
public final class LinearSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mPoolSize = 1000;
    private boolean hasSimpleDefinition;
    private int mVariablesID;
    @Nullable
    private HashMap<String, SolverVariable> mVariables;
    @Nullable
    private Row mGoal;
    private int mTableSize;
    private int mMaxColumns = this.mTableSize = 32;
    @Nullable
    private ArrayRow[] mRows;
    private boolean graphOptimizer;
    private boolean newGraphOptimizer;
    @NotNull
    private boolean[] mAlreadyTestedCandidates = new boolean[this.mTableSize];
    private int mNumColumns = 1;
    private int mNumRows;
    private int mMaxRows = this.mTableSize;
    @NotNull
    private Cache mCache;
    @NotNull
    private SolverVariable[] mPoolVariables = new SolverVariable[this.mPoolSize];
    private int mPoolVariablesCount;
    @Nullable
    private Row mTempGoal;
    public static final int $stable = 8;
    public static final boolean FULL_DEBUG = false;
    public static final boolean DEBUG = false;
    private static final boolean DO_NOT_USE = false;
    private static final boolean DEBUG_CONSTRAINTS = false;
    private static boolean USE_DEPENDENCY_ORDERING;
    private static boolean USE_BASIC_SYNONYMS;
    private static boolean SIMPLIFY_SYNONYMS;
    private static boolean USE_SYNONYMS;
    private static boolean SKIP_COLUMNS;
    private static boolean OPTIMIZED_ENGINE;
    @Nullable
    private static Metrics sMetrics;
    private static long ARRAY_ROW_CREATION;
    private static long OPTIMIZED_ARRAY_ROW_CREATION;

    public LinearSystem() {
        this.mRows = new ArrayRow[this.mTableSize];
        this.releaseRows();
        this.mCache = new Cache();
        this.mGoal = new PriorityGoalRow(this.mCache);
        this.mTempGoal = OPTIMIZED_ENGINE ? (Row)new ValuesRow(this.mCache) : (Row)new ArrayRow(this.mCache);
    }

    public final boolean getHasSimpleDefinition() {
        return this.hasSimpleDefinition;
    }

    public final void setHasSimpleDefinition(boolean bl) {
        this.hasSimpleDefinition = bl;
    }

    public final int getMVariablesID() {
        return this.mVariablesID;
    }

    public final void setMVariablesID(int n) {
        this.mVariablesID = n;
    }

    @Nullable
    public final ArrayRow[] getMRows() {
        return this.mRows;
    }

    public final void setMRows(@Nullable ArrayRow[] arrayRowArray) {
        this.mRows = arrayRowArray;
    }

    public final boolean getGraphOptimizer() {
        return this.graphOptimizer;
    }

    public final void setGraphOptimizer(boolean bl) {
        this.graphOptimizer = bl;
    }

    public final boolean getNewGraphOptimizer() {
        return this.newGraphOptimizer;
    }

    public final void setNewGraphOptimizer(boolean bl) {
        this.newGraphOptimizer = bl;
    }

    public final int getMNumColumns() {
        return this.mNumColumns;
    }

    public final void setMNumColumns(int n) {
        this.mNumColumns = n;
    }

    public final int getMNumRows() {
        return this.mNumRows;
    }

    public final void setMNumRows(int n) {
        this.mNumRows = n;
    }

    @NotNull
    public final Cache getMCache() {
        return this.mCache;
    }

    public final void setMCache(@NotNull Cache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"<set-?>");
        this.mCache = cache;
    }

    public final void fillMetrics(@NotNull Metrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        sMetrics = metrics;
    }

    private final void increaseTableSize() {
        this.mTableSize *= 2;
        Intrinsics.checkNotNull((Object)this.mRows);
        ArrayRow[] arrayRowArray = Arrays.copyOf(this.mRows, this.mTableSize);
        Intrinsics.checkNotNullExpressionValue((Object)arrayRowArray, (String)"copyOf(...)");
        this.mRows = arrayRowArray;
        SolverVariable[] solverVariableArray = Arrays.copyOf(this.mCache.getMIndexedVariables(), this.mTableSize);
        Intrinsics.checkNotNullExpressionValue((Object)solverVariableArray, (String)"copyOf(...)");
        this.mCache.setMIndexedVariables(solverVariableArray);
        this.mAlreadyTestedCandidates = new boolean[this.mTableSize];
        this.mMaxColumns = this.mTableSize;
        this.mMaxRows = this.mTableSize;
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getTableSizeIncrease();
            metrics2.setTableSizeIncrease(l + 1L);
            Metrics metrics3 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics3);
            Metrics metrics4 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics4);
            metrics3.setMaxTableSize(Math.max(metrics4.getMaxTableSize(), (long)this.mTableSize));
            Metrics metrics5 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics5);
            Metrics metrics6 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics6);
            metrics5.setLastTableSize(metrics6.getMaxTableSize());
        }
    }

    private final void releaseRows() {
        if (OPTIMIZED_ENGINE) {
            int n = this.mNumRows;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mRows);
                ArrayRow row = this.mRows[i];
                if (row != null) {
                    this.mCache.getMOptimizedArrayRowPool().release(row);
                }
                Intrinsics.checkNotNull((Object)this.mRows);
                this.mRows[i] = null;
            }
        } else {
            int n = this.mNumRows;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mRows);
                ArrayRow row = this.mRows[i];
                if (row != null) {
                    this.mCache.getMArrayRowPool().release(row);
                }
                Intrinsics.checkNotNull((Object)this.mRows);
                this.mRows[i] = null;
            }
        }
    }

    public final void reset() {
        int i;
        int n = this.mCache.getMIndexedVariables().length;
        for (i = 0; i < n; ++i) {
            SolverVariable solverVariable = this.mCache.getMIndexedVariables()[i];
            if (solverVariable == null) continue;
            solverVariable.reset();
        }
        this.mCache.getMSolverVariablePool().releaseAll((SolverVariable[])this.mPoolVariables, this.mPoolVariablesCount);
        this.mPoolVariablesCount = 0;
        ArraysKt.fill$default((Object[])this.mCache.getMIndexedVariables(), null, (int)0, (int)0, (int)6, null);
        HashMap<String, SolverVariable> hashMap = this.mVariables;
        if (hashMap != null) {
            hashMap.clear();
        }
        this.mVariablesID = 0;
        Row row = this.mGoal;
        Intrinsics.checkNotNull((Object)row);
        row.clear();
        this.mNumColumns = 1;
        n = this.mNumRows;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mRows);
            if (this.mRows[i] == null) continue;
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow);
            arrayRow.setMUsed(false);
        }
        this.releaseRows();
        this.mNumRows = 0;
        this.mTempGoal = OPTIMIZED_ENGINE ? (Row)new ValuesRow(this.mCache) : (Row)new ArrayRow(this.mCache);
    }

    @Nullable
    public final SolverVariable createObjectVariable(@Nullable Object anchor) {
        if (anchor == null) {
            return null;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = null;
        if (anchor instanceof ConstraintAnchor) {
            variable = ((ConstraintAnchor)anchor).getSolverVariable();
            if (variable == null) {
                ((ConstraintAnchor)anchor).resetSolverVariable(this.mCache);
                variable = ((ConstraintAnchor)anchor).getSolverVariable();
            }
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (solverVariable.getId() == -1 || variable.getId() > this.mVariablesID || this.mCache.getMIndexedVariables()[variable.getId()] == null) {
                if (variable.getId() != -1) {
                    variable.reset();
                }
                int n = this.mVariablesID;
                this.mVariablesID = n + 1;
                n = this.mNumColumns;
                this.mNumColumns = n + 1;
                variable.setId(this.mVariablesID);
                variable.setMType(SolverVariable.Type.UNRESTRICTED);
                this.mCache.getMIndexedVariables()[this.mVariablesID] = variable;
            }
        }
        return variable;
    }

    @NotNull
    public final ArrayRow createRow() {
        ArrayRow row = null;
        if (OPTIMIZED_ENGINE) {
            row = this.mCache.getMOptimizedArrayRowPool().acquire();
            if (row == null) {
                row = new ValuesRow(this.mCache);
                long l = OPTIMIZED_ARRAY_ROW_CREATION;
                OPTIMIZED_ARRAY_ROW_CREATION = l + 1L;
            } else {
                row.reset();
            }
        } else {
            row = this.mCache.getMArrayRowPool().acquire();
            if (row == null) {
                row = new ArrayRow(this.mCache);
                long l = ARRAY_ROW_CREATION;
                ARRAY_ROW_CREATION = l + 1L;
            } else {
                row.reset();
            }
        }
        SolverVariable.Companion.increaseErrorId();
        return row;
    }

    @NotNull
    public final SolverVariable createSlackVariable() {
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getSlackvariables();
            metrics2.setSlackvariables(l + 1L);
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        int n = this.mVariablesID;
        this.mVariablesID = n + 1;
        n = this.mNumColumns;
        this.mNumColumns = n + 1;
        variable.setId(this.mVariablesID);
        this.mCache.getMIndexedVariables()[this.mVariablesID] = variable;
        return variable;
    }

    @NotNull
    public final SolverVariable createExtraVariable() {
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getExtravariables();
            metrics2.setExtravariables(l + 1L);
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        int n = this.mVariablesID;
        this.mVariablesID = n + 1;
        n = this.mNumColumns;
        this.mNumColumns = n + 1;
        variable.setId(this.mVariablesID);
        this.mCache.getMIndexedVariables()[this.mVariablesID] = variable;
        return variable;
    }

    public final void addSingleError(@NotNull ArrayRow row, int sign, int strength) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        String prefix = null;
        SolverVariable error = this.createErrorVariable(strength, prefix);
        row.addSingleError(error, sign);
    }

    private final SolverVariable createVariable(String name, SolverVariable.Type type) {
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getVariables();
            metrics2.setVariables(l + 1L);
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(type, null);
        variable.setName(name);
        int n = this.mVariablesID;
        this.mVariablesID = n + 1;
        n = this.mNumColumns;
        this.mNumColumns = n + 1;
        variable.setId(this.mVariablesID);
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        HashMap<String, SolverVariable> hashMap = this.mVariables;
        Intrinsics.checkNotNull(hashMap);
        ((Map)hashMap).put(name, variable);
        this.mCache.getMIndexedVariables()[this.mVariablesID] = variable;
        return variable;
    }

    @NotNull
    public final SolverVariable createErrorVariable(int strength, @Nullable String prefix) {
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getErrors();
            metrics2.setErrors(l + 1L);
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.ERROR, prefix);
        int n = this.mVariablesID;
        this.mVariablesID = n + 1;
        n = this.mNumColumns;
        this.mNumColumns = n + 1;
        variable.setId(this.mVariablesID);
        variable.setStrength(strength);
        this.mCache.getMIndexedVariables()[this.mVariablesID] = variable;
        Row row = this.mGoal;
        Intrinsics.checkNotNull((Object)row);
        row.addError(variable);
        return variable;
    }

    private final SolverVariable acquireSolverVariable(SolverVariable.Type type, String prefix) {
        SolverVariable variable = this.mCache.getMSolverVariablePool().acquire();
        if (variable == null) {
            variable = new SolverVariable(type, String.valueOf(prefix));
            variable.setType(type, prefix);
        } else {
            variable.reset();
            variable.setType(type, prefix);
        }
        if (this.mPoolVariablesCount >= this.mPoolSize) {
            this.mPoolSize *= 2;
            SolverVariable[] solverVariableArray = Arrays.copyOf(this.mPoolVariables, this.mPoolSize);
            Intrinsics.checkNotNullExpressionValue((Object)solverVariableArray, (String)"copyOf(...)");
            this.mPoolVariables = solverVariableArray;
        }
        int n = this.mPoolVariablesCount;
        this.mPoolVariablesCount = n + 1;
        this.mPoolVariables[n] = variable;
        return variable;
    }

    @Nullable
    public final Row getGoal() {
        return this.mGoal;
    }

    @Nullable
    public final ArrayRow getRow(int n) {
        Intrinsics.checkNotNull((Object)this.mRows);
        return this.mRows[n];
    }

    public final float getValueFor(@Nullable String name) {
        SolverVariable v = this.getVariable(name, SolverVariable.Type.UNRESTRICTED);
        return v.getComputedValue();
    }

    public final int getObjectVariableValue(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        ConstraintAnchor anchor = (ConstraintAnchor)obj;
        SolverVariable variable = anchor.getSolverVariable();
        return variable != null ? (int)(variable.getComputedValue() + 0.5f) : 0;
    }

    @NotNull
    public final SolverVariable getVariable(@Nullable String name, @Nullable SolverVariable.Type type) {
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        HashMap<String, SolverVariable> hashMap = this.mVariables;
        Intrinsics.checkNotNull(hashMap);
        SolverVariable variable = (SolverVariable)((Map)hashMap).get(name);
        if (variable == null) {
            String string2 = name;
            Intrinsics.checkNotNull((Object)string2);
            SolverVariable.Type type2 = type;
            Intrinsics.checkNotNull((Object)((Object)type2));
            variable = this.createVariable(string2, type2);
        }
        return variable;
    }

    public final void minimize() throws Exception {
        long l;
        Metrics metrics;
        if (sMetrics != null) {
            Metrics metrics2 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics2);
            metrics = metrics2;
            l = metrics.getMinimize();
            metrics.setMinimize(l + 1L);
        }
        Row row = this.mGoal;
        Intrinsics.checkNotNull((Object)row);
        if (row.isEmpty()) {
            this.computeValues();
            return;
        }
        if (this.graphOptimizer || this.newGraphOptimizer) {
            if (sMetrics != null) {
                Metrics metrics3 = sMetrics;
                Intrinsics.checkNotNull((Object)metrics3);
                metrics = metrics3;
                l = metrics.getGraphOptimizer();
                metrics.setGraphOptimizer(l + 1L);
            }
            boolean fullySolved = true;
            int n = this.mNumRows;
            for (int i = 0; i < n; ++i) {
                ArrayRow r;
                Intrinsics.checkNotNull((Object)this.mRows);
                Intrinsics.checkNotNull((Object)this.mRows[i]);
                if (r.getMIsSimpleDefinition()) continue;
                fullySolved = false;
                break;
            }
            if (!fullySolved) {
                Row row2 = this.mGoal;
                Intrinsics.checkNotNull((Object)row2);
                this.minimizeGoal(row2);
            } else {
                if (sMetrics != null) {
                    Metrics metrics4 = sMetrics;
                    Intrinsics.checkNotNull((Object)metrics4);
                    Metrics metrics5 = metrics4;
                    long l2 = metrics5.getFullySolved();
                    metrics5.setFullySolved(l2 + 1L);
                }
                this.computeValues();
            }
        } else {
            Row row3 = this.mGoal;
            Intrinsics.checkNotNull((Object)row3);
            this.minimizeGoal(row3);
        }
    }

    public final void minimizeGoal(@NotNull Row goal) {
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getMinimizeGoal();
            metrics2.setMinimizeGoal(l + 1L);
            Metrics metrics3 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics3);
            Metrics metrics4 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics4);
            metrics3.setMaxVariables(RangesKt.coerceAtLeast((long)metrics4.getMaxVariables(), (long)this.mNumColumns));
            Metrics metrics5 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics5);
            Metrics metrics6 = sMetrics;
            Intrinsics.checkNotNull((Object)metrics6);
            metrics5.setMaxRows(Math.max(metrics6.getMaxRows(), (long)this.mNumRows));
        }
        this.enforceBFS(goal);
        this.optimize(goal, false);
        this.computeValues();
    }

    public final void cleanupRows() {
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow current;
            Intrinsics.checkNotNull((Object)this.mRows);
            Intrinsics.checkNotNull((Object)this.mRows[i]);
            ArrayRow.ArrayRowVariables arrayRowVariables = current.getVariables();
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            if (arrayRowVariables.getCurrentSize() == 0) {
                current.setMIsSimpleDefinition(true);
            }
            if (!current.getMIsSimpleDefinition()) continue;
            SolverVariable solverVariable = current.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable);
            solverVariable.setComputedValue(current.getMConstantValue());
            SolverVariable solverVariable2 = current.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable2);
            solverVariable2.removeFromRow(current);
            int n = this.mNumRows - 1;
            for (int j = i; j < n; ++j) {
                Intrinsics.checkNotNull((Object)this.mRows);
                Intrinsics.checkNotNull((Object)this.mRows);
                this.mRows[j] = this.mRows[j + 1];
            }
            Intrinsics.checkNotNull((Object)this.mRows);
            this.mRows[this.mNumRows - 1] = null;
            int n2 = this.mNumRows;
            this.mNumRows = n2 + -1;
            --i;
            if (OPTIMIZED_ENGINE) {
                this.mCache.getMOptimizedArrayRowPool().release(current);
                continue;
            }
            this.mCache.getMArrayRowPool().release(current);
        }
    }

    public final void addConstraint(@Nullable ArrayRow row) {
        if (row == null) {
            return;
        }
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getConstraints();
            metrics2.setConstraints(l + 1L);
            if (row.getMIsSimpleDefinition()) {
                Metrics metrics3 = sMetrics;
                Intrinsics.checkNotNull((Object)metrics3);
                metrics2 = metrics3;
                l = metrics2.getSimpleconstraints();
                metrics2.setSimpleconstraints(l + 1L);
            }
        }
        if (this.mNumRows + 1 >= this.mMaxRows || this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        boolean added = false;
        if (!row.getMIsSimpleDefinition()) {
            row.updateFromSystem(this);
            if (row.isEmpty()) {
                return;
            }
            row.ensurePositiveConstant();
            if (row.chooseSubject(this)) {
                SolverVariable extra = this.createExtraVariable();
                row.setMVariable(extra);
                int numRows = this.mNumRows;
                this.addRow(row);
                if (this.mNumRows == numRows + 1) {
                    added = true;
                    Row row2 = this.mTempGoal;
                    Intrinsics.checkNotNull((Object)row2);
                    row2.initFromRow(row);
                    Row row3 = this.mTempGoal;
                    Intrinsics.checkNotNull((Object)row3);
                    this.optimize(row3, true);
                    if (extra.getMDefinitionId() == -1) {
                        SolverVariable pivotCandidate;
                        if (Intrinsics.areEqual((Object)row.getMVariable(), (Object)extra) && (pivotCandidate = row.pickPivot(extra)) != null) {
                            if (sMetrics != null) {
                                Metrics metrics = sMetrics;
                                Intrinsics.checkNotNull((Object)metrics);
                                Metrics metrics4 = metrics;
                                long l = metrics4.getPivots();
                                metrics4.setPivots(l + 1L);
                            }
                            row.pivot(pivotCandidate);
                        }
                        if (!row.getMIsSimpleDefinition()) {
                            SolverVariable solverVariable = row.getMVariable();
                            Intrinsics.checkNotNull((Object)solverVariable);
                            solverVariable.updateReferencesWithNewDefinition(this, row);
                        }
                        if (OPTIMIZED_ENGINE) {
                            this.mCache.getMOptimizedArrayRowPool().release(row);
                        } else {
                            this.mCache.getMArrayRowPool().release(row);
                        }
                        int n = this.mNumRows;
                        this.mNumRows = n + -1;
                    }
                }
            }
            if (!row.hasKeyVariable()) {
                return;
            }
        }
        if (!added) {
            this.addRow(row);
        }
    }

    private final void addRow(ArrayRow row) {
        if (SIMPLIFY_SYNONYMS && row.getMIsSimpleDefinition()) {
            SolverVariable solverVariable = row.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable);
            solverVariable.setFinalValue(this, row.getMConstantValue());
        } else {
            Intrinsics.checkNotNull((Object)this.mRows);
            this.mRows[this.mNumRows] = row;
            SolverVariable solverVariable = row.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable);
            solverVariable.setMDefinitionId(this.mNumRows);
            int n = this.mNumRows;
            this.mNumRows = n + 1;
            SolverVariable solverVariable2 = row.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable2);
            solverVariable2.updateReferencesWithNewDefinition(this, row);
        }
        if (SIMPLIFY_SYNONYMS && this.hasSimpleDefinition) {
            for (int i = 0; i < this.mNumRows; ++i) {
                ArrayRow removedRow;
                Intrinsics.checkNotNull((Object)this.mRows);
                if (this.mRows[i] == null) {
                    System.out.println((Object)"WTF");
                }
                Intrinsics.checkNotNull((Object)this.mRows);
                if (this.mRows[i] == null) continue;
                Intrinsics.checkNotNull((Object)this.mRows);
                ArrayRow arrayRow = this.mRows[i];
                Intrinsics.checkNotNull((Object)arrayRow);
                if (!arrayRow.getMIsSimpleDefinition()) continue;
                Intrinsics.checkNotNull((Object)this.mRows);
                Intrinsics.checkNotNull((Object)this.mRows[i]);
                SolverVariable solverVariable = removedRow.getMVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                solverVariable.setFinalValue(this, removedRow.getMConstantValue());
                if (OPTIMIZED_ENGINE) {
                    this.mCache.getMOptimizedArrayRowPool().release(removedRow);
                } else {
                    this.mCache.getMArrayRowPool().release(removedRow);
                }
                Intrinsics.checkNotNull((Object)this.mRows);
                this.mRows[i] = null;
                int lastRow = i + 1;
                int j = i + 1;
                int n = this.mNumRows;
                while (j < n) {
                    Intrinsics.checkNotNull((Object)this.mRows);
                    Intrinsics.checkNotNull((Object)this.mRows);
                    this.mRows[j - 1] = this.mRows[j];
                    Intrinsics.checkNotNull((Object)this.mRows);
                    ArrayRow arrayRow2 = this.mRows[j - 1];
                    Intrinsics.checkNotNull((Object)arrayRow2);
                    SolverVariable solverVariable3 = arrayRow2.getMVariable();
                    Intrinsics.checkNotNull((Object)solverVariable3);
                    if (solverVariable3.getMDefinitionId() == j) {
                        Intrinsics.checkNotNull((Object)this.mRows);
                        ArrayRow arrayRow3 = this.mRows[j - 1];
                        Intrinsics.checkNotNull((Object)arrayRow3);
                        SolverVariable solverVariable4 = arrayRow3.getMVariable();
                        Intrinsics.checkNotNull((Object)solverVariable4);
                        solverVariable4.setMDefinitionId(j - 1);
                    }
                    lastRow = j++;
                }
                if (lastRow < this.mNumRows) {
                    Intrinsics.checkNotNull((Object)this.mRows);
                    this.mRows[lastRow] = null;
                }
                int n2 = this.mNumRows;
                this.mNumRows = n2 + -1;
                --i;
            }
            this.hasSimpleDefinition = false;
        }
    }

    public final void removeRow(@NotNull ArrayRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (row.getMIsSimpleDefinition() && row.getMVariable() != null) {
            SolverVariable solverVariable = row.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable);
            if (solverVariable.getMDefinitionId() != -1) {
                Intrinsics.checkNotNull((Object)row.getMVariable());
                int n = this.mNumRows - 1;
                for (int i = (v47256).getMDefinitionId(); i < n; ++i) {
                    SolverVariable rowVariable;
                    Intrinsics.checkNotNull((Object)this.mRows);
                    ArrayRow arrayRow = this.mRows[i + 1];
                    Intrinsics.checkNotNull((Object)arrayRow);
                    Intrinsics.checkNotNull((Object)arrayRow.getMVariable());
                    if (rowVariable.getMDefinitionId() == i + 1) {
                        rowVariable.setMDefinitionId(i);
                    }
                    Intrinsics.checkNotNull((Object)this.mRows);
                    Intrinsics.checkNotNull((Object)this.mRows);
                    this.mRows[i] = this.mRows[i + 1];
                }
                int n2 = this.mNumRows;
                this.mNumRows = n2 + -1;
            }
            SolverVariable solverVariable2 = row.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable2);
            if (!solverVariable2.isFinalValue()) {
                SolverVariable solverVariable3 = row.getMVariable();
                Intrinsics.checkNotNull((Object)solverVariable3);
                solverVariable3.setFinalValue(this, row.getMConstantValue());
            }
            if (OPTIMIZED_ENGINE) {
                this.mCache.getMOptimizedArrayRowPool().release(row);
            } else {
                this.mCache.getMArrayRowPool().release(row);
            }
        }
    }

    private final int optimize(Row goal, boolean b) {
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getOptimize();
            metrics2.setOptimize(l + 1L);
        }
        boolean done = false;
        int tries = 0;
        int n = this.mNumColumns;
        for (int i = 0; i < n; ++i) {
            this.mAlreadyTestedCandidates[i] = false;
        }
        while (!done) {
            if (sMetrics != null) {
                Metrics i;
                Intrinsics.checkNotNull((Object)sMetrics);
                long l = i.getIterations();
                i.setIterations(l + 1L);
            }
            if (++tries >= 2 * this.mNumColumns) {
                return tries;
            }
            if (goal.getKey() != null) {
                SolverVariable solverVariable = goal.getKey();
                Intrinsics.checkNotNull((Object)solverVariable);
                this.mAlreadyTestedCandidates[solverVariable.getId()] = true;
            }
            SolverVariable pivotCandidate = goal.getPivotCandidate(this, this.mAlreadyTestedCandidates);
            if (pivotCandidate != null) {
                if (this.mAlreadyTestedCandidates[pivotCandidate.getId()]) {
                    return tries;
                }
                this.mAlreadyTestedCandidates[pivotCandidate.getId()] = true;
            }
            if (pivotCandidate != null) {
                ArrayRow pivotEquation;
                float min = Float.MAX_VALUE;
                int pivotRowIndex = -1;
                int n2 = this.mNumRows;
                for (int i = 0; i < n2; ++i) {
                    float value;
                    SolverVariable variable;
                    ArrayRow current;
                    Intrinsics.checkNotNull((Object)this.mRows);
                    Intrinsics.checkNotNull((Object)this.mRows[i]);
                    Intrinsics.checkNotNull((Object)current.getMVariable());
                    if (variable.getMType() == SolverVariable.Type.UNRESTRICTED || current.getMIsSimpleDefinition() || !current.hasVariable(pivotCandidate)) continue;
                    ArrayRow.ArrayRowVariables arrayRowVariables = current.getVariables();
                    Intrinsics.checkNotNull((Object)arrayRowVariables);
                    float a_j = arrayRowVariables.get(pivotCandidate);
                    if (!(a_j < 0.0f) || !((value = -current.getMConstantValue() / a_j) < min)) continue;
                    min = value;
                    pivotRowIndex = i;
                }
                if (pivotRowIndex <= -1) continue;
                Intrinsics.checkNotNull((Object)this.mRows);
                Intrinsics.checkNotNull((Object)this.mRows[pivotRowIndex]);
                SolverVariable solverVariable = pivotEquation.getMVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                solverVariable.setMDefinitionId(-1);
                if (sMetrics != null) {
                    Metrics metrics;
                    Intrinsics.checkNotNull((Object)sMetrics);
                    long l = metrics.getPivots();
                    metrics.setPivots(l + 1L);
                }
                pivotEquation.pivot(pivotCandidate);
                SolverVariable solverVariable2 = pivotEquation.getMVariable();
                Intrinsics.checkNotNull((Object)solverVariable2);
                solverVariable2.setMDefinitionId(pivotRowIndex);
                SolverVariable solverVariable3 = pivotEquation.getMVariable();
                Intrinsics.checkNotNull((Object)solverVariable3);
                solverVariable3.updateReferencesWithNewDefinition(this, pivotEquation);
                continue;
            }
            done = true;
        }
        return tries;
    }

    private final int enforceBFS(Row goal) {
        int tries = 0;
        boolean done = false;
        boolean infeasibleSystem = false;
        int n = this.mNumRows;
        for (int i = 0; i < n; ++i) {
            SolverVariable variable;
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow);
            Intrinsics.checkNotNull((Object)arrayRow.getMVariable());
            if (variable.getMType() == SolverVariable.Type.UNRESTRICTED) continue;
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow2 = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow2);
            if (!(arrayRow2.getMConstantValue() < 0.0f)) continue;
            infeasibleSystem = true;
            break;
        }
        if (infeasibleSystem) {
            done = false;
            tries = 0;
            while (!done) {
                if (sMetrics != null) {
                    Metrics i;
                    Intrinsics.checkNotNull((Object)sMetrics);
                    long l = i.getBfs();
                    i.setBfs(l + 1L);
                }
                ++tries;
                float min = Float.MAX_VALUE;
                int strength = 0;
                int pivotRowIndex = -1;
                int pivotColumnIndex = -1;
                int n2 = this.mNumRows;
                for (int i = 0; i < n2; ++i) {
                    float value;
                    int k;
                    float a_j;
                    SolverVariable candidate;
                    SolverVariable variable;
                    ArrayRow current;
                    Intrinsics.checkNotNull((Object)this.mRows);
                    Intrinsics.checkNotNull((Object)this.mRows[i]);
                    Intrinsics.checkNotNull((Object)current.getMVariable());
                    if (variable.getMType() == SolverVariable.Type.UNRESTRICTED || current.getMIsSimpleDefinition() || !(current.getMConstantValue() < 0.0f)) continue;
                    if (SKIP_COLUMNS) {
                        ArrayRow.ArrayRowVariables arrayRowVariables = current.getVariables();
                        Intrinsics.checkNotNull((Object)arrayRowVariables);
                        int size = arrayRowVariables.getCurrentSize();
                        for (int j = 0; j < size; ++j) {
                            ArrayRow.ArrayRowVariables arrayRowVariables2 = current.getVariables();
                            Intrinsics.checkNotNull((Object)arrayRowVariables2);
                            candidate = arrayRowVariables2.getVariable(j);
                            ArrayRow.ArrayRowVariables arrayRowVariables3 = current.getVariables();
                            Intrinsics.checkNotNull((Object)arrayRowVariables3);
                            a_j = arrayRowVariables3.get(candidate);
                            if (a_j <= 0.0f) continue;
                            for (k = 0; k < 9; ++k) {
                                SolverVariable solverVariable = candidate;
                                Intrinsics.checkNotNull((Object)solverVariable);
                                value = solverVariable.getMStrengthVector()[k] / a_j;
                                if (!(value < min && k == strength) && k <= strength) continue;
                                min = value;
                                pivotRowIndex = i;
                                pivotColumnIndex = candidate.getId();
                                strength = k;
                            }
                        }
                        continue;
                    }
                    int n3 = this.mNumColumns;
                    for (int j = 1; j < n3; ++j) {
                        candidate = this.mCache.getMIndexedVariables()[j];
                        ArrayRow.ArrayRowVariables arrayRowVariables = current.getVariables();
                        Intrinsics.checkNotNull((Object)arrayRowVariables);
                        a_j = arrayRowVariables.get(candidate);
                        if (a_j <= 0.0f) continue;
                        for (k = 0; k < 9; ++k) {
                            SolverVariable solverVariable = candidate;
                            Intrinsics.checkNotNull((Object)solverVariable);
                            value = solverVariable.getMStrengthVector()[k] / a_j;
                            if (!(value < min && k == strength) && k <= strength) continue;
                            min = value;
                            pivotRowIndex = i;
                            pivotColumnIndex = j;
                            strength = k;
                        }
                    }
                }
                if (pivotRowIndex != -1) {
                    ArrayRow pivotEquation;
                    Intrinsics.checkNotNull((Object)this.mRows);
                    Intrinsics.checkNotNull((Object)this.mRows[pivotRowIndex]);
                    SolverVariable solverVariable = pivotEquation.getMVariable();
                    Intrinsics.checkNotNull((Object)solverVariable);
                    solverVariable.setMDefinitionId(-1);
                    if (sMetrics != null) {
                        Metrics metrics;
                        Intrinsics.checkNotNull((Object)sMetrics);
                        long l = metrics.getPivots();
                        metrics.setPivots(l + 1L);
                    }
                    SolverVariable solverVariable2 = this.mCache.getMIndexedVariables()[pivotColumnIndex];
                    Intrinsics.checkNotNull((Object)solverVariable2);
                    pivotEquation.pivot(solverVariable2);
                    SolverVariable solverVariable3 = pivotEquation.getMVariable();
                    Intrinsics.checkNotNull((Object)solverVariable3);
                    solverVariable3.setMDefinitionId(pivotRowIndex);
                    SolverVariable solverVariable4 = pivotEquation.getMVariable();
                    Intrinsics.checkNotNull((Object)solverVariable4);
                    solverVariable4.updateReferencesWithNewDefinition(this, pivotEquation);
                } else {
                    done = true;
                }
                if (tries <= this.mNumColumns / 2) continue;
                done = true;
            }
        }
        return tries;
    }

    private final void computeValues() {
        int n = this.mNumRows;
        for (int i = 0; i < n; ++i) {
            ArrayRow row;
            Intrinsics.checkNotNull((Object)this.mRows);
            Intrinsics.checkNotNull((Object)this.mRows[i]);
            SolverVariable solverVariable = row.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable);
            solverVariable.setComputedValue(row.getMConstantValue());
        }
    }

    private final void displayRows() {
        this.displaySolverVariables();
        Object s = "";
        int n = this.mNumRows;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mRows);
            s = (String)s + this.mRows[i];
            s = (String)s + "\n";
        }
        s = (String)s + this.mGoal + "\n";
        System.out.println(s);
    }

    public final void displayReadableRows() {
        SolverVariable variable;
        int i;
        this.displaySolverVariables();
        String s = " num vars " + this.mVariablesID + "\n";
        int n = this.mVariablesID + 1;
        for (i = 0; i < n; ++i) {
            variable = this.mCache.getMIndexedVariables()[i];
            if (variable == null || !variable.isFinalValue()) continue;
            s = s + " $[" + i + "] => " + variable + " = " + variable.getComputedValue() + "\n";
        }
        s = s + "\n";
        n = this.mVariablesID + 1;
        for (i = 0; i < n; ++i) {
            variable = this.mCache.getMIndexedVariables()[i];
            if (variable == null || !variable.getMIsSynonym()) continue;
            SolverVariable synonym = this.mCache.getMIndexedVariables()[variable.getMSynonym()];
            s = s + " ~[" + i + "] => " + variable + " = " + synonym + " + " + variable.getMSynonymDelta() + "\n";
        }
        s = s + "\n\n #  ";
        n = this.mNumRows;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow);
            s = s + arrayRow.toReadableString();
            s = s + "\n #  ";
        }
        if (this.mGoal != null) {
            s = s + "Goal: " + this.mGoal + "\n";
        }
        System.out.println((Object)s);
    }

    public final void displayVariablesReadableRows() {
        this.displaySolverVariables();
        Object s = "";
        int n = this.mNumRows;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow);
            SolverVariable solverVariable = arrayRow.getMVariable();
            Intrinsics.checkNotNull((Object)solverVariable);
            if (solverVariable.getMType() != SolverVariable.Type.UNRESTRICTED) continue;
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow2 = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow2);
            s = (String)s + arrayRow2.toReadableString();
            s = (String)s + "\n";
        }
        s = (String)s + this.mGoal + "\n";
        System.out.println(s);
    }

    public final int getMemoryUsed() {
        int actualRowSize = 0;
        int n = this.mNumRows;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mRows);
            if (this.mRows[i] == null) continue;
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow);
            actualRowSize += arrayRow.sizeInBytes();
        }
        return actualRowSize;
    }

    public final int getNumEquations() {
        return this.mNumRows;
    }

    public final int getNumVariables() {
        return this.mVariablesID;
    }

    public final void displaySystemInformation() {
        int count = 0;
        int rowSize = 0;
        int n = this.mTableSize;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mRows);
            if (this.mRows[i] == null) continue;
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow);
            rowSize += arrayRow.sizeInBytes();
        }
        int actualRowSize = 0;
        int n2 = this.mNumRows;
        for (int i = 0; i < n2; ++i) {
            Intrinsics.checkNotNull((Object)this.mRows);
            if (this.mRows[i] == null) continue;
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[i];
            Intrinsics.checkNotNull((Object)arrayRow);
            actualRowSize += arrayRow.sizeInBytes();
        }
        String string2 = "Linear System -> Table size: " + this.mTableSize + " (" + this.getDisplaySize(this.mTableSize * this.mTableSize) + ") -- row sizes: " + this.getDisplaySize(rowSize) + ", actual size: " + this.getDisplaySize(actualRowSize) + " rows: " + this.mNumRows + "/" + this.mMaxRows + " cols: " + this.mNumColumns + "/" + this.mMaxColumns + " " + count + " occupied cells, " + this.getDisplaySize(count);
        System.out.println((Object)string2);
    }

    private final void displaySolverVariables() {
        String s = "Display Rows (" + this.mNumRows + "x" + this.mNumColumns + ")\n";
        System.out.println((Object)s);
    }

    private final String getDisplaySize(int n) {
        int mb = n * 4 / 1024 / 1024;
        if (mb > 0) {
            return mb + " Mb";
        }
        int kb = n * 4 / 1024;
        return kb > 0 ? kb + " Kb" : n * 4 + " bytes";
    }

    @NotNull
    public final Cache getCache() {
        return this.mCache;
    }

    private final String getDisplayStrength(int strength) {
        if (strength == 1) {
            return "LOW";
        }
        if (strength == 2) {
            return "MEDIUM";
        }
        if (strength == 3) {
            return "HIGH";
        }
        if (strength == 4) {
            return "HIGHEST";
        }
        if (strength == 5) {
            return "EQUALITY";
        }
        if (strength == 8) {
            return "FIXED";
        }
        return strength == 6 ? "BARRIER" : "NONE";
    }

    public final void addGreaterThan(@Nullable SolverVariable a, @Nullable SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.setStrength(0);
        row.createRowGreaterThan(a, b, slack, margin);
        if (strength != 8) {
            ArrayRow.ArrayRowVariables arrayRowVariables = row.getVariables();
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            float slackValue = arrayRowVariables.get(slack);
            this.addSingleError(row, (int)((float)-1 * slackValue), strength);
        }
        this.addConstraint(row);
    }

    public final void addGreaterBarrier(@NotNull SolverVariable a, @NotNull SolverVariable b, int margin, boolean hasMatchConstraintWidgets) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.setStrength(0);
        row.createRowGreaterThan(a, b, slack, margin);
        this.addConstraint(row);
    }

    public final void addLowerThan(@NotNull SolverVariable a, @NotNull SolverVariable b, int margin, int strength) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.setStrength(0);
        row.createRowLowerThan(a, b, slack, margin);
        if (strength != 8) {
            ArrayRow.ArrayRowVariables arrayRowVariables = row.getVariables();
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            float slackValue = arrayRowVariables.get(slack);
            this.addSingleError(row, (int)((float)-1 * slackValue), strength);
        }
        this.addConstraint(row);
    }

    public final void addLowerBarrier(@NotNull SolverVariable a, @NotNull SolverVariable b, int margin, boolean hasMatchConstraintWidgets) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.setStrength(0);
        row.createRowLowerThan(a, b, slack, margin);
        this.addConstraint(row);
    }

    public final void addCentering(@NotNull SolverVariable a, @NotNull SolverVariable b, int m1, float bias, @NotNull SolverVariable c, @NotNull SolverVariable d, int m2, int strength) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        ArrayRow row = this.createRow();
        row.createRowCentering(a, b, m1, bias, c, d, m2);
        if (strength != 8) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
    }

    public final void addRatio(@NotNull SolverVariable a, @NotNull SolverVariable b, @NotNull SolverVariable c, @NotNull SolverVariable d, float ratio, int strength) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        ArrayRow row = this.createRow();
        row.createRowDimensionRatio(a, b, c, d, ratio);
        if (strength != 8) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
    }

    public final void addSynonym(@NotNull SolverVariable a, @NotNull SolverVariable b, int margin) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        SolverVariable a2 = a;
        SolverVariable b2 = b;
        int margin2 = margin;
        if (a2.getMDefinitionId() == -1 && margin2 == 0) {
            if (b2.getMIsSynonym()) {
                margin2 += (int)b2.getMSynonymDelta();
                SolverVariable solverVariable = this.mCache.getMIndexedVariables()[b2.getMSynonym()];
                Intrinsics.checkNotNull((Object)solverVariable);
                b2 = solverVariable;
            }
            if (a2.getMIsSynonym()) {
                margin2 -= (int)a2.getMSynonymDelta();
                SolverVariable solverVariable = this.mCache.getMIndexedVariables()[a2.getMSynonym()];
                Intrinsics.checkNotNull((Object)solverVariable);
                a2 = solverVariable;
            } else {
                a2.setSynonym(this, b2, 0.0f);
            }
        } else {
            this.addEquality(a2, b2, margin2, 8);
        }
    }

    @Nullable
    public final ArrayRow addEquality(@NotNull SolverVariable a, @NotNull SolverVariable b, int margin, int strength) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        SolverVariable a2 = a;
        SolverVariable b2 = b;
        int margin2 = margin;
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getMSimpleEquations();
            metrics2.setMSimpleEquations(l + 1L);
        }
        if (USE_BASIC_SYNONYMS && strength == 8 && b2.isFinalValue() && a2.getMDefinitionId() == -1) {
            a2.setFinalValue(this, b2.getComputedValue() + (float)margin2);
            return null;
        }
        ArrayRow row = this.createRow();
        row.createRowEquals(a2, b2, margin2);
        if (strength != 8) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
        return row;
    }

    public final void addEquality(@NotNull SolverVariable a, int value) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (sMetrics != null) {
            Metrics metrics = sMetrics;
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getMSimpleEquations();
            metrics2.setMSimpleEquations(l + 1L);
        }
        if (USE_BASIC_SYNONYMS && a.getMDefinitionId() == -1) {
            a.setFinalValue(this, value);
            int n = this.mVariablesID + 1;
            for (int i = 0; i < n; ++i) {
                SolverVariable variable = this.mCache.getMIndexedVariables()[i];
                if (variable == null || !variable.getMIsSynonym() || variable.getMSynonym() != a.getId()) continue;
                variable.setFinalValue(this, (float)value + variable.getMSynonymDelta());
            }
            return;
        }
        int idx = a.getMDefinitionId();
        if (a.getMDefinitionId() != -1) {
            Intrinsics.checkNotNull((Object)this.mRows);
            ArrayRow arrayRow = this.mRows[idx];
            Intrinsics.checkNotNull((Object)arrayRow);
            ArrayRow row = arrayRow;
            if (row.getMIsSimpleDefinition()) {
                row.setMConstantValue(value);
            } else {
                ArrayRow.ArrayRowVariables arrayRowVariables = row.getVariables();
                Intrinsics.checkNotNull((Object)arrayRowVariables);
                if (arrayRowVariables.getCurrentSize() == 0) {
                    row.setMIsSimpleDefinition(true);
                    row.setMConstantValue(value);
                } else {
                    ArrayRow newRow = this.createRow();
                    newRow.createRowEquals(a, value);
                    this.addConstraint(newRow);
                }
            }
        } else {
            ArrayRow row = this.createRow();
            row.createRowDefinition(a, value);
            this.addConstraint(row);
        }
    }

    public final void addCenterPoint(@NotNull ConstraintWidget widget, @NotNull ConstraintWidget target, float angle, int radius) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        SolverVariable Al = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable At = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable Ar = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable Ab = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.BOTTOM));
        SolverVariable Bl = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable Bt = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable Br = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable Bb = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.BOTTOM));
        ArrayRow row = this.createRow();
        float angleComponent = (float)(Math.sin(angle) * (double)radius);
        row.createRowWithAngle(At, Ab, Bt, Bb, angleComponent);
        this.addConstraint(row);
        row = this.createRow();
        angleComponent = (float)(Math.cos(angle) * (double)radius);
        row.createRowWithAngle(Al, Ar, Bl, Br, angleComponent);
        this.addConstraint(row);
    }

    static {
        USE_BASIC_SYNONYMS = true;
        SIMPLIFY_SYNONYMS = true;
        USE_SYNONYMS = true;
        SKIP_COLUMNS = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000203J\b\u00104\u001a\u0004\u0018\u00010&R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00065"}, d2={"Landroidx/constraintlayout/core/LinearSystem$Companion;", "", "()V", "ARRAY_ROW_CREATION", "", "getARRAY_ROW_CREATION", "()J", "setARRAY_ROW_CREATION", "(J)V", "DEBUG", "", "DEBUG_CONSTRAINTS", "DO_NOT_USE", "FULL_DEBUG", "OPTIMIZED_ARRAY_ROW_CREATION", "getOPTIMIZED_ARRAY_ROW_CREATION", "setOPTIMIZED_ARRAY_ROW_CREATION", "OPTIMIZED_ENGINE", "getOPTIMIZED_ENGINE", "()Z", "setOPTIMIZED_ENGINE", "(Z)V", "SIMPLIFY_SYNONYMS", "getSIMPLIFY_SYNONYMS", "setSIMPLIFY_SYNONYMS", "SKIP_COLUMNS", "getSKIP_COLUMNS", "setSKIP_COLUMNS", "USE_BASIC_SYNONYMS", "getUSE_BASIC_SYNONYMS", "setUSE_BASIC_SYNONYMS", "USE_DEPENDENCY_ORDERING", "getUSE_DEPENDENCY_ORDERING", "setUSE_DEPENDENCY_ORDERING", "USE_SYNONYMS", "getUSE_SYNONYMS", "setUSE_SYNONYMS", "sMetrics", "Landroidx/constraintlayout/core/Metrics;", "getSMetrics", "()Landroidx/constraintlayout/core/Metrics;", "setSMetrics", "(Landroidx/constraintlayout/core/Metrics;)V", "createRowDimensionPercent", "Landroidx/constraintlayout/core/ArrayRow;", "linearSystem", "Landroidx/constraintlayout/core/LinearSystem;", "variableA", "Landroidx/constraintlayout/core/SolverVariable;", "variableC", "percent", "", "getMetrics", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getUSE_DEPENDENCY_ORDERING() {
            return USE_DEPENDENCY_ORDERING;
        }

        public final void setUSE_DEPENDENCY_ORDERING(boolean bl) {
            USE_DEPENDENCY_ORDERING = bl;
        }

        public final boolean getUSE_BASIC_SYNONYMS() {
            return USE_BASIC_SYNONYMS;
        }

        public final void setUSE_BASIC_SYNONYMS(boolean bl) {
            USE_BASIC_SYNONYMS = bl;
        }

        public final boolean getSIMPLIFY_SYNONYMS() {
            return SIMPLIFY_SYNONYMS;
        }

        public final void setSIMPLIFY_SYNONYMS(boolean bl) {
            SIMPLIFY_SYNONYMS = bl;
        }

        public final boolean getUSE_SYNONYMS() {
            return USE_SYNONYMS;
        }

        public final void setUSE_SYNONYMS(boolean bl) {
            USE_SYNONYMS = bl;
        }

        public final boolean getSKIP_COLUMNS() {
            return SKIP_COLUMNS;
        }

        public final void setSKIP_COLUMNS(boolean bl) {
            SKIP_COLUMNS = bl;
        }

        public final boolean getOPTIMIZED_ENGINE() {
            return OPTIMIZED_ENGINE;
        }

        public final void setOPTIMIZED_ENGINE(boolean bl) {
            OPTIMIZED_ENGINE = bl;
        }

        @Nullable
        public final Metrics getSMetrics() {
            return sMetrics;
        }

        public final void setSMetrics(@Nullable Metrics metrics) {
            sMetrics = metrics;
        }

        @Nullable
        public final Metrics getMetrics() {
            return this.getSMetrics();
        }

        public final long getARRAY_ROW_CREATION() {
            return ARRAY_ROW_CREATION;
        }

        public final void setARRAY_ROW_CREATION(long l) {
            ARRAY_ROW_CREATION = l;
        }

        public final long getOPTIMIZED_ARRAY_ROW_CREATION() {
            return OPTIMIZED_ARRAY_ROW_CREATION;
        }

        public final void setOPTIMIZED_ARRAY_ROW_CREATION(long l) {
            OPTIMIZED_ARRAY_ROW_CREATION = l;
        }

        @NotNull
        public final ArrayRow createRowDimensionPercent(@NotNull LinearSystem linearSystem, @NotNull SolverVariable variableA, @NotNull SolverVariable variableC, float percent) {
            Intrinsics.checkNotNullParameter((Object)linearSystem, (String)"linearSystem");
            Intrinsics.checkNotNullParameter((Object)variableA, (String)"variableA");
            Intrinsics.checkNotNullParameter((Object)variableC, (String)"variableC");
            ArrayRow row = linearSystem.createRow();
            return row.createRowDimensionPercent(variableA, variableC, percent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H&J\b\u0010\f\u001a\u00020\nH&J\u001e\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H&J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000H&J$\u0010\u0014\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0003H&J$\u0010\u0016\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0003H&J\u0012\u0010\u001a\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Landroidx/constraintlayout/core/LinearSystem$Row;", "", "isEmpty", "", "()Z", "key", "Landroidx/constraintlayout/core/SolverVariable;", "getKey", "()Landroidx/constraintlayout/core/SolverVariable;", "addError", "", "variable", "clear", "getPivotCandidate", "system", "Landroidx/constraintlayout/core/LinearSystem;", "avoid", "", "initFromRow", "row", "updateFromFinalVariable", "removeFromDefinition", "updateFromRow", "definition", "Landroidx/constraintlayout/core/ArrayRow;", "b", "updateFromSystem", "compose"})
    public static interface Row {
        @Nullable
        public SolverVariable getPivotCandidate(@Nullable LinearSystem var1, @Nullable boolean[] var2);

        public void clear();

        public void initFromRow(@Nullable Row var1);

        public void addError(@Nullable SolverVariable var1);

        public void updateFromSystem(@Nullable LinearSystem var1);

        @Nullable
        public SolverVariable getKey();

        public boolean isEmpty();

        public void updateFromRow(@Nullable LinearSystem var1, @Nullable ArrayRow var2, boolean var3);

        public void updateFromFinalVariable(@Nullable LinearSystem var1, @Nullable SolverVariable var2, boolean var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/constraintlayout/core/LinearSystem$ValuesRow;", "Landroidx/constraintlayout/core/ArrayRow;", "cache", "Landroidx/constraintlayout/core/Cache;", "(Landroidx/constraintlayout/core/LinearSystem;Landroidx/constraintlayout/core/Cache;)V", "compose"})
    public final class ValuesRow
    extends ArrayRow {
        public ValuesRow(Cache cache) {
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            this.setVariables(new SolverVariableValues(this, cache));
        }
    }
}

