/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.SolverVariable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0018\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u0000 @2\u00020\u0001:\u0001@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020$H\u0016J\u0013\u0010)\u001a\u00020\u001c2\b\u0010%\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010*\u001a\u00020$H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\"H\u0016J\u0013\u0010-\u001a\u00020\"2\b\u0010%\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0006\u0010.\u001a\u00020\bJ\u000e\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bJ\u000e\u00101\u001a\u00020\b2\u0006\u00100\u001a\u00020\bJ\b\u00102\u001a\u0004\u0018\u00010\u0016J\u000e\u00103\u001a\u00020\"2\u0006\u00100\u001a\u00020\bJ\u0012\u00104\u001a\u0004\u0018\u00010\u00162\u0006\u00100\u001a\u00020\bH\u0016J\u0010\u00105\u001a\u00020\"2\u0006\u00100\u001a\u00020\bH\u0016J\u0006\u00106\u001a\u00020\u001cJ\u0012\u00107\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u00108\u001a\u00020$H\u0016J\u001a\u00109\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010&\u001a\u00020\"H\u0016J\u001a\u0010:\u001a\u00020\"2\b\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020\u001cH\u0016J\b\u0010;\u001a\u00020\bH\u0016J\b\u0010<\u001a\u00020=H\u0016J\u001a\u0010>\u001a\u00020\"2\b\u0010?\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u001cH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Landroidx/constraintlayout/core/ArrayLinkedVariables;", "Landroidx/constraintlayout/core/ArrayRow$ArrayRowVariables;", "arrayRow", "Landroidx/constraintlayout/core/ArrayRow;", "cache", "Landroidx/constraintlayout/core/Cache;", "(Landroidx/constraintlayout/core/ArrayRow;Landroidx/constraintlayout/core/Cache;)V", "currentSize", "", "getCurrentSize", "()I", "mArrayIndices", "", "mArrayNextIndices", "mArrayValues", "", "mCache", "getMCache", "()Landroidx/constraintlayout/core/Cache;", "setMCache", "(Landroidx/constraintlayout/core/Cache;)V", "mCandidate", "Landroidx/constraintlayout/core/SolverVariable;", "mCurrentSize", "getMCurrentSize", "setMCurrentSize", "(I)V", "mDidFillOnce", "", "mHead", "mLast", "mRow", "mRowSize", "sEpsilon", "", "add", "", "variable", "value", "removeFromDefinition", "clear", "contains", "display", "divideByAmount", "amount", "get", "getHead", "getId", "index", "getNextIndice", "getPivotCandidate", "getValue", "getVariable", "getVariableValue", "hasAtLeastOnePositiveVariable", "indexOf", "invert", "put", "remove", "sizeInBytes", "toString", "", "use", "definition", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class ArrayLinkedVariables
implements ArrayRow.ArrayRowVariables {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mCurrentSize;
    @Nullable
    private ArrayRow mRow;
    @Nullable
    private Cache mCache;
    private int mRowSize;
    @Nullable
    private SolverVariable mCandidate;
    @NotNull
    private int[] mArrayIndices;
    @NotNull
    private int[] mArrayNextIndices;
    @NotNull
    private float[] mArrayValues;
    private int mHead;
    private int mLast;
    private boolean mDidFillOnce;
    private final float sEpsilon;
    public static final int $stable = 8;
    private static final boolean DEBUG = false;
    public static final int NONE = -1;

    public ArrayLinkedVariables(@NotNull ArrayRow arrayRow, @NotNull Cache cache) {
        Intrinsics.checkNotNullParameter((Object)arrayRow, (String)"arrayRow");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.mRow = arrayRow;
        this.mCache = cache;
        this.mRowSize = 8;
        this.mArrayIndices = new int[this.mRowSize];
        this.mArrayNextIndices = new int[this.mRowSize];
        this.mArrayValues = new float[this.mRowSize];
        this.mHead = -1;
        this.mLast = -1;
        this.sEpsilon = 0.001f;
    }

    public final int getMCurrentSize() {
        return this.mCurrentSize;
    }

    public final void setMCurrentSize(int n) {
        this.mCurrentSize = n;
    }

    @Nullable
    protected final Cache getMCache() {
        return this.mCache;
    }

    protected final void setMCache(@Nullable Cache cache) {
        this.mCache = cache;
    }

    @Override
    public void put(@Nullable SolverVariable variable, float value) {
        if (value == 0.0f) {
            this.remove(variable, true);
            return;
        }
        if (this.mHead == -1) {
            this.mHead = 0;
            this.mArrayValues[this.mHead] = value;
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            this.mArrayIndices[this.mHead] = solverVariable.getId();
            this.mArrayNextIndices[this.mHead] = -1;
            int n = variable.getUsageInRowCount();
            variable.setUsageInRowCount(n + 1);
            ArrayRow arrayRow = this.mRow;
            Intrinsics.checkNotNull((Object)arrayRow);
            variable.addToRow(arrayRow);
            n = this.mCurrentSize;
            this.mCurrentSize = n + 1;
            if (!this.mDidFillOnce) {
                n = this.mLast;
                this.mLast = n + 1;
                if (this.mLast >= this.mArrayIndices.length) {
                    this.mDidFillOnce = true;
                    this.mLast = this.mArrayIndices.length - 1;
                }
            }
            return;
        }
        int current = this.mHead;
        int previous = -1;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            int n = this.mArrayIndices[current];
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (n == solverVariable.getId()) {
                this.mArrayValues[current] = value;
                return;
            }
            if (this.mArrayIndices[current] < variable.getId()) {
                previous = current;
            }
            current = this.mArrayNextIndices[current];
        }
        int availableIndice = this.mLast + 1;
        if (this.mDidFillOnce) {
            int n = availableIndice = this.mArrayIndices[this.mLast] == -1 ? this.mLast : this.mArrayIndices.length;
        }
        if (availableIndice >= this.mArrayIndices.length && this.mCurrentSize < this.mArrayIndices.length) {
            int n = this.mArrayIndices.length;
            for (int i = 0; i < n; ++i) {
                if (this.mArrayIndices[i] != -1) continue;
                availableIndice = i;
                break;
            }
        }
        if (availableIndice >= this.mArrayIndices.length) {
            availableIndice = this.mArrayIndices.length;
            this.mRowSize *= 2;
            this.mDidFillOnce = false;
            this.mLast = availableIndice - 1;
            float[] fArray = Arrays.copyOf(this.mArrayValues, this.mRowSize);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            this.mArrayValues = fArray;
            int[] nArray = Arrays.copyOf(this.mArrayIndices, this.mRowSize);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.mArrayIndices = nArray;
            int[] nArray2 = Arrays.copyOf(this.mArrayNextIndices, this.mRowSize);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
            this.mArrayNextIndices = nArray2;
        }
        SolverVariable solverVariable = variable;
        Intrinsics.checkNotNull((Object)solverVariable);
        this.mArrayIndices[availableIndice] = solverVariable.getId();
        this.mArrayValues[availableIndice] = value;
        if (previous != -1) {
            this.mArrayNextIndices[availableIndice] = this.mArrayNextIndices[previous];
            this.mArrayNextIndices[previous] = availableIndice;
        } else {
            this.mArrayNextIndices[availableIndice] = this.mHead;
            this.mHead = availableIndice;
        }
        int n = variable.getUsageInRowCount();
        variable.setUsageInRowCount(n + 1);
        ArrayRow arrayRow = this.mRow;
        Intrinsics.checkNotNull((Object)arrayRow);
        variable.addToRow(arrayRow);
        n = this.mCurrentSize;
        this.mCurrentSize = n + 1;
        if (!this.mDidFillOnce) {
            n = this.mLast;
            this.mLast = n + 1;
        }
        if (this.mCurrentSize >= this.mArrayIndices.length) {
            this.mDidFillOnce = true;
        }
        if (this.mLast >= this.mArrayIndices.length) {
            this.mDidFillOnce = true;
            this.mLast = this.mArrayIndices.length - 1;
        }
    }

    @Override
    public void add(@Nullable SolverVariable variable, float value, boolean removeFromDefinition) {
        if (value > -this.sEpsilon && value < this.sEpsilon) {
            return;
        }
        if (this.mHead == -1) {
            this.mHead = 0;
            this.mArrayValues[this.mHead] = value;
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            this.mArrayIndices[this.mHead] = solverVariable.getId();
            this.mArrayNextIndices[this.mHead] = -1;
            int n = variable.getUsageInRowCount();
            variable.setUsageInRowCount(n + 1);
            ArrayRow arrayRow = this.mRow;
            Intrinsics.checkNotNull((Object)arrayRow);
            variable.addToRow(arrayRow);
            n = this.mCurrentSize;
            this.mCurrentSize = n + 1;
            if (!this.mDidFillOnce) {
                n = this.mLast;
                this.mLast = n + 1;
                if (this.mLast >= this.mArrayIndices.length) {
                    this.mDidFillOnce = true;
                    this.mLast = this.mArrayIndices.length - 1;
                }
            }
            return;
        }
        int current = this.mHead;
        int previous = -1;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            int idx = this.mArrayIndices[current];
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (idx == solverVariable.getId()) {
                float v = this.mArrayValues[current] + value;
                if (v > -this.sEpsilon && v < this.sEpsilon) {
                    v = 0.0f;
                }
                this.mArrayValues[current] = v;
                if (v == 0.0f) {
                    if (current == this.mHead) {
                        this.mHead = this.mArrayNextIndices[current];
                    } else {
                        this.mArrayNextIndices[previous] = this.mArrayNextIndices[current];
                    }
                    if (removeFromDefinition) {
                        ArrayRow arrayRow = this.mRow;
                        Intrinsics.checkNotNull((Object)arrayRow);
                        variable.removeFromRow(arrayRow);
                    }
                    if (this.mDidFillOnce) {
                        this.mLast = current;
                    }
                    int n = variable.getUsageInRowCount();
                    variable.setUsageInRowCount(n + -1);
                    n = this.mCurrentSize;
                    this.mCurrentSize = n + -1;
                }
                return;
            }
            if (this.mArrayIndices[current] < variable.getId()) {
                previous = current;
            }
            current = this.mArrayNextIndices[current];
        }
        int availableIndice = this.mLast + 1;
        if (this.mDidFillOnce) {
            int n = availableIndice = this.mArrayIndices[this.mLast] == -1 ? this.mLast : this.mArrayIndices.length;
        }
        if (availableIndice >= this.mArrayIndices.length && this.mCurrentSize < this.mArrayIndices.length) {
            int n = this.mArrayIndices.length;
            for (int i = 0; i < n; ++i) {
                if (this.mArrayIndices[i] != -1) continue;
                availableIndice = i;
                break;
            }
        }
        if (availableIndice >= this.mArrayIndices.length) {
            availableIndice = this.mArrayIndices.length;
            this.mRowSize *= 2;
            this.mDidFillOnce = false;
            this.mLast = availableIndice - 1;
            float[] fArray = Arrays.copyOf(this.mArrayValues, this.mRowSize);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            this.mArrayValues = fArray;
            int[] nArray = Arrays.copyOf(this.mArrayIndices, this.mRowSize);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.mArrayIndices = nArray;
            int[] nArray2 = Arrays.copyOf(this.mArrayNextIndices, this.mRowSize);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
            this.mArrayNextIndices = nArray2;
        }
        SolverVariable solverVariable = variable;
        Intrinsics.checkNotNull((Object)solverVariable);
        this.mArrayIndices[availableIndice] = solverVariable.getId();
        this.mArrayValues[availableIndice] = value;
        if (previous != -1) {
            this.mArrayNextIndices[availableIndice] = this.mArrayNextIndices[previous];
            this.mArrayNextIndices[previous] = availableIndice;
        } else {
            this.mArrayNextIndices[availableIndice] = this.mHead;
            this.mHead = availableIndice;
        }
        int n = variable.getUsageInRowCount();
        variable.setUsageInRowCount(n + 1);
        ArrayRow arrayRow = this.mRow;
        Intrinsics.checkNotNull((Object)arrayRow);
        variable.addToRow(arrayRow);
        n = this.mCurrentSize;
        this.mCurrentSize = n + 1;
        if (!this.mDidFillOnce) {
            n = this.mLast;
            this.mLast = n + 1;
        }
        if (this.mLast >= this.mArrayIndices.length) {
            this.mDidFillOnce = true;
            this.mLast = this.mArrayIndices.length - 1;
        }
    }

    @Override
    public float use(@Nullable ArrayRow definition, boolean removeFromDefinition) {
        ArrayRow.ArrayRowVariables definitionVariables;
        ArrayRow arrayRow = definition;
        Intrinsics.checkNotNull((Object)arrayRow);
        float value = this.get(arrayRow.getMVariable());
        this.remove(definition.getMVariable(), removeFromDefinition);
        ArrayRow.ArrayRowVariables arrayRowVariables = definitionVariables = definition.getVariables();
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        int definitionSize = arrayRowVariables.getCurrentSize();
        for (int i = 0; i < definitionSize; ++i) {
            SolverVariable definitionVariable = definitionVariables.getVariable(i);
            float definitionValue = definitionVariables.get(definitionVariable);
            this.add(definitionVariable, definitionValue * value, removeFromDefinition);
        }
        return value;
    }

    @Override
    public float remove(@Nullable SolverVariable variable, boolean removeFromDefinition) {
        if (Intrinsics.areEqual((Object)this.mCandidate, (Object)variable)) {
            this.mCandidate = null;
        }
        if (this.mHead == -1) {
            return 0.0f;
        }
        int current = this.mHead;
        int previous = -1;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            int idx = this.mArrayIndices[current];
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (idx == solverVariable.getId()) {
                if (current == this.mHead) {
                    this.mHead = this.mArrayNextIndices[current];
                } else {
                    this.mArrayNextIndices[previous] = this.mArrayNextIndices[current];
                }
                if (removeFromDefinition) {
                    ArrayRow arrayRow = this.mRow;
                    Intrinsics.checkNotNull((Object)arrayRow);
                    variable.removeFromRow(arrayRow);
                }
                int n = variable.getUsageInRowCount();
                variable.setUsageInRowCount(n + -1);
                n = this.mCurrentSize;
                this.mCurrentSize = n + -1;
                this.mArrayIndices[current] = -1;
                if (this.mDidFillOnce) {
                    this.mLast = current;
                }
                return this.mArrayValues[current];
            }
            previous = current;
            current = this.mArrayNextIndices[current];
        }
        return 0.0f;
    }

    @Override
    public void clear() {
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            SolverVariable variable;
            Cache cache = this.mCache;
            Intrinsics.checkNotNull((Object)cache);
            SolverVariable solverVariable = variable = cache.getMIndexedVariables()[this.mArrayIndices[current]];
            if (solverVariable != null) {
                ArrayRow arrayRow = this.mRow;
                Intrinsics.checkNotNull((Object)arrayRow);
                solverVariable.removeFromRow(arrayRow);
            }
            current = this.mArrayNextIndices[current];
        }
        this.mHead = -1;
        this.mLast = -1;
        this.mDidFillOnce = false;
        this.mCurrentSize = 0;
    }

    @Override
    public boolean contains(@Nullable SolverVariable variable) {
        if (this.mHead == -1) {
            return false;
        }
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            int n = this.mArrayIndices[current];
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (n == solverVariable.getId()) {
                return true;
            }
            current = this.mArrayNextIndices[current];
        }
        return false;
    }

    @Override
    public int indexOf(@Nullable SolverVariable variable) {
        if (this.mHead == -1) {
            return -1;
        }
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            int n = this.mArrayIndices[current];
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (n == solverVariable.getId()) {
                return current;
            }
            current = this.mArrayNextIndices[current];
        }
        return -1;
    }

    public final boolean hasAtLeastOnePositiveVariable() {
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            if (this.mArrayValues[current] > 0.0f) {
                return true;
            }
            current = this.mArrayNextIndices[current];
        }
        return false;
    }

    @Override
    public void invert() {
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            this.mArrayValues[current] = this.mArrayValues[current] * (float)-1;
            current = this.mArrayNextIndices[current];
        }
    }

    @Override
    public void divideByAmount(float amount) {
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            float[] fArray = this.mArrayValues;
            int n = current;
            fArray[n] = fArray[n] / amount;
            current = this.mArrayNextIndices[current];
        }
    }

    public final int getHead() {
        return this.mHead;
    }

    @Override
    public int getCurrentSize() {
        return this.mCurrentSize;
    }

    public final int getId(int index) {
        return this.mArrayIndices[index];
    }

    public final float getValue(int index) {
        return this.mArrayValues[index];
    }

    public final int getNextIndice(int index) {
        return this.mArrayNextIndices[index];
    }

    @Nullable
    public final SolverVariable getPivotCandidate() {
        if (this.mCandidate == null) {
            int current = this.mHead;
            SolverVariable pivot = null;
            for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
                if (this.mArrayValues[current] < 0.0f) {
                    SolverVariable v;
                    Cache cache = this.mCache;
                    Intrinsics.checkNotNull((Object)cache);
                    Intrinsics.checkNotNull((Object)cache.getMIndexedVariables()[this.mArrayIndices[current]]);
                    if (pivot == null || pivot.getStrength() < v.getStrength()) {
                        pivot = v;
                    }
                }
                current = this.mArrayNextIndices[current];
            }
            return pivot;
        }
        return this.mCandidate;
    }

    @Override
    @Nullable
    public SolverVariable getVariable(int index) {
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            if (counter == index) {
                Cache cache = this.mCache;
                Intrinsics.checkNotNull((Object)cache);
                return cache.getMIndexedVariables()[this.mArrayIndices[current]];
            }
            current = this.mArrayNextIndices[current];
        }
        return null;
    }

    @Override
    public float getVariableValue(int index) {
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            if (counter == index) {
                return this.mArrayValues[current];
            }
            current = this.mArrayNextIndices[current];
        }
        return 0.0f;
    }

    @Override
    public float get(@Nullable SolverVariable variable) {
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            int n = this.mArrayIndices[current];
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (n == solverVariable.getId()) {
                return this.mArrayValues[current];
            }
            current = this.mArrayNextIndices[current];
        }
        return 0.0f;
    }

    @Override
    public int sizeInBytes() {
        int size = 0;
        size += 3 * (this.mArrayIndices.length * 4);
        return size += 36;
    }

    @Override
    public void display() {
        int count = this.mCurrentSize;
        System.out.print((Object)"{ ");
        for (int i = 0; i < count; ++i) {
            SolverVariable v;
            if (this.getVariable(i) == null) continue;
            System.out.print((Object)(v + " = " + this.getVariableValue(i) + " "));
        }
        System.out.println((Object)" }");
    }

    @NotNull
    public String toString() {
        Object result = "";
        int current = this.mHead;
        for (int counter = 0; current != -1 && counter < this.mCurrentSize; ++counter) {
            result = (String)result + " -> ";
            result = (String)result + this.mArrayValues[current] + " : ";
            Cache cache = this.mCache;
            Intrinsics.checkNotNull((Object)cache);
            result = (String)result + cache.getMIndexedVariables()[this.mArrayIndices[current]];
            current = this.mArrayNextIndices[current];
        }
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/ArrayLinkedVariables$Companion;", "", "()V", "DEBUG", "", "NONE", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

