/*
 * Decompiled with CFR 0.152.
 */
package tech.anima.tinytypes.jersey;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import tech.anima.tinytypes.meta.MetaTinyType;
import tech.anima.tinytypes.meta.MetaTinyTypes;

@Provider
public class TinyTypesParamProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (MetaTinyTypes.isTinyType(rawType)) {
            return new TinyTypesParamConverter<T>(rawType);
        }
        return null;
    }

    public static class TinyTypesParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> type;
        private final MetaTinyType<T> meta;

        public TinyTypesParamConverter(Class<T> type) {
            this.type = type;
            this.meta = MetaTinyTypes.metaFor(type);
        }

        public T fromString(String value) {
            return (T)this.meta.fromString(this.type, value);
        }

        public String toString(T value) {
            return this.meta.stringify(value);
        }
    }
}

