/*
 * Decompiled with CFR 0.152.
 */
package tech.aliorpse.mcutils.modules.server;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonClass;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import tech.aliorpse.mcutils.model.server.JavaServerStatus;
import tech.aliorpse.mcutils.model.server.Players;
import tech.aliorpse.mcutils.model.server.TextComponent;
import tech.aliorpse.mcutils.model.server.TextComponentAdapter;
import tech.aliorpse.mcutils.model.server.Version;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0015J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0005H\u0007J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u0005H\u0002J\u001e\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020#H\u0002J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Ltech/aliorpse/mcutils/modules/server/JavaServer;", "", "<init>", "()V", "HANDSHAKE_PACKET_ID", "", "STATUS_REQUEST_PACKET_ID", "STATUS_RESPONSE_PACKET_ID", "PING_PACKET_ID", "PROTOCOL_VERSION", "NEXT_STATE_STATUS", "moshi", "Lcom/squareup/moshi/Moshi;", "getMoshi$mcutils", "()Lcom/squareup/moshi/Moshi;", "getStatus", "Ltech/aliorpse/mcutils/model/server/JavaServerStatus;", "host", "", "port", "timeout", "(Ljava/lang/String;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStatusAsync", "Ljava/util/concurrent/CompletableFuture;", "resolveToIpOrHost", "depth", "resolveSrvRecord", "Lkotlin/Pair;", "sendHandshake", "", "out", "Ljava/io/DataOutputStream;", "sendStatusRequest", "sendPing", "payload", "", "readStatusResponse", "input", "Ljava/io/DataInputStream;", "readPong", "expectedPayload", "writeVarInt", "Ljava/io/OutputStream;", "value", "readVarInt", "writeString", "str", "RawJavaStatus", "mcutils"})
@SourceDebugExtension(value={"SMAP\nJavaServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaServer.kt\ntech/aliorpse/mcutils/modules/server/JavaServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n1#2:268\n4135#3,11:269\n4135#3,11:280\n4135#3,11:291\n4135#3,11:302\n2423#4,14:313\n*S KotlinDebug\n*F\n+ 1 JavaServer.kt\ntech/aliorpse/mcutils/modules/server/JavaServer\n*L\n130#1:269,11\n140#1:280,11\n150#1:291,11\n170#1:302,11\n170#1:313,14\n*E\n"})
public final class JavaServer {
    @NotNull
    public static final JavaServer INSTANCE = new JavaServer();
    private static final int HANDSHAKE_PACKET_ID = 0;
    private static final int STATUS_REQUEST_PACKET_ID = 0;
    private static final int STATUS_RESPONSE_PACKET_ID = 0;
    private static final int PING_PACKET_ID = 1;
    private static final int PROTOCOL_VERSION = -1;
    private static final int NEXT_STATE_STATUS = 1;
    @NotNull
    private static final Moshi moshi;

    private JavaServer() {
    }

    @NotNull
    public final Moshi getMoshi$mcutils() {
        return moshi;
    }

    @Nullable
    public final Object getStatus(@NotNull String host, int port, int timeout, @NotNull Continuation<? super JavaServerStatus> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JavaServerStatus>, Object>(host, port, timeout, null){
            int label;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            final /* synthetic */ int $timeout;
            {
                this.$host = $host;
                this.$port = $port;
                this.$timeout = $timeout;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        JavaServerStatus javaServerStatus;
                        ResultKt.throwOnFailure((Object)$result);
                        String asciiHost = IDN.toASCII(this.$host);
                        Intrinsics.checkNotNull((Object)asciiHost);
                        Pair pair = JavaServer.access$resolveSrvRecord(JavaServer.INSTANCE, asciiHost);
                        if (pair == null) {
                            pair = TuplesKt.to((Object)asciiHost, (Object)Boxing.boxInt((int)this.$port));
                        }
                        Pair pair2 = pair;
                        String srvTarget = (String)pair2.component1();
                        int srvPort = ((Number)pair2.component2()).intValue();
                        String string = JavaServer.resolveToIpOrHost$default(JavaServer.INSTANCE, srvTarget, 0, 2, null);
                        if (string == null) {
                            string = srvTarget;
                        }
                        String resolvedHost = string;
                        Closeable closeable = new Socket();
                        int n = this.$timeout;
                        Throwable throwable = null;
                        try {
                            Socket socket = (Socket)closeable;
                            boolean bl = false;
                            socket.setSoTimeout(n);
                            socket.connect(new InetSocketAddress(resolvedHost, srvPort), n);
                            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                            DataInputStream input = new DataInputStream(socket.getInputStream());
                            JavaServer.access$sendHandshake(JavaServer.INSTANCE, out, asciiHost, srvPort);
                            JavaServer.access$sendStatusRequest(JavaServer.INSTANCE, out);
                            String jsonStr = JavaServer.access$readStatusResponse(JavaServer.INSTANCE, input);
                            Object object = JavaServer.INSTANCE.getMoshi$mcutils().adapter(RawJavaStatus.class).fromJson(jsonStr);
                            Intrinsics.checkNotNull((Object)object);
                            RawJavaStatus parsed = (RawJavaStatus)object;
                            Long ping = null;
                            try {
                                long pingStart = System.currentTimeMillis();
                                JavaServer.access$sendPing(JavaServer.INSTANCE, out, pingStart);
                                JavaServer.access$readPong(JavaServer.INSTANCE, input, pingStart);
                                ping = Boxing.boxLong((long)(System.currentTimeMillis() - pingStart));
                            }
                            catch (Exception exception) {
                                ping = null;
                            }
                            Boolean bl2 = parsed.getEnforcesSecureChat();
                            javaServerStatus = new JavaServerStatus(parsed.getDescription(), parsed.getPlayers(), parsed.getVersion(), ping, bl2 != null ? bl2 : false, parsed.getFavicon());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return javaServerStatus;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JavaServerStatus> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object getStatus$default(JavaServer javaServer, String string, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 25565;
        }
        if ((n3 & 4) != 0) {
            n2 = 2000;
        }
        return javaServer.getStatus(string, n, n2, (Continuation<? super JavaServerStatus>)continuation);
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<JavaServerStatus> getStatusAsync(@NotNull String host, int port, int timeout) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return FutureKt.future$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JavaServerStatus>, Object>(host, port, timeout, null){
            int label;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            final /* synthetic */ int $timeout;
            {
                this.$host = $host;
                this.$port = $port;
                this.$timeout = $timeout;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = JavaServer.INSTANCE.getStatus(this.$host, this.$port, this.$timeout, (Continuation<? super JavaServerStatus>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JavaServerStatus> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ CompletableFuture getStatusAsync$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 25565;
        }
        if ((n3 & 4) != 0) {
            n2 = 2000;
        }
        return JavaServer.getStatusAsync(string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveToIpOrHost(String host, int depth) {
        if (depth <= 0) {
            return null;
        }
        try {
            String cnameTarget;
            List list;
            List list2;
            List list3;
            Object object;
            Lookup lookupA = new Lookup(host, 1);
            lookupA.run();
            Integer n = lookupA.getResult();
            int it = ((Number)n).intValue();
            boolean bl = false;
            Object object2 = object = lookupA.getResult() == 0 ? n : null;
            if (object != null) {
                void $this$filterIsInstanceTo$iv$iv;
                it = ((Number)object).intValue();
                boolean bl2 = false;
                Record[] recordArray = lookupA.getAnswers();
                Intrinsics.checkNotNullExpressionValue((Object)recordArray, (String)"getAnswers(...)");
                Object[] $this$filterIsInstance$iv = recordArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ARecord)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = null;
            }
            List aRecords = list3;
            object = aRecords;
            if (!(object == null || object.isEmpty())) {
                return ((ARecord)aRecords.get(0)).getAddress().getHostAddress();
            }
            Lookup lookupAAAA = new Lookup(host, 28);
            lookupAAAA.run();
            Integer bl2 = lookupAAAA.getResult();
            int it2 = ((Number)bl2).intValue();
            boolean bl3 = false;
            Object object3 = it22 = lookupAAAA.getResult() == 0 ? bl2 : null;
            if (it22 != null) {
                void $this$filterIsInstanceTo$iv$iv;
                it2 = ((Number)it22).intValue();
                boolean bl4 = false;
                Record[] recordArray = lookupAAAA.getAnswers();
                Intrinsics.checkNotNullExpressionValue((Object)recordArray, (String)"getAnswers(...)");
                Object[] $this$filterIsInstance$iv = recordArray;
                boolean $i$f$filterIsInstance = false;
                Object[] $i$f$filterIsInstanceTo = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof AAAARecord)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            List aaaaRecords = list2;
            Object it22 = aaaaRecords;
            if (!(it22 == null || it22.isEmpty())) {
                return ((AAAARecord)aaaaRecords.get(0)).getAddress().getHostAddress();
            }
            Lookup lookupCNAME = new Lookup(host, 5);
            lookupCNAME.run();
            Integer n2 = lookupCNAME.getResult();
            int it3 = ((Number)n2).intValue();
            boolean bl5 = false;
            Object object4 = it32 = lookupCNAME.getResult() == 0 ? n2 : null;
            if (it32 != null) {
                void $this$filterIsInstanceTo$iv$iv;
                it3 = ((Number)it32).intValue();
                boolean bl6 = false;
                Record[] recordArray = lookupCNAME.getAnswers();
                Intrinsics.checkNotNullExpressionValue((Object)recordArray, (String)"getAnswers(...)");
                Object[] $this$filterIsInstance$iv = recordArray;
                boolean $i$f$filterIsInstance = false;
                Object[] $i$f$filterIsInstanceTo2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof CNAMERecord)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List cnameRecords = list;
            Object it32 = cnameRecords;
            if (!(it32 == null || it32.isEmpty()) && !Intrinsics.areEqual((Object)(cnameTarget = ((CNAMERecord)cnameRecords.get(0)).getTarget().toString(true)), (Object)host)) {
                Intrinsics.checkNotNull((Object)cnameTarget);
                return this.resolveToIpOrHost(cnameTarget, depth - 1);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    static /* synthetic */ String resolveToIpOrHost$default(JavaServer javaServer, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 5;
        }
        return javaServer.resolveToIpOrHost(string, n);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<String, Integer> resolveSrvRecord(String host) {
        try {
            SRVRecord srv;
            Object v4;
            void $this$filterIsInstanceTo$iv$iv;
            Lookup lookup = new Lookup("_minecraft._tcp." + host, 33);
            lookup.run();
            if (lookup.getResult() != 0) return null;
            Record[] recordArray = lookup.getAnswers();
            Intrinsics.checkNotNullExpressionValue((Object)recordArray, (String)"getAnswers(...)");
            if (((Object[])recordArray).length == 0) {
                return null;
            }
            boolean bl = false;
            if (bl) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            Record[] recordArray2 = lookup.getAnswers();
            Intrinsics.checkNotNullExpressionValue((Object)recordArray2, (String)"getAnswers(...)");
            Object[] objectArray = recordArray2;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray2 = objectArray;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SRVRecord)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = iterable.iterator();
            if (!iterator$iv.hasNext()) {
                v4 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = minElem$iv;
                } else {
                    SRVRecord it = (SRVRecord)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it.getPriority();
                    do {
                        Object e$iv = iterator$iv.next();
                        SRVRecord it2 = (SRVRecord)e$iv;
                        $i$a$-minByOrNull-JavaServer$resolveSrvRecord$srv$1 = false;
                        int v$iv = it2.getPriority();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = minElem$iv;
                }
            }
            SRVRecord sRVRecord = srv = (SRVRecord)v4;
            if (sRVRecord == null) return null;
            SRVRecord it = sRVRecord;
            boolean bl4 = false;
            String string = it.getTarget().toString(true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String target = StringsKt.removeSuffix((String)string, (CharSequence)".");
            int port = it.getPort();
            Pair pair = TuplesKt.to((Object)target, (Object)port);
            return pair;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final void sendHandshake(DataOutputStream out, String host, int port) {
        ByteArrayOutputStream handshakePayload = new ByteArrayOutputStream();
        DataOutputStream handshakeData = new DataOutputStream(handshakePayload);
        this.writeVarInt(handshakeData, -1);
        this.writeString(handshakeData, host);
        handshakeData.writeShort(port);
        this.writeVarInt(handshakeData, 1);
        byte[] body = handshakePayload.toByteArray();
        this.writeVarInt(out, body.length + 1);
        this.writeVarInt(out, 0);
        out.write(body);
    }

    private final void sendStatusRequest(DataOutputStream out) {
        this.writeVarInt(out, 1);
        this.writeVarInt(out, 0);
    }

    private final void sendPing(DataOutputStream out, long payload) {
        this.writeVarInt(out, 9);
        this.writeVarInt(out, 1);
        out.writeLong(payload);
    }

    private final String readStatusResponse(DataInputStream input) {
        this.readVarInt(input);
        int packetId = this.readVarInt(input);
        if (packetId != 0) {
            throw new IOException("Unexpected status response packet ID: " + packetId);
        }
        int jsonLength = this.readVarInt(input);
        byte[] jsonData = new byte[jsonLength];
        input.readFully(jsonData);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(jsonData, charset2);
    }

    private final void readPong(DataInputStream input, long expectedPayload) {
        this.readVarInt(input);
        int packetId = this.readVarInt(input);
        if (packetId != 1) {
            throw new IOException("Unexpected pong packet ID: " + packetId);
        }
        long payload = input.readLong();
        if (payload != expectedPayload) {
            throw new IOException("Pong payload mismatch: expected " + expectedPayload + ", got " + payload);
        }
    }

    private final void writeVarInt(OutputStream out, int value) {
        int v = value;
        do {
            int temp = v & 0x7F;
            if ((v >>>= 7) != 0) {
                temp |= 0x80;
            }
            out.write(temp);
        } while (v != 0);
    }

    private final void writeVarInt(DataOutputStream out, int value) {
        Intrinsics.checkNotNull((Object)out, (String)"null cannot be cast to non-null type java.io.OutputStream");
        this.writeVarInt((OutputStream)out, value);
    }

    private final int readVarInt(DataInputStream input) {
        byte by;
        int result = 0;
        int bytesRead = 0;
        do {
            by = input.readByte();
            result |= (by & 0x7F) << 7 * bytesRead;
            if (++bytesRead <= 5) continue;
            throw new IOException("VarInt too big");
        } while ((by & 0x80) != 0);
        return result;
    }

    private final void writeString(DataOutputStream out, String str) {
        String string = str;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        this.writeVarInt(out, bytes.length);
        out.write(bytes);
    }

    public static final /* synthetic */ Pair access$resolveSrvRecord(JavaServer $this, String host) {
        return $this.resolveSrvRecord(host);
    }

    public static final /* synthetic */ void access$sendHandshake(JavaServer $this, DataOutputStream out, String host, int port) {
        $this.sendHandshake(out, host, port);
    }

    public static final /* synthetic */ void access$sendStatusRequest(JavaServer $this, DataOutputStream out) {
        $this.sendStatusRequest(out);
    }

    public static final /* synthetic */ String access$readStatusResponse(JavaServer $this, DataInputStream input) {
        return $this.readStatusResponse(input);
    }

    public static final /* synthetic */ void access$sendPing(JavaServer $this, DataOutputStream out, long payload) {
        $this.sendPing(out, payload);
    }

    public static final /* synthetic */ void access$readPong(JavaServer $this, DataInputStream input, long expectedPayload) {
        $this.readPong(input, expectedPayload);
    }

    static {
        Moshi moshi = new Moshi.Builder().add((Object)new TextComponentAdapter()).add((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"build(...)");
        JavaServer.moshi = moshi;
    }

    @JsonClass(generateAdapter=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017JD\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Ltech/aliorpse/mcutils/modules/server/JavaServer$RawJavaStatus;", "", "description", "Ltech/aliorpse/mcutils/model/server/TextComponent;", "players", "Ltech/aliorpse/mcutils/model/server/Players;", "version", "Ltech/aliorpse/mcutils/model/server/Version;", "favicon", "", "enforcesSecureChat", "", "<init>", "(Ltech/aliorpse/mcutils/model/server/TextComponent;Ltech/aliorpse/mcutils/model/server/Players;Ltech/aliorpse/mcutils/model/server/Version;Ljava/lang/String;Ljava/lang/Boolean;)V", "getDescription", "()Ltech/aliorpse/mcutils/model/server/TextComponent;", "getPlayers", "()Ltech/aliorpse/mcutils/model/server/Players;", "getVersion", "()Ltech/aliorpse/mcutils/model/server/Version;", "getFavicon", "()Ljava/lang/String;", "getEnforcesSecureChat", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ltech/aliorpse/mcutils/model/server/TextComponent;Ltech/aliorpse/mcutils/model/server/Players;Ltech/aliorpse/mcutils/model/server/Version;Ljava/lang/String;Ljava/lang/Boolean;)Ltech/aliorpse/mcutils/modules/server/JavaServer$RawJavaStatus;", "equals", "other", "hashCode", "", "toString", "mcutils"})
    public static final class RawJavaStatus {
        @NotNull
        private final TextComponent description;
        @NotNull
        private final Players players;
        @NotNull
        private final Version version;
        @Nullable
        private final String favicon;
        @Nullable
        private final Boolean enforcesSecureChat;

        public RawJavaStatus(@NotNull TextComponent description, @NotNull Players players, @NotNull Version version, @Nullable String favicon, @Nullable Boolean enforcesSecureChat) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)players, (String)"players");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.description = description;
            this.players = players;
            this.version = version;
            this.favicon = favicon;
            this.enforcesSecureChat = enforcesSecureChat;
        }

        public /* synthetic */ RawJavaStatus(TextComponent textComponent, Players players, Version version, String string, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(textComponent, players, version, string, bl);
        }

        @NotNull
        public final TextComponent getDescription() {
            return this.description;
        }

        @NotNull
        public final Players getPlayers() {
            return this.players;
        }

        @NotNull
        public final Version getVersion() {
            return this.version;
        }

        @Nullable
        public final String getFavicon() {
            return this.favicon;
        }

        @Nullable
        public final Boolean getEnforcesSecureChat() {
            return this.enforcesSecureChat;
        }

        @NotNull
        public final TextComponent component1() {
            return this.description;
        }

        @NotNull
        public final Players component2() {
            return this.players;
        }

        @NotNull
        public final Version component3() {
            return this.version;
        }

        @Nullable
        public final String component4() {
            return this.favicon;
        }

        @Nullable
        public final Boolean component5() {
            return this.enforcesSecureChat;
        }

        @NotNull
        public final RawJavaStatus copy(@NotNull TextComponent description, @NotNull Players players, @NotNull Version version, @Nullable String favicon, @Nullable Boolean enforcesSecureChat) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)players, (String)"players");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new RawJavaStatus(description, players, version, favicon, enforcesSecureChat);
        }

        public static /* synthetic */ RawJavaStatus copy$default(RawJavaStatus rawJavaStatus, TextComponent textComponent, Players players, Version version, String string, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                textComponent = rawJavaStatus.description;
            }
            if ((n & 2) != 0) {
                players = rawJavaStatus.players;
            }
            if ((n & 4) != 0) {
                version = rawJavaStatus.version;
            }
            if ((n & 8) != 0) {
                string = rawJavaStatus.favicon;
            }
            if ((n & 0x10) != 0) {
                bl = rawJavaStatus.enforcesSecureChat;
            }
            return rawJavaStatus.copy(textComponent, players, version, string, bl);
        }

        @NotNull
        public String toString() {
            return "RawJavaStatus(description=" + this.description + ", players=" + this.players + ", version=" + this.version + ", favicon=" + this.favicon + ", enforcesSecureChat=" + this.enforcesSecureChat + ")";
        }

        public int hashCode() {
            int result = this.description.hashCode();
            result = result * 31 + this.players.hashCode();
            result = result * 31 + this.version.hashCode();
            result = result * 31 + (this.favicon == null ? 0 : this.favicon.hashCode());
            result = result * 31 + (this.enforcesSecureChat == null ? 0 : ((Object)this.enforcesSecureChat).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RawJavaStatus)) {
                return false;
            }
            RawJavaStatus rawJavaStatus = (RawJavaStatus)other;
            if (!Intrinsics.areEqual((Object)this.description, (Object)rawJavaStatus.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.players, (Object)rawJavaStatus.players)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)rawJavaStatus.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.favicon, (Object)rawJavaStatus.favicon)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enforcesSecureChat, (Object)rawJavaStatus.enforcesSecureChat);
        }
    }
}

