/*
 * Decompiled with CFR 0.152.
 */
package tech.aliorpse.mcutils.model.server;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.ToJson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.aliorpse.mcutils.model.server.TextComponent;
import tech.aliorpse.mcutils.model.server.TextStyle;
import tech.aliorpse.mcutils.modules.server.JavaServer;
import tech.aliorpse.mcutils.utils.TextComponentKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0018*\u00020\u000eH\u0002J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b*\u00020\u000eH\u0002R?\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00160\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltech/aliorpse/mcutils/model/server/TextComponentAdapter;", "", "<init>", "()V", "defaultAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Ltech/aliorpse/mcutils/model/server/TextComponent;", "kotlin.jvm.PlatformType", "getDefaultAdapter", "()Lcom/squareup/moshi/JsonAdapter;", "defaultAdapter$delegate", "Lkotlin/Lazy;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "readComponentObject", "readStyle", "Ltech/aliorpse/mcutils/model/server/TextStyle;", "name", "", "readColor", "readExtras", "", "styleMap", "", "stylesList", "colors", "mcutils"})
@SourceDebugExtension(value={"SMAP\nTextComponentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextComponentAdapter.kt\ntech/aliorpse/mcutils/model/server/TextComponentAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class TextComponentAdapter {
    @NotNull
    private final Lazy defaultAdapter$delegate = LazyKt.lazy(TextComponentAdapter::defaultAdapter_delegate$lambda$0);
    @NotNull
    private final Map<String, TextStyle> styleMap;
    @NotNull
    private final List<String> stylesList;
    @NotNull
    private final Map<String, String> colors;

    public TextComponentAdapter() {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"bold", (Object)((Object)TextStyle.BOLD)), TuplesKt.to((Object)"italic", (Object)((Object)TextStyle.ITALIC)), TuplesKt.to((Object)"underlined", (Object)((Object)TextStyle.UNDERLINED)), TuplesKt.to((Object)"strikethrough", (Object)((Object)TextStyle.STRIKETHROUGH)), TuplesKt.to((Object)"obfuscated", (Object)((Object)TextStyle.OBFUSCATED))};
        this.styleMap = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"bold", "italic", "underlined", "strikethrough", "obfuscated"};
        this.stylesList = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"black", (Object)"#000000"), TuplesKt.to((Object)"dark_blue", (Object)"#0000AA"), TuplesKt.to((Object)"dark_green", (Object)"#00AA00"), TuplesKt.to((Object)"dark_aqua", (Object)"#00AAAA"), TuplesKt.to((Object)"dark_red", (Object)"#AA0000"), TuplesKt.to((Object)"dark_purple", (Object)"#AA00AA"), TuplesKt.to((Object)"gold", (Object)"#FFAA00"), TuplesKt.to((Object)"gray", (Object)"#AAAAAA"), TuplesKt.to((Object)"dark_gray", (Object)"#555555"), TuplesKt.to((Object)"blue", (Object)"#5555FF"), TuplesKt.to((Object)"green", (Object)"#55FF55"), TuplesKt.to((Object)"aqua", (Object)"#55FFFF"), TuplesKt.to((Object)"red", (Object)"#FF5555"), TuplesKt.to((Object)"light_purple", (Object)"#FF55FF"), TuplesKt.to((Object)"yellow", (Object)"#FFFF55"), TuplesKt.to((Object)"white", (Object)"#FFFFFF")};
        this.colors = MapsKt.mapOf((Pair[])objectArray);
    }

    private final JsonAdapter<TextComponent> getDefaultAdapter() {
        Lazy lazy = this.defaultAdapter$delegate;
        return (JsonAdapter)lazy.getValue();
    }

    @FromJson
    @Nullable
    public final TextComponent fromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        JsonReader.Token token = reader.peek();
        return switch (token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
            case 1 -> {
                String v1 = reader.nextString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"nextString(...)");
                yield TextComponentKt.toTextComponent(v1);
            }
            case 2 -> this.readComponentObject(reader);
            default -> {
                reader.skipValue();
                yield new TextComponent("", "#FFFFFF", null, null, 12, null);
            }
        };
    }

    @ToJson
    public final void toJson(@NotNull JsonWriter writer, @Nullable TextComponent value) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.getDefaultAdapter().toJson(writer, (Object)value);
    }

    private final TextComponent readComponentObject(JsonReader reader) {
        String text = "";
        String color = null;
        color = "";
        EnumSet<TextStyle> enumSet = EnumSet.noneOf(TextStyle.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        EnumSet<TextStyle> styles = enumSet;
        List<TextComponent> extra = null;
        extra = CollectionsKt.emptyList();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (Intrinsics.areEqual((Object)name, (Object)"text")) {
                String string;
                String rawText = reader.nextString();
                Intrinsics.checkNotNull((Object)rawText);
                TextComponent parsed = TextComponentKt.toTextComponent(rawText);
                String it = string = rawText;
                boolean bl = false;
                String string2 = !StringsKt.contains$default((CharSequence)rawText, (CharSequence)"\u00a7", (boolean)false, (int)2, null) ? string : null;
                if (string2 == null) {
                    it = string = parsed.getText();
                    boolean bl2 = false;
                    color = parsed.getColor();
                    CollectionsKt.addAll((Collection)styles, (Iterable)parsed.getStyles());
                    if (!((Collection)parsed.getExtra()).isEmpty()) {
                        extra = parsed.getExtra();
                    }
                    string2 = string;
                }
                text = string2;
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"color")) {
                color = this.readColor(reader);
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"extra")) {
                extra = this.readExtras(reader);
                continue;
            }
            if (this.stylesList.contains(name)) {
                Intrinsics.checkNotNull((Object)name);
                if (this.readStyle(reader, name) != null) {
                    TextStyle it;
                    boolean bl = false;
                    ((Collection)styles).add(it);
                }
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return new TextComponent(text, color, styles, extra);
    }

    private final TextStyle readStyle(JsonReader $this$readStyle, String name) {
        return $this$readStyle.nextBoolean() ? this.styleMap.get(name) : null;
    }

    private final String readColor(JsonReader $this$readColor) {
        String colorString = $this$readColor.nextString();
        String string = this.colors.get(colorString);
        if (string == null) {
            Intrinsics.checkNotNull((Object)colorString);
            string = colorString;
        }
        return string;
    }

    private final List<TextComponent> readExtras(JsonReader $this$readExtras) {
        List list = new ArrayList();
        $this$readExtras.beginArray();
        while ($this$readExtras.hasNext()) {
            TextComponent it;
            if (this.fromJson($this$readExtras) == null) continue;
            boolean bl = false;
            list.add(it);
        }
        $this$readExtras.endArray();
        return list;
    }

    private static final JsonAdapter defaultAdapter_delegate$lambda$0() {
        return JavaServer.INSTANCE.getMoshi$mcutils().adapter(TextComponent.class);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            try {
                nArray[JsonReader.Token.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.BEGIN_OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

