/*
 * Decompiled with CFR 0.152.
 */
package tech.aliorpse.mcutils.modules.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.IDN;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.aliorpse.mcutils.model.server.BedrockServerStatus;
import tech.aliorpse.mcutils.model.server.Description;
import tech.aliorpse.mcutils.model.server.GameMode;
import tech.aliorpse.mcutils.model.server.Players;
import tech.aliorpse.mcutils.model.server.Sample;
import tech.aliorpse.mcutils.model.server.Version;
import tech.aliorpse.mcutils.utils.MOTDParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltech/aliorpse/mcutils/modules/server/BedrockServer;", "", "<init>", "()V", "MAGIC_BYTES", "", "CLIENT_ID", "CLIENT_GUID", "PACKET_ID_UNCONNECTED_PONG", "", "PACKET_ID_UNCONNECTED_PING", "BUFFER_SIZE", "", "MIN_EXPECTED_PARTS", "SERVER_INFO_OFFSET", "getStatus", "Ltech/aliorpse/mcutils/model/server/BedrockServerStatus;", "host", "", "port", "timeout", "(Ljava/lang/String;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStatusBlocking", "mcutils"})
public final class BedrockServer {
    @NotNull
    public static final BedrockServer INSTANCE = new BedrockServer();
    @NotNull
    private static final byte[] MAGIC_BYTES;
    @NotNull
    private static final byte[] CLIENT_ID;
    @NotNull
    private static final byte[] CLIENT_GUID;
    private static final byte PACKET_ID_UNCONNECTED_PONG = 28;
    private static final byte PACKET_ID_UNCONNECTED_PING = 1;
    private static final int BUFFER_SIZE = 256;
    private static final int MIN_EXPECTED_PARTS = 9;
    private static final int SERVER_INFO_OFFSET = 33;

    private BedrockServer() {
    }

    @Nullable
    public final Object getStatus(@NotNull String host, int port, int timeout, @NotNull Continuation<? super BedrockServerStatus> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BedrockServerStatus>, Object>(host, timeout, port, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $host;
            final /* synthetic */ int $timeout;
            final /* synthetic */ int $port;
            {
                this.$host = $host;
                this.$timeout = $timeout;
                this.$port = $port;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String asciiHost = IDN.toASCII(this.$host);
                        InetAddress address = InetAddress.getByName(asciiHost);
                        Closeable closeable = new DatagramSocket();
                        int n = this.$timeout;
                        int n2 = this.$port;
                        Throwable throwable = null;
                        try {
                            Object object;
                            void $this$withContext;
                            byte[] infoRaw;
                            DatagramSocket socket = (DatagramSocket)closeable;
                            boolean bl = false;
                            socket.setSoTimeout(n);
                            ByteBuffer requestBuffer = ByteBuffer.allocate(9 + BedrockServer.access$getMAGIC_BYTES$p().length + BedrockServer.access$getCLIENT_ID$p().length + BedrockServer.access$getCLIENT_GUID$p().length).order(ByteOrder.BIG_ENDIAN);
                            requestBuffer.put((byte)1);
                            requestBuffer.putLong(System.currentTimeMillis());
                            requestBuffer.put(BedrockServer.access$getMAGIC_BYTES$p());
                            requestBuffer.put(BedrockServer.access$getCLIENT_ID$p());
                            requestBuffer.put(BedrockServer.access$getCLIENT_GUID$p());
                            DatagramPacket sendPacket = new DatagramPacket(requestBuffer.array(), requestBuffer.position(), address, n2);
                            byte[] receiveBuffer = new byte[256];
                            DatagramPacket receivePacket = new DatagramPacket(receiveBuffer, 256);
                            long start = System.currentTimeMillis();
                            socket.send(sendPacket);
                            socket.receive(receivePacket);
                            long end = System.currentTimeMillis();
                            byte[] data = receivePacket.getData();
                            Intrinsics.checkNotNull((Object)data);
                            if (data.length == 0 || data[0] != 28) {
                                throw new IOException("Invalid response: expected packet ID 0x1C, got " + data[0]);
                            }
                            if (receivePacket.getLength() <= 33) {
                                throw new IOException("Received packet too short to contain server info");
                            }
                            Object[] objectArray = infoRaw = ArraysKt.copyOfRange((byte[])data, (int)33, (int)receivePacket.getLength());
                            Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8, (String)"UTF_8");
                            String[] stringArray = StandardCharsets.UTF_8;
                            String string = new String((byte[])objectArray, (Charset)stringArray);
                            objectArray = new char[1];
                            objectArray[0] = 0;
                            String infoStr = StringsKt.trimEnd((String)string, (char[])objectArray);
                            stringArray = new String[]{";"};
                            List parts = StringsKt.split$default((CharSequence)infoStr, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                            if (parts.size() < 9) {
                                throw new IOException("Malformed response: expected at least 9 parts, got " + parts.size());
                            }
                            Long l = StringsKt.toLongOrNull((String)((String)parts.get(2)));
                            long protocol = l != null ? l : 0L;
                            Integer n3 = StringsKt.toIntOrNull((String)((String)parts.get(4)));
                            int online = n3 != null ? n3 : 0;
                            Integer n4 = StringsKt.toIntOrNull((String)((String)parts.get(5)));
                            int max = n4 != null ? n4 : 0;
                            Object object2 = $this$withContext;
                            try {
                                void $this$invokeSuspend_u24lambda_u241_u24lambda_u240 = object2;
                                boolean bl2 = false;
                                String string2 = ((String)parts.get(8)).toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                                object = Result.constructor-impl((Object)((Object)GameMode.valueOf(string2)));
                            }
                            catch (Throwable throwable2) {
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                            }
                            object2 = object;
                            object = GameMode.UNKNOWN;
                            GameMode gameMode = (GameMode)((Object)(Result.isFailure-impl((Object)object2) ? object : object2));
                            object2 = CollectionsKt.emptyList();
                            BedrockServerStatus bedrockServerStatus = new BedrockServerStatus(new Description((String)parts.get(1), MOTDParser.INSTANCE.sectionToObj((String)parts.get(1))), new Players(max, online, (List<Sample>)object2), new Version((String)parts.get(3), protocol), end - start, (String)parts.get(7), gameMode, (String)parts.get(6));
                            return bedrockServerStatus;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BedrockServerStatus> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object getStatus$default(BedrockServer bedrockServer, String string, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 19132;
        }
        if ((n3 & 4) != 0) {
            n2 = 2000;
        }
        return bedrockServer.getStatus(string, n, n2, (Continuation<? super BedrockServerStatus>)continuation);
    }

    @JvmStatic
    @NotNull
    public static final BedrockServerStatus getStatusBlocking(@NotNull String host, int port, int timeout) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return (BedrockServerStatus)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BedrockServerStatus>, Object>(host, port, timeout, null){
            int label;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            final /* synthetic */ int $timeout;
            {
                this.$host = $host;
                this.$port = $port;
                this.$timeout = $timeout;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BedrockServer.INSTANCE.getStatus(this.$host, this.$port, this.$timeout, (Continuation<? super BedrockServerStatus>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BedrockServerStatus> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ BedrockServerStatus getStatusBlocking$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 19132;
        }
        if ((n3 & 4) != 0) {
            n2 = 2000;
        }
        return BedrockServer.getStatusBlocking(string, n, n2);
    }

    public static final /* synthetic */ byte[] access$getMAGIC_BYTES$p() {
        return MAGIC_BYTES;
    }

    public static final /* synthetic */ byte[] access$getCLIENT_ID$p() {
        return CLIENT_ID;
    }

    public static final /* synthetic */ byte[] access$getCLIENT_GUID$p() {
        return CLIENT_GUID;
    }

    static {
        byte[] byArray = new byte[]{0, -1, -1, 0, -2, -2, -2, -2, -3, -3, -3, -3};
        MAGIC_BYTES = byArray;
        byArray = new byte[]{18, 52, 86, 120, 0};
        CLIENT_ID = byArray;
        int n = 0;
        byte[] byArray2 = new byte[8];
        while (n < 8) {
            int n2 = n++;
            byArray2[n2] = 0;
        }
        CLIENT_GUID = byArray2;
    }
}

