/*
 * Decompiled with CFR 0.152.
 */
package tech.aegean.util.navigation;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.aegean.model.navigation.Navigation;

public class NavigationUtil {
    public static List<Navigation> buildNavigationTree(List<Navigation> navigations, Long rootId) {
        ArrayList rootNavigations = CollUtil.newArrayList((Object[])new Navigation[0]);
        Map<Long, List<Navigation>> navigationPidMap = NavigationUtil.getNavigationPidMap(navigations);
        for (Navigation navigation : navigations) {
            if (!Validator.isNotNull((Object)navigation.getParentId())) continue;
            navigation.setChildren(navigationPidMap.get(navigation.getParentId()));
        }
        for (Navigation navigation : navigations) {
            if (!Validator.isNotNull((Object)navigation.getParentId()) || !navigation.getParentId().equals(0L)) continue;
            rootNavigations.add(navigation);
        }
        return rootNavigations;
    }

    private static Map<Long, List<Navigation>> getNavigationPidMap(List<Navigation> navigations) {
        HashMap navigationPidMap = CollUtil.newHashMap();
        for (Navigation navigation : navigations) {
            List preNavigations = (List)navigationPidMap.get(navigation.getParentId());
            if (Validator.isNull((Object)preNavigations)) {
                ArrayList newNavigations = CollUtil.newArrayList((Object[])new Navigation[]{navigation});
                navigationPidMap.put(navigation.getParentId(), newNavigations);
                continue;
            }
            preNavigations.add(navigation);
        }
        return navigationPidMap;
    }
}

