/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.selenium.containers.recorder;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;
import software.xdev.testcontainers.selenium.containers.browser.BrowserWebDriverContainer;
import software.xdev.testcontainers.selenium.containers.recorder.RecordingContainer;

public class SeleniumRecordingContainer
extends RecordingContainer<SeleniumRecordingContainer> {
    public static final DockerImageName DEFAULT_IMAGE = DockerImageName.parse((String)"selenium/video");
    public static final String ENV_DISPLAY_CONTAINER_NAME = "DISPLAY_CONTAINER_NAME";
    public static final String ENV_SE_VIDEO_FILE_NAME = "SE_VIDEO_FILE_NAME";
    public static final String ENV_SE_SCREEN_WIDTH = "SE_SCREEN_WIDTH";
    public static final String ENV_SE_SCREEN_HEIGHT = "SE_SCREEN_HEIGHT";
    public static final String ENV_SE_FRAME_RATE = "SE_FRAME_RATE";
    public static final String ENV_SE_CODEC = "SE_CODEC";
    public static final String ENV_SE_PRESET = "SE_PRESET";
    protected BrowserWebDriverContainer<?> target;
    protected String displayContainerName;
    protected String videoFileName;
    protected boolean resolutionConfigured;
    protected String fileExtension = "mp4";

    public SeleniumRecordingContainer(BrowserWebDriverContainer<?> target) {
        this(target, DEFAULT_IMAGE);
    }

    public SeleniumRecordingContainer(BrowserWebDriverContainer<?> target, DockerImageName dockerImageName) {
        super(dockerImageName);
        this.target = target;
        this.setWaitStrategy(new LogMessageWaitStrategy().withRegEx(".*(success: video-ready entered RUNNING state).*\n").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS)));
    }

    public SeleniumRecordingContainer withDisplayContainerName(String name) {
        this.displayContainerName = name;
        this.addEnv(ENV_DISPLAY_CONTAINER_NAME, name);
        return this;
    }

    public SeleniumRecordingContainer withVideoFileName(String name) {
        if ("auto".equals(name)) {
            throw new IllegalArgumentException("'auto' is currently not supported");
        }
        this.videoFileName = name;
        this.addEnv(ENV_SE_VIDEO_FILE_NAME, name);
        return this;
    }

    public SeleniumRecordingContainer withDisplayResolution(String width, String height) {
        this.addEnv(ENV_SE_SCREEN_WIDTH, width);
        this.addEnv(ENV_SE_SCREEN_HEIGHT, height);
        this.resolutionConfigured = true;
        return this;
    }

    public SeleniumRecordingContainer withFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    public SeleniumRecordingContainer withFrameRate(int frameRate) {
        return this.withFrameRate(String.valueOf(frameRate));
    }

    public SeleniumRecordingContainer withFrameRate(String frameRate) {
        this.addEnv(ENV_SE_FRAME_RATE, frameRate);
        return this;
    }

    public SeleniumRecordingContainer withCodec(String codec) {
        this.addEnv(ENV_SE_CODEC, codec);
        return this;
    }

    public SeleniumRecordingContainer withPreset(String preset) {
        this.addEnv(ENV_SE_PRESET, preset);
        return this;
    }

    protected void configure() {
        this.withNetwork(this.target.getNetwork());
        if (this.displayContainerName == null) {
            this.withDisplayContainerName(this.target.getNetworkAliases().stream().findFirst().orElseGet(() -> this.target.getContainerName().replace("/", "")));
        }
        if (this.videoFileName == null) {
            this.withVideoFileName("record-" + this.target.getContainerId() + "." + this.fileExtension);
        }
        if (!this.resolutionConfigured) {
            this.withDisplayResolution(this.target.getEnvMap().getOrDefault(ENV_SE_SCREEN_WIDTH, "1360"), this.target.getEnvMap().getOrDefault(ENV_SE_SCREEN_HEIGHT, "1020"));
        }
        super.configure();
    }

    @Override
    public Path saveRecordingToFile(Path directory, String fileNameWithoutExtension) {
        if (this.getContainerId() == null) {
            return null;
        }
        this.stopNoRemove();
        Path outFilePath = this.resolveOutputFile(directory, fileNameWithoutExtension);
        this.copyRecording(outFilePath);
        return outFilePath;
    }

    protected void stopNoRemove() {
        this.dockerClient.stopContainerCmd(this.getContainerId()).exec();
    }

    protected Path resolveOutputFile(Path directory, String fileNameWithoutExtension) {
        return directory.resolve(fileNameWithoutExtension + "." + Optional.ofNullable(this.videoFileName).filter(f -> f.contains(".")).map(f -> f.substring(f.lastIndexOf(46) + 1)).orElse(""));
    }

    protected void copyRecording(Path outFilePath) {
        this.copyFileFromContainer("/videos/" + this.videoFileName, is -> Files.copy(is, outFilePath, StandardCopyOption.REPLACE_EXISTING));
    }
}

