/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.selenium.containers.browser;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.testcontainers.utility.DockerImageName;
import software.xdev.testcontainers.selenium.containers.browser.BrowserWebDriverContainer;
import software.xdev.testcontainers.selenium.containers.browser.SeleniumUtils;

public class CapabilitiesBrowserWebDriverContainer<SELF extends CapabilitiesBrowserWebDriverContainer<SELF>>
extends BrowserWebDriverContainer<SELF> {
    protected static final Map<String, DockerImageName> BROWSER_DOCKER_IMAGES = new HashMap<String, DockerImageName>(Map.of("chrome", CHROME_IMAGE, "firefox", FIREFOX_IMAGE, "MicrosoftEdge", EDGE_IMAGE));

    public CapabilitiesBrowserWebDriverContainer(Capabilities capabilities) {
        this(capabilities, BROWSER_DOCKER_IMAGES);
    }

    public CapabilitiesBrowserWebDriverContainer(Capabilities capabilities, Map<String, DockerImageName> browserDockerImages) {
        this(CapabilitiesBrowserWebDriverContainer.getStandardImageForCapabilities(capabilities, SeleniumUtils.getClasspathSeleniumVersion(), browserDockerImages));
    }

    public CapabilitiesBrowserWebDriverContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.waitStrategy = this.getDefaultWaitStrategy();
    }

    protected static DockerImageName getStandardImageForCapabilities(Capabilities capabilities, String seleniumVersion) {
        return CapabilitiesBrowserWebDriverContainer.getStandardImageForCapabilities(capabilities, seleniumVersion, BROWSER_DOCKER_IMAGES);
    }

    protected static DockerImageName getStandardImageForCapabilities(Capabilities capabilities, String seleniumVersion, Map<String, DockerImageName> browserDockerImages) {
        return Optional.ofNullable(browserDockerImages.get(Optional.ofNullable(capabilities).map(Capabilities::getBrowserName).orElse("chrome"))).map(image -> image.withTag(seleniumVersion)).orElseThrow(() -> new UnsupportedOperationException("Unsupported Browser name; Supported: " + String.join((CharSequence)", ", BROWSER_DOCKER_IMAGES.keySet())));
    }

    public static final class BrowserType {
        public static final String CHROME = "chrome";
        public static final String FIREFOX = "firefox";
        public static final String EDGE = "MicrosoftEdge";

        private BrowserType() {
        }
    }
}

