/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import software.xdev.testcontainers.imagebuilder.concurrent.ExecutorServiceCreator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultExecutorServiceCreator
implements ExecutorServiceCreator {
    @Override
    public ExecutorService createUnlimited(String threadNamePrefix) {
        return Executors.newCachedThreadPool(DefaultExecutorServiceCreator.factory(threadNamePrefix));
    }

    private static ThreadFactory factory(String threadNamePrefix) {
        AtomicInteger nextThreadId = new AtomicInteger(0);
        return r -> {
            Thread t = new Thread(r, threadNamePrefix + "-" + nextThreadId.getAndIncrement());
            t.setDaemon(true);
            return t;
        };
    }
}

