/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.model.BuildResponseItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;
import org.testcontainers.images.builder.traits.ClasspathTrait;
import org.testcontainers.images.builder.traits.DockerfileTrait;
import org.testcontainers.images.builder.traits.FilesTrait;
import org.testcontainers.images.builder.traits.StringsTrait;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.LazyFuture;
import org.testcontainers.utility.ResourceReaper;
import software.xdev.testcontainers.imagebuilder.AdvancedParsedDockerfile;
import software.xdev.testcontainers.imagebuilder.concurrent.ImageBuilderExecutorServiceHolder;
import software.xdev.testcontainers.imagebuilder.transfer.DefaultTransferFilesCreator;
import software.xdev.testcontainers.imagebuilder.transfer.DockerFileLineModifier;
import software.xdev.testcontainers.imagebuilder.transfer.FastFilePathUtil;
import software.xdev.testcontainers.imagebuilder.transfer.TransferArchiveTARCompressor;
import software.xdev.testcontainers.imagebuilder.transfer.TransferFilesCreator;
import software.xdev.testcontainers.imagebuilder.transfer.fcm.DockerFileContentModifier;

public class AdvancedImageFromDockerFile
extends LazyFuture<String>
implements BuildContextBuilderTrait<AdvancedImageFromDockerFile>,
ClasspathTrait<AdvancedImageFromDockerFile>,
FilesTrait<AdvancedImageFromDockerFile>,
StringsTrait<AdvancedImageFromDockerFile>,
DockerfileTrait<AdvancedImageFromDockerFile> {
    protected final String dockerImageName;
    protected final Logger defaultLogger;
    protected final boolean deleteOnExit;
    protected final Map<String, Transferable> transferables = new HashMap<String, Transferable>();
    protected final Map<String, String> buildArgs = new HashMap<String, String>();
    protected Logger loggerForBuild;
    protected Optional<Path> dockerFilePath = Optional.empty();
    protected Optional<Path> baseDir = Optional.empty();
    protected Optional<Path> baseDirRelativeIgnoreFile = Optional.of(Paths.get(".gitignore", new String[0]));
    protected Set<String> preGitIgnoreLines = new LinkedHashSet<String>();
    protected Predicate<String> ignoreFileLineFilter = l -> true;
    protected Set<String> postGitIgnoreLines = new LinkedHashSet<String>();
    protected boolean alwaysTransferDockerfilePath = true;
    protected Set<String> alwaysTransferRelativePaths = Set.of();
    protected BiFunction<Path, Path, TransferFilesCreator> transferFilesCreatorSupplier = DefaultTransferFilesCreator::new;
    protected TransferArchiveTARCompressor transferArchiveTARCompressor = new TransferArchiveTARCompressor();
    protected Consumer<TransferArchiveTARCompressor> transferArchiveTARCompressorCustomizer;
    protected TriFunction<Path, List<DockerFileLineModifier>, Collection<String>, DockerFileContentModifier> dockerFileContentModifierSupplier = DockerFileContentModifier::new;
    protected List<DockerFileLineModifier> dockerFileLinesModifiers = new ArrayList<DockerFileLineModifier>();
    protected Optional<String> target = Optional.empty();
    protected final Set<Consumer<BuildImageCmd>> buildImageCmdModifiers = new LinkedHashSet<Consumer<BuildImageCmd>>();
    protected Set<String> externalDependencyImageNames = Collections.emptySet();
    protected boolean useWinNTFSJunctionFixIfApplicable;

    public AdvancedImageFromDockerFile() {
        this("testcontainers/" + Base58.randomString((int)16).toLowerCase());
    }

    public AdvancedImageFromDockerFile(String dockerImageName) {
        this(dockerImageName, true);
    }

    public AdvancedImageFromDockerFile(String dockerImageName, boolean deleteOnExit) {
        this(dockerImageName, deleteOnExit, LoggerFactory.getLogger((String)(AdvancedImageFromDockerFile.class.getName() + "." + dockerImageName)));
    }

    public AdvancedImageFromDockerFile(String dockerImageName, boolean deleteOnExit, Logger logger) {
        this.dockerImageName = dockerImageName;
        this.deleteOnExit = deleteOnExit;
        this.defaultLogger = logger;
    }

    public AdvancedImageFromDockerFile withFileFromTransferable(String path, Transferable transferable) {
        if (this.transferables.put(path, transferable) != null) {
            this.log().warn("overriding previous mapping for '{}'", (Object)path);
        }
        return this;
    }

    public AdvancedImageFromDockerFile withLoggerForBuild(Logger loggerForBuild) {
        this.loggerForBuild = loggerForBuild;
        return this;
    }

    protected String resolve() {
        Logger logger = Optional.ofNullable(this.loggerForBuild).orElseGet(() -> DockerLoggerFactory.getLogger((String)this.dockerImageName));
        DockerClient dockerClient = DockerClientFactory.instance().client();
        this.log().info("Starting resolving image[name='{}']", (Object)this.dockerImageName);
        try {
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            BuildImageCmd buildImageCmd = dockerClient.buildImageCmd((InputStream)in);
            this.configure(buildImageCmd);
            HashMap<String, String> labels = new HashMap<String, String>();
            if (buildImageCmd.getLabels() != null) {
                labels.putAll(buildImageCmd.getLabels());
            }
            this.deleteImageOnExitIfRequired(labels);
            labels.putAll(DockerClientFactory.DEFAULT_LABELS);
            buildImageCmd.withLabels(labels);
            this.prePullDependencyImages(this.externalDependencyImageNames);
            this.log().info("Starting building image[name='{}']", (Object)this.dockerImageName);
            long buildStartTime = System.currentTimeMillis();
            BuildImageResultCallback exec = (BuildImageResultCallback)buildImageCmd.exec((ResultCallback)this.getBuildImageResultCallback(logger));
            long bytesToDockerDaemon = this.getBytesToDockerDaemon(out);
            if (this.log().isInfoEnabled()) {
                this.log().info("Transferred {} manually (not actually) to Docker daemon", (Object)FileUtils.byteCountToDisplaySize((long)bytesToDockerDaemon));
            }
            exec.awaitImageId();
            this.log().info("Building of image[name='{}'] was done in {}ms", (Object)this.dockerImageName, (Object)(System.currentTimeMillis() - buildStartTime));
            return this.dockerImageName;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void deleteImageOnExitIfRequired(Map<String, String> labels) {
        if (!this.deleteOnExit) {
            return;
        }
        this.log().debug("Registering image for cleanup when finished");
        labels.putAll(ResourceReaper.instance().getLabels());
    }

    protected long getBytesToDockerDaemon(PipedOutputStream out) throws IOException {
        long bytesToDockerDaemon = 0L;
        try (TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(out));){
            tarArchive.setLongFileMode(3);
            for (Map.Entry<String, Transferable> entry : this.transferables.entrySet()) {
                Transferable transferable = entry.getValue();
                String destination = entry.getKey();
                transferable.transferTo(tarArchive, destination);
                bytesToDockerDaemon += transferable.getSize();
            }
            tarArchive.finish();
        }
        return bytesToDockerDaemon;
    }

    protected BuildImageResultCallback getBuildImageResultCallback(final Logger logger) {
        return new BuildImageResultCallback(){
            private final List<String> notFlushedString = new ArrayList<String>();

            public void onNext(BuildResponseItem item) {
                super.onNext(item);
                if (item.isErrorIndicated()) {
                    if (logger.isInfoEnabled()) {
                        logger.info(AdvancedImageFromDockerFile.removeEnd(String.join((CharSequence)"", this.notFlushedString), "\n"));
                    }
                    this.notFlushedString.clear();
                    logger.error(item.getErrorDetail() != null ? item.getErrorDetail().getMessage() : "<null>");
                } else if (item.getStream() != null) {
                    String details = item.getStream();
                    this.notFlushedString.add(details);
                    if (details.endsWith("\n") || this.notFlushedString.size() > 1000) {
                        if (logger.isInfoEnabled()) {
                            logger.info(AdvancedImageFromDockerFile.removeEnd(String.join((CharSequence)"", this.notFlushedString), "\n"));
                        }
                        this.notFlushedString.clear();
                    }
                }
            }
        };
    }

    protected static String removeEnd(String str, String remove) {
        if (str == null || str.isEmpty() || remove == null || remove.isEmpty()) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    protected void configure(BuildImageCmd buildImageCmd) {
        this.log().info("Configuring...");
        buildImageCmd.withTags(new HashSet<String>(Collections.singletonList(this.dockerImageName)));
        this.dockerFilePath.ifPresent(p -> {
            buildImageCmd.withDockerfilePath(FastFilePathUtil.relativize(this.baseDir.orElse(p.getParent()), p));
            AdvancedParsedDockerfile parsedDockerFile = new AdvancedParsedDockerfile((Path)p);
            this.log().info("Resolving dependency images...");
            this.externalDependencyImageNames = this.fullyResolveDependencyImages(parsedDockerFile.getExternalImageNames(), parsedDockerFile.getArguments());
            if (!this.externalDependencyImageNames.isEmpty()) {
                buildImageCmd.withPull(Boolean.valueOf(false));
            }
        });
        if (this.baseDir.isPresent()) {
            Path safeBaseDir = this.baseDir.get();
            this.log().info("Calculating files to transfer to docker[baseDir={},baseDirRelativeIgnoreFile={}]", (Object)safeBaseDir, this.baseDirRelativeIgnoreFile.orElse(null));
            HashSet<String> alwaysIncludePaths = new HashSet<String>(this.alwaysTransferRelativePaths);
            if (this.alwaysTransferDockerfilePath) {
                alwaysIncludePaths.add(this.relativeDockerFilePathString(safeBaseDir));
            }
            long startTransferMs = System.currentTimeMillis();
            TransferFilesCreator tfc = this.transferFilesCreatorSupplier.apply(safeBaseDir, this.baseDirRelativeIgnoreFile.orElse(null));
            Map<Path, String> filesToTransfer = tfc.determineFilesToTransfer(this.preGitIgnoreLines, this.ignoreFileLineFilter, this.postGitIgnoreLines, alwaysIncludePaths, this.useWinNTFSJunctionFixIfApplicable);
            this.log().info("{}x files will be transferred (determination took {}ms)", (Object)filesToTransfer.size(), (Object)(System.currentTimeMillis() - startTransferMs));
            if (this.log().isDebugEnabled()) {
                filesToTransfer.forEach((a, r) -> this.log().debug("Will transmit: '{}' -> '{}'", a, r));
            }
            this.log().info("Building InputStream with docker-context...");
            long startInputStreamBuildMs = System.currentTimeMillis();
            if (!this.dockerFileLinesModifiers.isEmpty()) {
                this.log().info("Dockerfile lines modifiers are active: {}", this.dockerFileLinesModifiers);
                DockerFileContentModifier dockerFileContentModifier = (DockerFileContentModifier)this.dockerFileContentModifierSupplier.apply((Object)this.safeDockerFilePath(), this.dockerFileLinesModifiers, filesToTransfer.values());
                if (dockerFileContentModifier != null) {
                    this.transferArchiveTARCompressor.withContentModifier(dockerFileContentModifier);
                }
            }
            if (this.transferArchiveTARCompressorCustomizer != null) {
                this.transferArchiveTARCompressorCustomizer.accept(this.transferArchiveTARCompressor);
            }
            buildImageCmd.withTarInputStream(tfc.getAllFilesToTransferAsTarInputStream(filesToTransfer, this.transferArchiveTARCompressor));
            this.log().info("InputStream handed over to Docker, took {}ms", (Object)(System.currentTimeMillis() - startInputStreamBuildMs));
        }
        this.baseDir.ifPresent(d -> buildImageCmd.withBaseDirectory(d.toFile()));
        this.buildArgs.forEach((arg_0, arg_1) -> ((BuildImageCmd)buildImageCmd).withBuildArg(arg_0, arg_1));
        this.target.ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withTarget(arg_0));
        this.buildImageCmdModifiers.forEach(hook -> hook.accept(buildImageCmd));
    }

    protected Set<String> fullyResolveDependencyImages(Set<String> fileDependencyImages, Map<String, Optional<String>> fileArgs) {
        HashMap<String, String> resolvedArgs = new HashMap<String, String>(this.buildArgs);
        fileArgs.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).filter(e -> !resolvedArgs.containsKey(e.getKey())).forEach(e -> resolvedArgs.put((String)e.getKey(), (String)((Optional)e.getValue()).get()));
        HashSet<String> resolvedDependencyImages = new HashSet<String>();
        fileDependencyImages.stream().map(imgName -> {
            if (!imgName.contains("$")) {
                return imgName;
            }
            String newImgName = imgName;
            for (Map.Entry entry : resolvedArgs.entrySet()) {
                for (String replacePattern : Arrays.asList("${%s}", "$%s")) {
                    newImgName = newImgName.replace(String.format(replacePattern, entry.getKey()), (CharSequence)entry.getValue());
                }
            }
            return newImgName;
        }).forEach(resolvedDependencyImages::add);
        return resolvedDependencyImages;
    }

    protected String relativeDockerFilePathString(Path baseDir) {
        return FastFilePathUtil.relativize(baseDir, this.safeDockerFilePath());
    }

    protected Path safeDockerFilePath() {
        return this.dockerFilePath.orElseGet(() -> Path.of("Dockerfile", new String[0]));
    }

    protected void prePullDependencyImages(Set<String> imagesToPull) {
        imagesToPull.stream().filter(this::canImageNameBePulled).map(imageName -> CompletableFuture.runAsync(() -> {
            try {
                this.log().info("Pre-emptively checking local images for '{}', referenced via a Dockerfile. If not available, it will be pulled.", imageName);
                new RemoteDockerImage(DockerImageName.parse((String)imageName)).withImageNameSubstitutor(ImageNameSubstitutor.noop()).get(10L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                this.log().warn("Unable to pre-fetch an image ({}) depended upon by Dockerfile - image build will continue but may fail. Exception message was: {}", imageName, (Object)e.getMessage());
            }
        }, this.executorServiceForPrePull())).toList().forEach(CompletableFuture::join);
    }

    protected ExecutorService executorServiceForPrePull() {
        return ImageBuilderExecutorServiceHolder.instance();
    }

    protected boolean canImageNameBePulled(String imageName) {
        return !"scratch".equals(imageName);
    }

    protected Logger log() {
        return this.defaultLogger;
    }

    public AdvancedImageFromDockerFile withBuildArg(String key, String value) {
        this.buildArgs.put(key, value);
        return this;
    }

    public AdvancedImageFromDockerFile withBuildArgs(Map<String, String> args) {
        this.buildArgs.putAll(args);
        return this;
    }

    public AdvancedImageFromDockerFile withDockerFilePath(Path dockerFilePath) {
        this.dockerFilePath = Optional.ofNullable(dockerFilePath);
        return this;
    }

    public AdvancedImageFromDockerFile withBaseDir(Path baseDir) {
        this.baseDir = Optional.of(baseDir);
        return this;
    }

    public AdvancedImageFromDockerFile withBaseDirRelativeIgnoreFile(Path baseDirRelativeIgnoreFile) {
        this.baseDirRelativeIgnoreFile = Optional.ofNullable(baseDirRelativeIgnoreFile);
        return this;
    }

    public AdvancedImageFromDockerFile withPreGitIgnoreLines(String ... preGitIgnoreLines) {
        this.preGitIgnoreLines = new LinkedHashSet<String>(List.of(preGitIgnoreLines));
        return this;
    }

    public AdvancedImageFromDockerFile withIgnoreFileLineFilter(Predicate<String> ignoreFileLineFilter) {
        this.ignoreFileLineFilter = ignoreFileLineFilter;
        return this;
    }

    public AdvancedImageFromDockerFile withPostGitIgnoreLines(String ... postGitIgnoreLines) {
        this.postGitIgnoreLines = new LinkedHashSet<String>(List.of(postGitIgnoreLines));
        return this;
    }

    public AdvancedImageFromDockerFile withAlwaysTransferRelativPaths(Set<String> alwaysTransferPaths) {
        this.alwaysTransferRelativePaths = new HashSet<String>((Collection)Objects.requireNonNull(alwaysTransferPaths));
        return this;
    }

    public AdvancedImageFromDockerFile withAlwaysTransferDockerfilePath(boolean alwaysTransferDockerfilePath) {
        this.alwaysTransferDockerfilePath = alwaysTransferDockerfilePath;
        return this;
    }

    public AdvancedImageFromDockerFile withTarget(String target) {
        this.target = Optional.of(target);
        return this;
    }

    public AdvancedImageFromDockerFile withTransferFilesCreatorSupplier(BiFunction<Path, Path, TransferFilesCreator> transferFilesCreatorSupplier) {
        this.transferFilesCreatorSupplier = Objects.requireNonNull(transferFilesCreatorSupplier);
        return this;
    }

    public AdvancedImageFromDockerFile withTransferArchiveTARCompressor(TransferArchiveTARCompressor transferArchiveTARCompressor) {
        this.transferArchiveTARCompressor = Objects.requireNonNull(transferArchiveTARCompressor);
        return this;
    }

    public AdvancedImageFromDockerFile withTransferArchiveTARCompressorCustomizer(Consumer<TransferArchiveTARCompressor> customizer) {
        this.transferArchiveTARCompressorCustomizer = customizer;
        return this;
    }

    public AdvancedImageFromDockerFile withDockerFileContentModifierSupplier(TriFunction<Path, List<DockerFileLineModifier>, Collection<String>, DockerFileContentModifier> dockerFileContentModifierSupplier) {
        this.dockerFileContentModifierSupplier = Objects.requireNonNull(dockerFileContentModifierSupplier);
        return this;
    }

    public AdvancedImageFromDockerFile withDockerFileLinesModifier(DockerFileLineModifier dockerFileLinesModifier) {
        this.dockerFileLinesModifiers.add(dockerFileLinesModifier);
        return this;
    }

    public AdvancedImageFromDockerFile withBuildImageCmdModifier(Consumer<BuildImageCmd> modifier) {
        this.buildImageCmdModifiers.add(modifier);
        return this;
    }

    public AdvancedImageFromDockerFile withUseWinNTFSJunctionFixIfApplicable(boolean useWinNTFSJunctionFixIfApplicable) {
        this.useWinNTFSJunctionFixIfApplicable = useWinNTFSJunctionFixIfApplicable;
        return this;
    }
}

