/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.transfer.fcm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import software.xdev.testcontainers.imagebuilder.transfer.DockerFileLineModifier;
import software.xdev.testcontainers.imagebuilder.transfer.fcm.FileContentModifier;

public class DockerFileContentModifier
implements FileContentModifier {
    protected final Path dockerFilePath;
    protected final List<DockerFileLineModifier> linesModifiers;
    protected final Set<String> allRelativeFilePaths;

    public DockerFileContentModifier(Path dockerFilePath, List<DockerFileLineModifier> linesModifiers, Collection<String> allRelativeFilePaths) {
        this.dockerFilePath = dockerFilePath;
        this.linesModifiers = linesModifiers;
        this.allRelativeFilePaths = new HashSet<String>(allRelativeFilePaths);
    }

    @Override
    public InputStream apply(Path sourcePath, String targetPath, TarArchiveEntry tarArchiveEntry) throws IOException {
        if (!this.dockerFilePath.equals(sourcePath)) {
            return null;
        }
        List<String> lines = Files.readAllLines(sourcePath);
        for (DockerFileLineModifier lineModifier : this.linesModifiers) {
            lines = lineModifier.modify(lines, this.allRelativeFilePaths);
        }
        byte[] data = String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8);
        tarArchiveEntry.setSize((long)data.length);
        return new ByteArrayInputStream(data);
    }
}

