/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.transfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import software.xdev.testcontainers.imagebuilder.transfer.fcm.FileContentModifier;

public class TransferArchiveTARCompressor {
    protected final List<FileContentModifier> fileContentModifiers = new ArrayList<FileContentModifier>();

    public TransferArchiveTARCompressor withContentModifier(FileContentModifier modifier) {
        this.fileContentModifiers.add(modifier);
        return this;
    }

    public File archiveTARFiles(Map<Path, String> filesToTransfer, String archiveNameWithOutExtension) throws IOException {
        File tarFile = new File(FileUtils.getTempDirectoryPath(), archiveNameWithOutExtension + ".tar");
        tarFile.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            tos.setLongFileMode(3);
            tos.setBigNumberMode(2);
            for (Map.Entry<Path, String> fileData : filesToTransfer.entrySet()) {
                this.addFileToTar(tos, fileData.getKey(), fileData.getValue());
            }
        }
        return tarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileToTar(TarArchiveOutputStream tarArchiveOutputStream, Path sourePath, String targetPath) throws IOException {
        try {
            if (Files.isSymbolicLink(sourePath)) {
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(targetPath, 50);
                tarArchiveEntry.setLinkName(Files.readSymbolicLink(sourePath).toString());
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                return;
            }
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)tarArchiveOutputStream.createArchiveEntry(sourePath.toFile(), targetPath);
            if (sourePath.toFile().canExecute()) {
                tarArchiveEntry.setMode(tarArchiveEntry.getMode() | 0x1ED);
            }
            if (!sourePath.toFile().isFile()) {
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                return;
            }
            try (InputStream input = this.createInputStreamForFile(sourePath, targetPath, tarArchiveEntry);){
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                IOUtils.copy((InputStream)input, (OutputStream)tarArchiveOutputStream);
            }
        }
        finally {
            tarArchiveOutputStream.closeArchiveEntry();
        }
    }

    protected InputStream createInputStreamForFile(Path sourePath, String targetPath, TarArchiveEntry tarArchiveEntry) throws IOException {
        for (FileContentModifier fcm : this.fileContentModifiers) {
            InputStream is = fcm.apply(sourePath, targetPath, tarArchiveEntry);
            if (is == null) continue;
            return is;
        }
        return new BufferedInputStream(Files.newInputStream(sourePath, new OpenOption[0]));
    }
}

