/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.transfer.java.nio.file.winntfs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import software.xdev.testcontainers.imagebuilder.transfer.java.nio.file.winntfs.FileTreeIterator;
import software.xdev.testcontainers.imagebuilder.transfer.java.nio.file.winntfs.FileTreeWalker;

public final class WinNTFSJunctionFiles {
    public static boolean shouldBeApplied(Path path) {
        try {
            FileStore store = Files.getFileStore(path);
            return "WindowsFileStore".equals(store.getClass().getSimpleName()) && "NTFS".equalsIgnoreCase(store.type());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Stream<Path> find(Path start, int maxDepth, BiPredicate<Path, BasicFileAttributes> matcher, FileVisitOption ... options) throws IOException {
        FileTreeIterator iterator = new FileTreeIterator(start, maxDepth, options);
        try {
            Spliterator<FileTreeWalker.Event> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1);
            return ((Stream)StreamSupport.stream(spliterator, false).onClose(iterator::close)).filter(entry -> matcher.test(entry.file(), entry.attributes())).map(FileTreeWalker.Event::file);
        }
        catch (Error | RuntimeException e) {
            iterator.close();
            throw e;
        }
    }

    private WinNTFSJunctionFiles() {
    }
}

