/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.transfer.java.nio.file.winntfs;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTreeWalker
implements Closeable {
    private final boolean followLinks;
    private final LinkOption[] linkOptions;
    private final int maxDepth;
    private final ArrayDeque<DirectoryNode> stack = new ArrayDeque();
    private boolean closed;
    private static boolean initializedBasicFileAttributesHolderClazz;
    private static Class<?> basicFileAttributesHolderClazz;
    private static Method mBasicFileAttributesHolderGet;
    private static boolean wasBasicFileAttributesHolderGetAccessSuccess;

    FileTreeWalker(Collection<FileVisitOption> options, int maxDepth) {
        LinkOption[] linkOptionArray;
        boolean fl = false;
        block3: for (FileVisitOption option : options) {
            switch (option) {
                case FOLLOW_LINKS: {
                    fl = true;
                    continue block3;
                }
            }
            throw new AssertionError((Object)"Should not get here");
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException("'maxDepth' is negative");
        }
        this.followLinks = fl;
        if (fl) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        this.linkOptions = linkOptionArray;
        this.maxDepth = maxDepth;
    }

    private static void initBasicFileAttributesHolderClazz() {
        if (!initializedBasicFileAttributesHolderClazz) {
            try {
                basicFileAttributesHolderClazz = Class.forName("sun.nio.fs.BasicFileAttributesHolder");
                mBasicFileAttributesHolderGet = basicFileAttributesHolderClazz.getMethod("get", new Class[0]);
                mBasicFileAttributesHolderGet.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            initializedBasicFileAttributesHolderClazz = true;
        }
    }

    private static boolean isBasicFileAttributesHolder(Path file) {
        FileTreeWalker.initBasicFileAttributesHolderClazz();
        return basicFileAttributesHolderClazz != null && basicFileAttributesHolderClazz.isInstance(file);
    }

    private static BasicFileAttributes extractFromBasicFileAttributesHolder(Path file) {
        try {
            BasicFileAttributes attrs = (BasicFileAttributes)mBasicFileAttributesHolderGet.invoke((Object)file, new Object[0]);
            wasBasicFileAttributesHolderGetAccessSuccess = true;
            return attrs;
        }
        catch (IllegalAccessException ex) {
            if (!wasBasicFileAttributesHolderGetAccessSuccess) {
                basicFileAttributesHolderClazz = null;
                mBasicFileAttributesHolderGet = null;
                Logger logger = LoggerFactory.getLogger(FileTreeWalker.class);
                logger.warn("Failed to access BasicFileAttributesHolder", (Throwable)ex);
                logger.warn("To fix this add '--add-exports java.base/sun.nio.fs=ALL-UNNAMED' as VM options");
            }
            return null;
        }
        catch (InvocationTargetException ignored) {
            return null;
        }
    }

    private BasicFileAttributes getAttributes(Path file, boolean canUseCached) throws IOException {
        BasicFileAttributes attrs;
        if (canUseCached) {
            if (FileTreeWalker.isBasicFileAttributesHolder(file) && System.getSecurityManager() == null) {
                BasicFileAttributes cached = FileTreeWalker.extractFromBasicFileAttributesHolder(file);
                if (!(cached == null || this.followLinks && cached.isSymbolicLink())) {
                    return cached;
                }
            }
        }
        try {
            attrs = Files.readAttributes(file, BasicFileAttributes.class, this.linkOptions);
        }
        catch (IOException ioe) {
            if (!this.followLinks) {
                throw ioe;
            }
            attrs = Files.readAttributes(file, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        return attrs;
    }

    private boolean wouldLoop(Path dir, Object key) {
        for (DirectoryNode ancestor : this.stack) {
            Object ancestorKey = ancestor.key();
            if (key != null && ancestorKey != null) {
                if (!key.equals(ancestorKey)) continue;
                return true;
            }
            try {
                if (!Files.isSameFile(dir, ancestor.directory())) continue;
                return true;
            }
            catch (IOException | SecurityException exception) {
            }
        }
        return false;
    }

    private Event visit(Path entry, boolean ignoreSecurityException, boolean canUseCached) {
        DirectoryStream<Path> stream;
        BasicFileAttributes attrs;
        try {
            attrs = this.getAttributes(entry, canUseCached);
        }
        catch (IOException ioe) {
            return new Event(EventType.ENTRY, entry, ioe);
        }
        catch (SecurityException se) {
            if (ignoreSecurityException) {
                return null;
            }
            throw se;
        }
        int depth = this.stack.size();
        if (depth >= this.maxDepth || !attrs.isDirectory() || attrs.isOther()) {
            return new Event(EventType.ENTRY, entry, attrs);
        }
        if (this.followLinks && this.wouldLoop(entry, attrs.fileKey())) {
            return new Event(EventType.ENTRY, entry, new FileSystemLoopException(entry.toString()));
        }
        try {
            stream = Files.newDirectoryStream(entry);
        }
        catch (IOException ioe) {
            return new Event(EventType.ENTRY, entry, ioe);
        }
        catch (SecurityException se) {
            if (ignoreSecurityException) {
                return null;
            }
            throw se;
        }
        this.stack.push(new DirectoryNode(entry, attrs.fileKey(), stream));
        return new Event(EventType.START_DIRECTORY, entry, attrs);
    }

    Event walk(Path file) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        Event ev = this.visit(file, false, false);
        assert (ev != null);
        return ev;
    }

    Event next() {
        Path entry;
        Event ev;
        DirectoryNode top = this.stack.peek();
        if (top == null) {
            return null;
        }
        do {
            entry = null;
            IOException ioe = null;
            if (!top.skipped()) {
                Iterator<Path> iterator = top.iterator();
                try {
                    if (iterator.hasNext()) {
                        entry = iterator.next();
                    }
                }
                catch (DirectoryIteratorException x) {
                    ioe = x.getCause();
                }
            }
            if (entry != null) continue;
            try {
                top.stream().close();
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                }
                ioe.addSuppressed(e);
            }
            this.stack.pop();
            return new Event(EventType.END_DIRECTORY, top.directory(), ioe);
        } while ((ev = this.visit(entry, true, true)) == null);
        return ev;
    }

    void pop() {
        if (!this.stack.isEmpty()) {
            DirectoryNode node = this.stack.pop();
            try {
                node.stream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            while (!this.stack.isEmpty()) {
                this.pop();
            }
            this.closed = true;
        }
    }

    private static class DirectoryNode {
        private final Path dir;
        private final Object key;
        private final DirectoryStream<Path> stream;
        private final Iterator<Path> iterator;
        private boolean skipped;

        DirectoryNode(Path dir, Object key, DirectoryStream<Path> stream) {
            this.dir = dir;
            this.key = key;
            this.stream = stream;
            this.iterator = stream.iterator();
        }

        Path directory() {
            return this.dir;
        }

        Object key() {
            return this.key;
        }

        DirectoryStream<Path> stream() {
            return this.stream;
        }

        Iterator<Path> iterator() {
            return this.iterator;
        }

        void skip() {
            this.skipped = true;
        }

        boolean skipped() {
            return this.skipped;
        }
    }

    static class Event {
        private final EventType type;
        private final Path file;
        private final BasicFileAttributes attrs;
        private final IOException ioe;

        private Event(EventType type, Path file, BasicFileAttributes attrs, IOException ioe) {
            this.type = type;
            this.file = file;
            this.attrs = attrs;
            this.ioe = ioe;
        }

        Event(EventType type, Path file, BasicFileAttributes attrs) {
            this(type, file, attrs, null);
        }

        Event(EventType type, Path file, IOException ioe) {
            this(type, file, null, ioe);
        }

        EventType type() {
            return this.type;
        }

        Path file() {
            return this.file;
        }

        BasicFileAttributes attributes() {
            return this.attrs;
        }

        IOException ioeException() {
            return this.ioe;
        }
    }

    static enum EventType {
        START_DIRECTORY,
        END_DIRECTORY,
        ENTRY;

    }
}

