/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.transfer.fcm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import software.xdev.testcontainers.imagebuilder.transfer.fcm.FileContentModifier;

public interface AdvancedFileContentModifier<T>
extends FileContentModifier {
    @Override
    default public InputStream apply(Path sourcePath, String targetPath, TarArchiveEntry tarArchiveEntry) throws IOException {
        T created;
        if (!this.shouldApply(sourcePath, targetPath, tarArchiveEntry)) {
            return null;
        }
        T original = this.readOriginal(sourcePath, targetPath, tarArchiveEntry);
        if (this.isIdentical(original, created = this.modify(original, sourcePath, targetPath, tarArchiveEntry))) {
            return null;
        }
        return this.createInputStream(this.createInputStreamData(created), tarArchiveEntry);
    }

    default public boolean shouldApply(Path sourcePath, String targetPath, TarArchiveEntry tarArchiveEntry) {
        return true;
    }

    public T readOriginal(Path var1, String var2, TarArchiveEntry var3) throws IOException;

    public T modify(T var1, Path var2, String var3, TarArchiveEntry var4) throws IOException;

    default public boolean isIdentical(T original, T created) {
        return original.equals(created);
    }

    public byte[] createInputStreamData(T var1) throws IOException;

    default public ByteArrayInputStream createInputStream(byte[] data, TarArchiveEntry tarArchiveEntry) {
        tarArchiveEntry.setSize((long)data.length);
        return new ByteArrayInputStream(data);
    }
}

