/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.jgit.ignore;

import java.util.Collections;
import java.util.List;
import software.xdev.testcontainers.imagebuilder.jgit.ignore.FastIgnoreRule;

public class IgnoreNode {
    protected final List<FastIgnoreRule> rules;

    public IgnoreNode(List<FastIgnoreRule> rules) {
        this.rules = rules;
    }

    public List<FastIgnoreRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public MatchResult isIgnored(String entryPath, boolean isDirectory) {
        Boolean result = this.checkIgnored(entryPath, isDirectory);
        if (result == null) {
            return MatchResult.CHECK_PARENT;
        }
        return result != false ? MatchResult.IGNORED : MatchResult.NOT_IGNORED;
    }

    public Boolean checkIgnored(String entryPath, boolean isDirectory) {
        for (int i = this.rules.size() - 1; i > -1; --i) {
            FastIgnoreRule rule = this.rules.get(i);
            if (!rule.isMatch(entryPath, isDirectory, true)) continue;
            return rule.getResult();
        }
        return null;
    }

    public String toString() {
        return this.rules.toString();
    }

    public static enum MatchResult {
        NOT_IGNORED,
        IGNORED,
        CHECK_PARENT;

    }
}

