/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.compat;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import software.xdev.testcontainers.imagebuilder.jgit.errors.InvalidPatternException;
import software.xdev.testcontainers.imagebuilder.jgit.ignore.internal.Strings;
import software.xdev.testcontainers.imagebuilder.transfer.DockerFileLineModifier;

public class DockerfileCOPYParentsEmulator
implements DockerFileLineModifier {
    @Override
    public List<String> modify(List<String> lines, Set<String> relativeFiles) {
        List<String> trimmedLines = lines.stream().map(String::trim).toList();
        if (trimmedLines.stream().noneMatch(s -> s.startsWith("# syntax=docker/dockerfile:") && s.endsWith("-labs"))) {
            return lines;
        }
        return trimmedLines.stream().flatMap(line -> this.handleLine((String)line, relativeFiles)).toList();
    }

    protected Stream<String> handleLine(String line, Set<String> relativeFiles) {
        boolean isLastArg;
        String parentsArg = " --parents";
        if (!line.startsWith("COPY") || !line.contains(" --parents")) {
            return Stream.of(line);
        }
        int parentsArgIndex = line.indexOf(" --parents");
        String lineBeforeArgs = line.substring(0, parentsArgIndex);
        String lineAfterArgs = "";
        String targetPath = "";
        String argsStr = line.substring(parentsArgIndex + " --parents".length() + 1);
        boolean bl = isLastArg = !argsStr.contains(" --");
        if (!isLastArg) {
            int nextArgIndicatorIndex = argsStr.indexOf(" --");
            lineAfterArgs = argsStr.substring(nextArgIndicatorIndex + 1);
            lineAfterArgs = lineAfterArgs.substring(0, lineAfterArgs.lastIndexOf(32));
            targetPath = argsStr.substring(nextArgIndicatorIndex + lineAfterArgs.length() + 2);
            argsStr = argsStr.substring(0, nextArgIndicatorIndex);
        }
        String[] args = argsStr.split(" ");
        if (isLastArg) {
            targetPath = args[args.length - 1];
        }
        String lineAfterArgsFinal = lineAfterArgs;
        String targetPathFinal = targetPath;
        Object targetPathFinalForRelative = targetPathFinal.endsWith("/") ? targetPathFinal : targetPathFinal + "/";
        return Stream.of(args).limit((long)args.length - (long)(isLastArg ? 1 : 0)).flatMap(arg_0 -> DockerfileCOPYParentsEmulator.lambda$handleLine$3((String)targetPathFinalForRelative, relativeFiles, arg_0)).map(e -> lineBeforeArgs + " " + (String)e.getKey() + (String)(!lineAfterArgsFinal.isEmpty() ? " " + lineAfterArgsFinal : "") + " " + (String)e.getValue());
    }

    protected static String removeRelativeStart(String path) {
        return path.startsWith("./") ? path.substring(2) : path;
    }

    private static /* synthetic */ Stream lambda$handleLine$3(String targetPathFinalForRelative, Set relativeFiles, String source) {
        if (!source.contains("*")) {
            return Stream.of(Map.entry(source, targetPathFinalForRelative + DockerfileCOPYParentsEmulator.removeRelativeStart(source)));
        }
        GlobMatcher matcher = new GlobMatcher(source);
        return relativeFiles.stream().filter(matcher::matches).sorted().map(s -> Map.entry(s, targetPathFinalForRelative + s));
    }

    public static class GlobMatcher {
        protected final Pattern pattern;

        public GlobMatcher(String pattern) {
            try {
                this.pattern = Pattern.compile("\\/?" + String.valueOf(Strings.convertGlob(DockerfileCOPYParentsEmulator.removeRelativeStart(pattern))));
            }
            catch (InvalidPatternException e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected String correctPathForMatching(String path) {
            return (path = DockerfileCOPYParentsEmulator.removeRelativeStart(path)).startsWith("/") ? path : "/" + path;
        }

        public boolean matches(String path) {
            return this.pattern.matcher(this.correctPathForMatching(path)).matches();
        }
    }
}

