/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder;

import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedParsedDockerfile {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedParsedDockerfile.class);
    protected static final Pattern FROM_LINE_PATTERN = Pattern.compile("FROM (?<arg>--\\S+\\s)*(?<image>\\S+)(?:\\s+AS\\s+(?<as>\\S+))?.*", 2);
    protected final Path dockerFilePath;
    protected Set<String> dependencyImageNames = Collections.emptySet();
    protected Set<String> internalDependencyImageNames = Collections.emptySet();
    protected Set<String> externalImageNames = Collections.emptySet();
    protected final Map<String, Optional<String>> arguments = new HashMap<String, Optional<String>>();

    public AdvancedParsedDockerfile(Path dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        this.parse(this.read());
    }

    protected List<String> read() {
        if (!Files.exists(this.dockerFilePath, new LinkOption[0])) {
            LOG.warn("Tried to parse Dockerfile at path {} but none was found", (Object)this.dockerFilePath);
            return Collections.emptyList();
        }
        try {
            return Files.readAllLines(this.dockerFilePath);
        }
        catch (IOException e) {
            LOG.warn("Unable to read Dockerfile at path {}", (Object)this.dockerFilePath, (Object)e);
            return Collections.emptyList();
        }
    }

    protected void parse(List<String> lines) {
        List<Matcher> matchedFromLines = lines.stream().map(FROM_LINE_PATTERN::matcher).filter(Matcher::matches).toList();
        this.dependencyImageNames = matchedFromLines.stream().map(matcher -> matcher.group("image")).collect(Collectors.toSet());
        if (!this.dependencyImageNames.isEmpty()) {
            LOG.debug("Found dependency images in Dockerfile {}: {}", (Object)this.dockerFilePath, this.dependencyImageNames);
        }
        this.internalDependencyImageNames = matchedFromLines.stream().map(m -> m.group("as")).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!this.internalDependencyImageNames.isEmpty()) {
            LOG.debug("Found internal dependency images in Dockerfile {}: {}", (Object)this.dockerFilePath, this.internalDependencyImageNames);
        }
        this.externalImageNames = this.dependencyImageNames.stream().filter(i -> !this.internalDependencyImageNames.contains(i)).collect(Collectors.toSet());
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(lines.stream().filter(line -> line.length() > 4 && line.startsWith("ARG ")).map(line -> line.substring(4)).collect(Collectors.joining("\n"))));
        }
        catch (IOException e) {
            LOG.error("Unable to load Args from Dockerfile {}", (Object)this.dockerFilePath);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String value = entry.getValue().toString();
            this.arguments.put(entry.getKey().toString(), value.isEmpty() ? Optional.empty() : Optional.of(value));
        }
        if (!this.arguments.isEmpty()) {
            LOG.debug("Found args in Dockerfile {}: {}", (Object)this.dockerFilePath, this.arguments);
        }
    }

    public Set<String> getDependencyImageNames() {
        return this.dependencyImageNames;
    }

    public Set<String> getInternalDependencyImageNames() {
        return this.internalDependencyImageNames;
    }

    public Set<String> getExternalImageNames() {
        return this.externalImageNames;
    }

    public Map<String, Optional<String>> getArguments() {
        return this.arguments;
    }
}

