/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.transfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import software.xdev.testcontainers.imagebuilder.transfer.FastFilePathUtil;
import software.xdev.testcontainers.imagebuilder.transfer.FileContentModifier;

public class TransferArchiveTARCompressor {
    protected final List<FileContentModifier> fileContentModifiers = new ArrayList<FileContentModifier>();

    public TransferArchiveTARCompressor withContentModifier(FileContentModifier modifier) {
        this.fileContentModifiers.add(modifier);
        return this;
    }

    public File archiveTARFiles(File base, Iterable<Path> filesPaths, String archiveNameWithOutExtension) throws IOException {
        File tarFile = new File(FileUtils.getTempDirectoryPath(), archiveNameWithOutExtension + ".tar");
        tarFile.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            tos.setLongFileMode(3);
            tos.setBigNumberMode(2);
            for (Path filePath : filesPaths) {
                this.addFileToTar(tos, filePath, FastFilePathUtil.relativize(base.toPath(), filePath));
            }
        }
        return tarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileToTar(TarArchiveOutputStream tarArchiveOutputStream, Path file, String entryName) throws IOException {
        try {
            if (Files.isSymbolicLink(file)) {
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(entryName, 50);
                tarArchiveEntry.setLinkName(Files.readSymbolicLink(file).toString());
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                return;
            }
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)tarArchiveOutputStream.createArchiveEntry(file.toFile(), entryName);
            if (file.toFile().canExecute()) {
                tarArchiveEntry.setMode(tarArchiveEntry.getMode() | 0x1ED);
            }
            if (!file.toFile().isFile()) {
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                return;
            }
            try (InputStream input = this.createInputStreamForFile(file, tarArchiveEntry);){
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
                IOUtils.copy((InputStream)input, (OutputStream)tarArchiveOutputStream);
            }
        }
        finally {
            tarArchiveOutputStream.closeArchiveEntry();
        }
    }

    protected InputStream createInputStreamForFile(Path filePath, TarArchiveEntry tarArchiveEntry) throws IOException {
        for (FileContentModifier fcm : this.fileContentModifiers) {
            InputStream is = fcm.apply(filePath, tarArchiveEntry);
            if (is == null) continue;
            return is;
        }
        return new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0]));
    }
}

