/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.transfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import software.xdev.testcontainers.imagebuilder.jgit.ignore.FastIgnoreRule;
import software.xdev.testcontainers.imagebuilder.jgit.ignore.IgnoreNode;
import software.xdev.testcontainers.imagebuilder.transfer.FastFilePathUtil;
import software.xdev.testcontainers.imagebuilder.transfer.TransferArchiveTARCompressor;
import software.xdev.testcontainers.imagebuilder.transfer.TransferFilesCreator;

public class DefaultTransferFilesCreator
implements TransferFilesCreator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTransferFilesCreator.class);
    private final Path baseDir;
    private final Path ignoreFileRelativeToBaseDir;

    public DefaultTransferFilesCreator(Path baseDir, Path ignoreFileRelativeToBaseDir) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.ignoreFileRelativeToBaseDir = ignoreFileRelativeToBaseDir;
    }

    @Override
    public Map<Path, String> determineFilesToTransfer(Set<String> preGitIgnoreLines, Predicate<String> ignoreFileLineFilter, Set<String> postGitIgnoreLines, Set<String> alwaysIncludedRelativePaths) {
        try {
            LinkedHashSet<String> ignoreLines = new LinkedHashSet<String>(preGitIgnoreLines);
            if (this.ignoreFileRelativeToBaseDir != null) {
                ignoreLines.addAll(Files.readAllLines(this.baseDir.resolve(this.ignoreFileRelativeToBaseDir)).stream().filter(ignoreFileLineFilter).toList());
            }
            ignoreLines.addAll(postGitIgnoreLines);
            IgnoreNode ignoreNode = this.createIgnoreNode(ignoreLines);
            return this.walkFilesAndDetermineTransfer(ignoreNode, alwaysIncludedRelativePaths);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected IgnoreNode createIgnoreNode(Set<String> ignoreLines) {
        return new IgnoreNode(ignoreLines.stream().filter(Objects::nonNull).filter(s -> !s.isBlank()).filter(s -> !s.startsWith("#")).map(pattern -> {
            try {
                FastIgnoreRule rule = new FastIgnoreRule();
                rule.parse((String)pattern);
                return rule;
            }
            catch (Exception ex) {
                LOG.warn("Failed to parse {}", pattern, (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).toList());
    }

    protected Map<Path, String> walkFilesAndDetermineTransfer(IgnoreNode ignoreNode, Set<String> alwaysIncludedRelativePaths) throws IOException {
        try (Stream<Path> walk = Files.find(this.baseDir, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);){
            ConcurrentHashMap cachedDirectoryOutcome = new ConcurrentHashMap();
            Map map = ((Stream)walk.toList().stream().parallel()).map(file -> this.determineFileForTransfer(ignoreNode, alwaysIncludedRelativePaths, (Path)file, cachedDirectoryOutcome)).filter(Objects::nonNull).sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, r) -> r, LinkedHashMap::new));
            return map;
        }
    }

    protected Map.Entry<Path, String> determineFileForTransfer(IgnoreNode ignoreNode, Set<String> alwaysIncludedRelativePaths, Path file, Map<String, Boolean> cachedDirectoryOutcome) {
        String relativePath = FastFilePathUtil.relativize(this.baseDir, file);
        Optional<Map.Entry<Path, String>> outcomeFile = this.shouldIgnore(ignoreNode, alwaysIncludedRelativePaths, file, relativePath, relativePath, false);
        if (outcomeFile != null) {
            return outcomeFile.orElse(null);
        }
        ArrayList<String> processedDirs = new ArrayList<String>();
        Map.Entry<Path, String> outcomeDirs = this.determineParentDirectoryForTransfer(ignoreNode, alwaysIncludedRelativePaths, file, cachedDirectoryOutcome, relativePath, processedDirs);
        processedDirs.forEach(d -> cachedDirectoryOutcome.put((String)d, outcomeDirs != null));
        return outcomeDirs;
    }

    protected Map.Entry<Path, String> determineParentDirectoryForTransfer(IgnoreNode ignoreNode, Set<String> alwaysIncludedRelativePaths, Path file, Map<String, Boolean> cachedDirectoryOutcome, String relativePath, List<String> processedDirs) {
        String currentParentDirPath = this.parentDirectory(relativePath);
        while (currentParentDirPath != null) {
            Boolean cachedOutcome = cachedDirectoryOutcome.get(currentParentDirPath);
            if (cachedOutcome != null) {
                return cachedOutcome != false ? Map.entry(file, relativePath) : null;
            }
            processedDirs.add(currentParentDirPath);
            Optional<Map.Entry<Path, String>> outcome = this.shouldIgnore(ignoreNode, alwaysIncludedRelativePaths, file, relativePath, currentParentDirPath, true);
            if (outcome != null) {
                return outcome.orElse(null);
            }
            currentParentDirPath = this.parentDirectory(currentParentDirPath);
        }
        return Map.entry(file, relativePath);
    }

    protected String parentDirectory(String dir) {
        int dirSepIndex = dir.lastIndexOf(47);
        return dirSepIndex != -1 ? dir.substring(0, dirSepIndex) : null;
    }

    protected Optional<Map.Entry<Path, String>> shouldIgnore(IgnoreNode ignoreNode, Set<String> alwaysIncludedRelativePaths, Path file, String relativePath, String relativeWorkingPath, boolean isDirectory) {
        if (alwaysIncludedRelativePaths.contains(relativeWorkingPath)) {
            return Optional.of(Map.entry(file, relativePath));
        }
        IgnoreNode.MatchResult result = ignoreNode.isIgnored(relativeWorkingPath, isDirectory);
        if (result == IgnoreNode.MatchResult.NOT_IGNORED) {
            return Optional.of(Map.entry(file, relativePath));
        }
        if (result == IgnoreNode.MatchResult.IGNORED) {
            return Optional.empty();
        }
        return null;
    }

    @Override
    public InputStream getAllFilesToTransferAsTarInputStream(Collection<Path> filesToTransfer, TransferArchiveTARCompressor transferArchiveTARCompressor) {
        File dockerFolderTar = null;
        try {
            final File dockerFolderTarInner = dockerFolderTar = transferArchiveTARCompressor.archiveTARFiles(this.baseDir.toFile(), filesToTransfer, UUID.randomUUID().toString());
            final FileInputStream tarInputStream = FileUtils.openInputStream((File)dockerFolderTar);
            return new InputStream(){

                @Override
                public int available() throws IOException {
                    return tarInputStream.available();
                }

                @Override
                public int read() throws IOException {
                    return tarInputStream.read();
                }

                @Override
                public int read(byte[] buff, int offset, int len) throws IOException {
                    return tarInputStream.read(buff, offset, len);
                }

                @Override
                public void close() {
                    IOUtils.closeQuietly((InputStream)tarInputStream);
                    FileUtils.deleteQuietly((File)dockerFolderTarInner);
                }
            };
        }
        catch (IOException ioe) {
            FileUtils.deleteQuietly(dockerFolderTar);
            throw new UncheckedIOException(ioe);
        }
    }
}

