/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.imagebuilder.jgit.ignore;

import software.xdev.testcontainers.imagebuilder.jgit.errors.InvalidPatternException;
import software.xdev.testcontainers.imagebuilder.jgit.ignore.IMatcher;
import software.xdev.testcontainers.imagebuilder.jgit.ignore.internal.PathMatcher;
import software.xdev.testcontainers.imagebuilder.jgit.ignore.internal.Strings;

public class FastIgnoreRule {
    public static final char PATH_SEPARATOR = '/';
    protected IMatcher matcher = IMatcher.NO_MATCH;
    protected boolean inverse;
    protected boolean dirOnly;

    public void parse(String pattern) throws InvalidPatternException {
        char next;
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null!");
        }
        if (pattern.isEmpty()) {
            this.dirOnly = false;
            this.inverse = false;
            this.matcher = IMatcher.NO_MATCH;
            return;
        }
        boolean bl = this.inverse = pattern.charAt(0) == '!';
        if (this.inverse && (pattern = pattern.substring(1)).isEmpty()) {
            this.dirOnly = false;
            this.matcher = IMatcher.NO_MATCH;
            return;
        }
        if (pattern.charAt(0) == '#') {
            this.matcher = IMatcher.NO_MATCH;
            this.dirOnly = false;
            return;
        }
        if (pattern.charAt(0) == '\\' && pattern.length() > 1 && ((next = pattern.charAt(1)) == '!' || next == '#')) {
            pattern = pattern.substring(1);
        }
        this.dirOnly = Strings.isDirectoryPattern(pattern);
        if (this.dirOnly) {
            pattern = Strings.stripTrailingWhitespace(pattern);
            if ((pattern = Strings.stripTrailing(pattern, '/')).isEmpty()) {
                this.matcher = IMatcher.NO_MATCH;
                return;
            }
        }
        this.matcher = PathMatcher.createPathMatcher(pattern, Character.valueOf('/'), this.dirOnly);
    }

    public boolean isMatch(String path, boolean directory) {
        return this.isMatch(path, directory, false);
    }

    public boolean isMatch(String path, boolean directory, boolean pathMatch) {
        if (path == null) {
            return false;
        }
        if (path.isEmpty()) {
            return false;
        }
        return this.matcher.matches(path, directory, pathMatch);
    }

    public boolean getNameOnly() {
        return !(this.matcher instanceof PathMatcher);
    }

    public boolean dirOnly() {
        return this.dirOnly;
    }

    public boolean getNegation() {
        return this.inverse;
    }

    public boolean getResult() {
        return !this.inverse;
    }

    public boolean isEmpty() {
        return this.matcher == IMatcher.NO_MATCH;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.inverse) {
            sb.append('!');
        }
        sb.append(this.matcher);
        if (this.dirOnly) {
            sb.append('/');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inverse ? 1231 : 1237);
        result = 31 * result + (this.dirOnly ? 1231 : 1237);
        result = 31 * result + (this.matcher == null ? 0 : this.matcher.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FastIgnoreRule)) {
            return false;
        }
        FastIgnoreRule other = (FastIgnoreRule)obj;
        if (this.inverse != other.inverse) {
            return false;
        }
        if (this.dirOnly != other.dirOnly) {
            return false;
        }
        return this.matcher.equals(other.matcher);
    }
}

