/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.spring.AddSpringProperty;

public class AddSpringPropertyIfClassExists
extends Recipe {
    @Option(displayName="Class that must exist in the classpath to add the property", description="Name of the class that must exist in the classpath to execute the recipe to add a property in the properties file.", example="software.xdev")
    private String className;
    @Option(displayName="Property key", description="The property key to add.", example="management.metrics.enable.process.files")
    private String property;
    @Option(displayName="Property value", description="The value of the new property key.", example="true")
    private String value;
    @Option(displayName="Optional comment to be prepended to the property", description="A comment that will be added to the new property.", required=false, example="This is a comment")
    @Nullable
    private String comment;
    @Option(displayName="Optional list of file path matcher", description="Each value in this list represents a glob expression that is used to match which files will be modified. If this value is not present, this recipe will query the execution context for reasonable defaults. (\"**/application.yml\", \"**/application.yml\", and \"**/application.properties\".", required=false, example="[\"**/application.yml\"]")
    @Nullable
    private List<String> pathExpressions;

    @NotNull
    public String getDisplayName() {
        return "AddSpringPropertyIfClassExists";
    }

    @NotNull
    public String getDescription() {
        return "Add a spring property to the properties file if a specific class exists.";
    }

    @NotNull
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        if (!this.doesClasspathContainClass(this.className)) {
            return TreeVisitor.noop();
        }
        return new AddSpringProperty(this.property, this.value, this.comment, this.pathExpressions).getVisitor();
    }

    private boolean doesClasspathContainClass(String classToCheck) {
        try {
            Class.forName(classToCheck, false, ((Object)((Object)this)).getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getPathExpressions() {
        return this.pathExpressions;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setPathExpressions(List<String> pathExpressions) {
        this.pathExpressions = pathExpressions;
    }

    public AddSpringPropertyIfClassExists(String className, String property, String value, String comment, List<String> pathExpressions) {
        this.className = className;
        this.property = property;
        this.value = value;
        this.comment = comment;
        this.pathExpressions = pathExpressions;
    }

    public AddSpringPropertyIfClassExists() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSpringPropertyIfClassExists)) {
            return false;
        }
        AddSpringPropertyIfClassExists other = (AddSpringPropertyIfClassExists)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<String> this$pathExpressions = this.getPathExpressions();
        List<String> other$pathExpressions = other.getPathExpressions();
        return !(this$pathExpressions == null ? other$pathExpressions != null : !((Object)this$pathExpressions).equals(other$pathExpressions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddSpringPropertyIfClassExists;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<String> $pathExpressions = this.getPathExpressions();
        result = result * 59 + ($pathExpressions == null ? 43 : ((Object)$pathExpressions).hashCode());
        return result;
    }
}

