/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.spring.data.eclipse.store;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public class AddAnnotationToOtherAnnotation
extends Recipe {
    @Option(displayName="Existing annotation type", description="Annotation type that is already existing. Recipe is looking for this annotation to add the new annotation.", example="org.junit.jupiter.api.Test")
    String existingAnnotationType;
    @Option(displayName="Annotation type to add", description="Annotation type that should be added to the existing annotation type.", example="org.junit.jupiter.api.Test")
    String annotationTypeToAdd;
    @Option(displayName="Class path", description="Class path that needs to be added for the new annotation. Can be empty.", example="spring-data-eclipse-store", required=false)
    String classPath;
    @Option(displayName="Simple name of annotation type to add", description="Simple name of annotation type that should be added to the existing annotation type.", example="Test")
    String annotationTypeToAddSimpleName;

    @NotNull
    public String getDisplayName() {
        return "AddAnnotationToOtherAnnotation";
    }

    @NotNull
    public String getDescription() {
        return "Add the a new annotation to an existing annotation.";
    }

    @NotNull
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final AnnotationMatcher existingAnnotationMatcher = new AnnotationMatcher(this.existingAnnotationType);
        final AnnotationMatcher newAnnotationMatcher = new AnnotationMatcher(this.annotationTypeToAdd);
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull J.ClassDeclaration visitClassDeclaration(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext executionContext) {
                J.ClassDeclaration cd;
                block3: {
                    block2: {
                        cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
                        if (cd.getLeadingAnnotations().stream().filter(arg_0 -> ((AnnotationMatcher)existingAnnotationMatcher).matches(arg_0)).findAny().isEmpty()) break block2;
                        if (!cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)newAnnotationMatcher).matches(arg_0))) break block3;
                    }
                    return cd;
                }
                JavaTemplate componentAnnotationTemplate = JavaTemplate.builder((String)"#{}").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{AddAnnotationToOtherAnnotation.this.classPath})).imports(new String[]{AddAnnotationToOtherAnnotation.this.annotationTypeToAdd}).build();
                this.maybeAddImport(AddAnnotationToOtherAnnotation.this.annotationTypeToAdd);
                return (J.ClassDeclaration)componentAnnotationTemplate.apply(this.getCursor(), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[]{"@" + AddAnnotationToOtherAnnotation.this.annotationTypeToAddSimpleName});
            }
        };
    }

    public String getExistingAnnotationType() {
        return this.existingAnnotationType;
    }

    public String getAnnotationTypeToAdd() {
        return this.annotationTypeToAdd;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getAnnotationTypeToAddSimpleName() {
        return this.annotationTypeToAddSimpleName;
    }

    public void setExistingAnnotationType(String existingAnnotationType) {
        this.existingAnnotationType = existingAnnotationType;
    }

    public void setAnnotationTypeToAdd(String annotationTypeToAdd) {
        this.annotationTypeToAdd = annotationTypeToAdd;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setAnnotationTypeToAddSimpleName(String annotationTypeToAddSimpleName) {
        this.annotationTypeToAddSimpleName = annotationTypeToAddSimpleName;
    }

    public AddAnnotationToOtherAnnotation(String existingAnnotationType, String annotationTypeToAdd, String classPath, String annotationTypeToAddSimpleName) {
        this.existingAnnotationType = existingAnnotationType;
        this.annotationTypeToAdd = annotationTypeToAdd;
        this.classPath = classPath;
        this.annotationTypeToAddSimpleName = annotationTypeToAddSimpleName;
    }

    public AddAnnotationToOtherAnnotation() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddAnnotationToOtherAnnotation)) {
            return false;
        }
        AddAnnotationToOtherAnnotation other = (AddAnnotationToOtherAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$existingAnnotationType = this.getExistingAnnotationType();
        String other$existingAnnotationType = other.getExistingAnnotationType();
        if (this$existingAnnotationType == null ? other$existingAnnotationType != null : !this$existingAnnotationType.equals(other$existingAnnotationType)) {
            return false;
        }
        String this$annotationTypeToAdd = this.getAnnotationTypeToAdd();
        String other$annotationTypeToAdd = other.getAnnotationTypeToAdd();
        if (this$annotationTypeToAdd == null ? other$annotationTypeToAdd != null : !this$annotationTypeToAdd.equals(other$annotationTypeToAdd)) {
            return false;
        }
        String this$classPath = this.getClassPath();
        String other$classPath = other.getClassPath();
        if (this$classPath == null ? other$classPath != null : !this$classPath.equals(other$classPath)) {
            return false;
        }
        String this$annotationTypeToAddSimpleName = this.getAnnotationTypeToAddSimpleName();
        String other$annotationTypeToAddSimpleName = other.getAnnotationTypeToAddSimpleName();
        return !(this$annotationTypeToAddSimpleName == null ? other$annotationTypeToAddSimpleName != null : !this$annotationTypeToAddSimpleName.equals(other$annotationTypeToAddSimpleName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddAnnotationToOtherAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $existingAnnotationType = this.getExistingAnnotationType();
        result = result * 59 + ($existingAnnotationType == null ? 43 : $existingAnnotationType.hashCode());
        String $annotationTypeToAdd = this.getAnnotationTypeToAdd();
        result = result * 59 + ($annotationTypeToAdd == null ? 43 : $annotationTypeToAdd.hashCode());
        String $classPath = this.getClassPath();
        result = result * 59 + ($classPath == null ? 43 : $classPath.hashCode());
        String $annotationTypeToAddSimpleName = this.getAnnotationTypeToAddSimpleName();
        result = result * 59 + ($annotationTypeToAddSimpleName == null ? 43 : $annotationTypeToAddSimpleName.hashCode());
        return result;
    }
}

