/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.xdev.chartjs.model.enums.IndexAxis;

public abstract class Dataset<T extends Dataset<T, O>, O> {
    protected String type;
    protected final List<Object> data = new ArrayList<Object>();
    protected IndexAxis indexAxis;
    protected Object clip;
    protected String label;
    protected Number order;
    protected String stack;
    protected Boolean hidden;

    protected abstract String defaultType();

    public T withDefaultType() {
        return this.setType(this.defaultType());
    }

    public String getType() {
        return this.type;
    }

    public T setType(String type) {
        this.type = type;
        return this.self();
    }

    public List<Object> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public <X> List<X> getData(Class<X> filterClazz) {
        return this.data.stream().filter(filterClazz::isInstance).map(filterClazz::cast).collect(Collectors.toUnmodifiableList());
    }

    public T setDataUnchecked(Collection<?> data) {
        this.clearData();
        if (data != null) {
            this.data.addAll(data);
        }
        return this.self();
    }

    public T setData(Collection<O> data) {
        return this.setDataUnchecked(data);
    }

    public T setDataUnchecked(Object ... data) {
        return this.setDataUnchecked(Arrays.asList(data));
    }

    public T setData(O ... data) {
        return this.setData((Collection<O>)Arrays.asList(data));
    }

    public T clearData() {
        this.data.clear();
        return this.self();
    }

    public T addDataUnchecked(Object data) {
        this.data.add(data);
        return this.self();
    }

    public T addData(O data) {
        return this.addDataUnchecked(data);
    }

    public IndexAxis getIndexAxis() {
        return this.indexAxis;
    }

    public T setIndexAxis(IndexAxis indexAxis) {
        this.indexAxis = indexAxis;
        return this.self();
    }

    public Object getClip() {
        return this.clip;
    }

    public T setClip(Object clip) {
        this.clip = clip;
        return this.self();
    }

    public String getLabel() {
        return this.label;
    }

    public T setLabel(String label) {
        this.label = label;
        return this.self();
    }

    public Number getOrder() {
        return this.order;
    }

    public T setOrder(Number order) {
        this.order = order;
        return this.self();
    }

    public String getStack() {
        return this.stack;
    }

    public T setStack(String stack) {
        this.stack = stack;
        return this.self();
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public T setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this.self();
    }

    public T self() {
        return (T)this;
    }
}

