/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.TierRequestAccessConditionsInner;
import software.xdev.brevo.model.TierRequestTierRewardsInner;

@JsonPropertyOrder(value={"name", "imageRef", "accessConditions", "tierRewards"})
@JsonTypeName(value="tierRequest")
public class TierRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_IMAGE_REF = "imageRef";
    @Nullable
    private String imageRef;
    public static final String JSON_PROPERTY_ACCESS_CONDITIONS = "accessConditions";
    @Nonnull
    private List<TierRequestAccessConditionsInner> accessConditions = new ArrayList<TierRequestAccessConditionsInner>();
    public static final String JSON_PROPERTY_TIER_REWARDS = "tierRewards";
    @Nullable
    private List<TierRequestTierRewardsInner> tierRewards = new ArrayList<TierRequestTierRewardsInner>();

    public TierRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public TierRequest imageRef(@Nullable String imageRef) {
        this.imageRef = imageRef;
        return this;
    }

    @Nullable
    @JsonProperty(value="imageRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageRef() {
        return this.imageRef;
    }

    @JsonProperty(value="imageRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageRef(@Nullable String imageRef) {
        this.imageRef = imageRef;
    }

    public TierRequest accessConditions(@Nonnull List<TierRequestAccessConditionsInner> accessConditions) {
        this.accessConditions = accessConditions;
        return this;
    }

    public TierRequest addAccessConditionsItem(TierRequestAccessConditionsInner accessConditionsItem) {
        if (this.accessConditions == null) {
            this.accessConditions = new ArrayList<TierRequestAccessConditionsInner>();
        }
        this.accessConditions.add(accessConditionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="accessConditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TierRequestAccessConditionsInner> getAccessConditions() {
        return this.accessConditions;
    }

    @JsonProperty(value="accessConditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccessConditions(@Nonnull List<TierRequestAccessConditionsInner> accessConditions) {
        this.accessConditions = accessConditions;
    }

    public TierRequest tierRewards(@Nullable List<TierRequestTierRewardsInner> tierRewards) {
        this.tierRewards = tierRewards;
        return this;
    }

    public TierRequest addTierRewardsItem(TierRequestTierRewardsInner tierRewardsItem) {
        if (this.tierRewards == null) {
            this.tierRewards = new ArrayList<TierRequestTierRewardsInner>();
        }
        this.tierRewards.add(tierRewardsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tierRewards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TierRequestTierRewardsInner> getTierRewards() {
        return this.tierRewards;
    }

    @JsonProperty(value="tierRewards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTierRewards(@Nullable List<TierRequestTierRewardsInner> tierRewards) {
        this.tierRewards = tierRewards;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierRequest tierRequest = (TierRequest)o;
        return Objects.equals(this.name, tierRequest.name) && Objects.equals(this.imageRef, tierRequest.imageRef) && Objects.equals(this.accessConditions, tierRequest.accessConditions) && Objects.equals(this.tierRewards, tierRequest.tierRewards);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.imageRef, this.accessConditions, this.tierRewards);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TierRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    imageRef: ").append(this.toIndentedString(this.imageRef)).append("\n");
        sb.append("    accessConditions: ").append(this.toIndentedString(this.accessConditions)).append("\n");
        sb.append("    tierRewards: ").append(this.toIndentedString(this.tierRewards)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getImageRef() != null) {
            try {
                joiner.add(String.format("%simageRef%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getImageRef()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAccessConditions() != null) {
            for (i = 0; i < this.getAccessConditions().size(); ++i) {
                if (this.getAccessConditions().get(i) == null) continue;
                joiner.add(this.getAccessConditions().get(i).toUrlQueryString(String.format("%saccessConditions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getTierRewards() != null) {
            for (i = 0; i < this.getTierRewards().size(); ++i) {
                if (this.getTierRewards().get(i) == null) continue;
                joiner.add(this.getTierRewards().get(i).toUrlQueryString(String.format("%stierRewards%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

