/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "name", "tierOrder", "loyaltyProgramId", "upgradeStrategy", "downgradeStrategy", "createdAt", "updatedAt"})
@JsonTypeName(value="tierGroup")
public class TierGroup {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_TIER_ORDER = "tierOrder";
    @Nullable
    private List<UUID> tierOrder = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
    @Nullable
    private UUID loyaltyProgramId;
    public static final String JSON_PROPERTY_UPGRADE_STRATEGY = "upgradeStrategy";
    @Nullable
    private UpgradeStrategyEnum upgradeStrategy = UpgradeStrategyEnum.REAL_TIME;
    public static final String JSON_PROPERTY_DOWNGRADE_STRATEGY = "downgradeStrategy";
    @Nullable
    private DowngradeStrategyEnum downgradeStrategy = DowngradeStrategyEnum.REAL_TIME;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    @Nullable
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private OffsetDateTime updatedAt;

    public TierGroup id(@Nullable UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable UUID id) {
        this.id = id;
    }

    public TierGroup name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public TierGroup tierOrder(@Nullable List<UUID> tierOrder) {
        this.tierOrder = tierOrder;
        return this;
    }

    public TierGroup addTierOrderItem(UUID tierOrderItem) {
        if (this.tierOrder == null) {
            this.tierOrder = new ArrayList<UUID>();
        }
        this.tierOrder.add(tierOrderItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tierOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getTierOrder() {
        return this.tierOrder;
    }

    @JsonProperty(value="tierOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTierOrder(@Nullable List<UUID> tierOrder) {
        this.tierOrder = tierOrder;
    }

    public TierGroup loyaltyProgramId(@Nullable UUID loyaltyProgramId) {
        this.loyaltyProgramId = loyaltyProgramId;
        return this;
    }

    @Nullable
    @JsonProperty(value="loyaltyProgramId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonProperty(value="loyaltyProgramId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoyaltyProgramId(@Nullable UUID loyaltyProgramId) {
        this.loyaltyProgramId = loyaltyProgramId;
    }

    public TierGroup upgradeStrategy(@Nullable UpgradeStrategyEnum upgradeStrategy) {
        this.upgradeStrategy = upgradeStrategy;
        return this;
    }

    @Nullable
    @JsonProperty(value="upgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpgradeStrategyEnum getUpgradeStrategy() {
        return this.upgradeStrategy;
    }

    @JsonProperty(value="upgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpgradeStrategy(@Nullable UpgradeStrategyEnum upgradeStrategy) {
        this.upgradeStrategy = upgradeStrategy;
    }

    public TierGroup downgradeStrategy(@Nullable DowngradeStrategyEnum downgradeStrategy) {
        this.downgradeStrategy = downgradeStrategy;
        return this;
    }

    @Nullable
    @JsonProperty(value="downgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowngradeStrategyEnum getDowngradeStrategy() {
        return this.downgradeStrategy;
    }

    @JsonProperty(value="downgradeStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDowngradeStrategy(@Nullable DowngradeStrategyEnum downgradeStrategy) {
        this.downgradeStrategy = downgradeStrategy;
    }

    public TierGroup createdAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public TierGroup updatedAt(@Nullable OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierGroup tierGroup = (TierGroup)o;
        return Objects.equals(this.id, tierGroup.id) && Objects.equals(this.name, tierGroup.name) && Objects.equals(this.tierOrder, tierGroup.tierOrder) && Objects.equals(this.loyaltyProgramId, tierGroup.loyaltyProgramId) && Objects.equals((Object)this.upgradeStrategy, (Object)tierGroup.upgradeStrategy) && Objects.equals((Object)this.downgradeStrategy, (Object)tierGroup.downgradeStrategy) && Objects.equals(this.createdAt, tierGroup.createdAt) && Objects.equals(this.updatedAt, tierGroup.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.tierOrder, this.loyaltyProgramId, this.upgradeStrategy, this.downgradeStrategy, this.createdAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TierGroup {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tierOrder: ").append(this.toIndentedString(this.tierOrder)).append("\n");
        sb.append("    loyaltyProgramId: ").append(this.toIndentedString(this.loyaltyProgramId)).append("\n");
        sb.append("    upgradeStrategy: ").append(this.toIndentedString((Object)this.upgradeStrategy)).append("\n");
        sb.append("    downgradeStrategy: ").append(this.toIndentedString((Object)this.downgradeStrategy)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTierOrder() != null) {
            for (int i = 0; i < this.getTierOrder().size(); ++i) {
                if (this.getTierOrder().get(i) == null) continue;
                try {
                    joiner.add(String.format("%stierOrder%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTierOrder().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLoyaltyProgramId() != null) {
            try {
                joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUpgradeStrategy() != null) {
            try {
                joiner.add(String.format("%supgradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getUpgradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDowngradeStrategy() != null) {
            try {
                joiner.add(String.format("%sdowngradeStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDowngradeStrategy()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCreatedAt() != null) {
            try {
                joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUpdatedAt() != null) {
            try {
                joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum UpgradeStrategyEnum {
        REAL_TIME(String.valueOf("real_time")),
        MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
        TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

        private String value;

        private UpgradeStrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UpgradeStrategyEnum fromValue(String value) {
            for (UpgradeStrategyEnum b : UpgradeStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DowngradeStrategyEnum {
        REAL_TIME(String.valueOf("real_time")),
        MEMBERSHIP_ANNIVERSARY(String.valueOf("membership_anniversary")),
        TIER_ANNIVERSARY(String.valueOf("tier_anniversary"));

        private String value;

        private DowngradeStrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DowngradeStrategyEnum fromValue(String value) {
            for (DowngradeStrategyEnum b : DowngradeStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

