/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"value", "unit", "types"})
public class TaskReminder {
    public static final String JSON_PROPERTY_VALUE = "value";
    @Nonnull
    private Integer value;
    public static final String JSON_PROPERTY_UNIT = "unit";
    @Nonnull
    private UnitEnum unit;
    public static final String JSON_PROPERTY_TYPES = "types";
    @Nonnull
    private List<TypesEnum> types = new ArrayList<TypesEnum>();

    public TaskReminder value(@Nonnull Integer value) {
        this.value = value;
        return this;
    }

    @Nonnull
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setValue(@Nonnull Integer value) {
        this.value = value;
    }

    public TaskReminder unit(@Nonnull UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @Nonnull
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UnitEnum getUnit() {
        return this.unit;
    }

    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUnit(@Nonnull UnitEnum unit) {
        this.unit = unit;
    }

    public TaskReminder types(@Nonnull List<TypesEnum> types) {
        this.types = types;
        return this;
    }

    public TaskReminder addTypesItem(TypesEnum typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<TypesEnum>();
        }
        this.types.add(typesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TypesEnum> getTypes() {
        return this.types;
    }

    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypes(@Nonnull List<TypesEnum> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskReminder taskReminder = (TaskReminder)o;
        return Objects.equals(this.value, taskReminder.value) && Objects.equals((Object)this.unit, (Object)taskReminder.unit) && Objects.equals(this.types, taskReminder.types);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.unit, this.types});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskReminder {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getValue() != null) {
            try {
                joiner.add(String.format("%svalue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getValue()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUnit() != null) {
            try {
                joiner.add(String.format("%sunit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getUnit()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTypes() != null) {
            for (int i = 0; i < this.getTypes().size(); ++i) {
                try {
                    joiner.add(String.format("%stypes%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getTypes().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum UnitEnum {
        MINUTES(String.valueOf("minutes")),
        HOURS(String.valueOf("hours")),
        WEEKS(String.valueOf("weeks")),
        DAYS(String.valueOf("days"));

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UnitEnum fromValue(String value) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypesEnum {
        EMAIL(String.valueOf("email")),
        PUSH(String.valueOf("push"));

        private String value;

        private TypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypesEnum fromValue(String value) {
            for (TypesEnum b : TypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

