/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.MemberContact;
import software.xdev.brevo.model.SubscriptionAttributedReward;
import software.xdev.brevo.model.SubscriptionBalances;
import software.xdev.brevo.model.SubscriptionTier;

@JsonPropertyOrder(value={"balance", "members", "reward", "tier"})
@JsonTypeName(value="subscriptionHandlerInfo")
public class SubscriptionHandlerInfo {
    public static final String JSON_PROPERTY_BALANCE = "balance";
    @Nullable
    private SubscriptionBalances balance;
    public static final String JSON_PROPERTY_MEMBERS = "members";
    @Nullable
    private List<MemberContact> members = new ArrayList<MemberContact>();
    public static final String JSON_PROPERTY_REWARD = "reward";
    @Nullable
    private List<SubscriptionAttributedReward> reward = new ArrayList<SubscriptionAttributedReward>();
    public static final String JSON_PROPERTY_TIER = "tier";
    @Nullable
    private List<SubscriptionTier> tier = new ArrayList<SubscriptionTier>();

    public SubscriptionHandlerInfo balance(@Nullable SubscriptionBalances balance) {
        this.balance = balance;
        return this;
    }

    @Nullable
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubscriptionBalances getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalance(@Nullable SubscriptionBalances balance) {
        this.balance = balance;
    }

    public SubscriptionHandlerInfo members(@Nullable List<MemberContact> members) {
        this.members = members;
        return this;
    }

    public SubscriptionHandlerInfo addMembersItem(MemberContact membersItem) {
        if (this.members == null) {
            this.members = new ArrayList<MemberContact>();
        }
        this.members.add(membersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MemberContact> getMembers() {
        return this.members;
    }

    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMembers(@Nullable List<MemberContact> members) {
        this.members = members;
    }

    public SubscriptionHandlerInfo reward(@Nullable List<SubscriptionAttributedReward> reward) {
        this.reward = reward;
        return this;
    }

    public SubscriptionHandlerInfo addRewardItem(SubscriptionAttributedReward rewardItem) {
        if (this.reward == null) {
            this.reward = new ArrayList<SubscriptionAttributedReward>();
        }
        this.reward.add(rewardItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reward")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubscriptionAttributedReward> getReward() {
        return this.reward;
    }

    @JsonProperty(value="reward")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReward(@Nullable List<SubscriptionAttributedReward> reward) {
        this.reward = reward;
    }

    public SubscriptionHandlerInfo tier(@Nullable List<SubscriptionTier> tier) {
        this.tier = tier;
        return this;
    }

    public SubscriptionHandlerInfo addTierItem(SubscriptionTier tierItem) {
        if (this.tier == null) {
            this.tier = new ArrayList<SubscriptionTier>();
        }
        this.tier.add(tierItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubscriptionTier> getTier() {
        return this.tier;
    }

    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTier(@Nullable List<SubscriptionTier> tier) {
        this.tier = tier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionHandlerInfo subscriptionHandlerInfo = (SubscriptionHandlerInfo)o;
        return Objects.equals(this.balance, subscriptionHandlerInfo.balance) && Objects.equals(this.members, subscriptionHandlerInfo.members) && Objects.equals(this.reward, subscriptionHandlerInfo.reward) && Objects.equals(this.tier, subscriptionHandlerInfo.tier);
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.members, this.reward, this.tier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionHandlerInfo {\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    reward: ").append(this.toIndentedString(this.reward)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString(this.tier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getBalance() != null) {
            joiner.add(this.getBalance().toUrlQueryString((String)prefix + JSON_PROPERTY_BALANCE + suffix));
        }
        if (this.getMembers() != null) {
            for (i = 0; i < this.getMembers().size(); ++i) {
                if (this.getMembers().get(i) == null) continue;
                joiner.add(this.getMembers().get(i).toUrlQueryString(String.format("%smembers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getReward() != null) {
            for (i = 0; i < this.getReward().size(); ++i) {
                if (this.getReward().get(i) == null) continue;
                joiner.add(this.getReward().get(i).toUrlQueryString(String.format("%sreward%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getTier() != null) {
            for (i = 0; i < this.getTier().size(); ++i) {
                if (this.getTier().get(i) == null) continue;
                joiner.add(this.getTier().get(i).toUrlQueryString(String.format("%stier%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

