/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"sender", "recipient", "content", "type", "tag", "webUrl", "unicodeEnabled", "organisationPrefix"})
@JsonTypeName(value="sendTransacSms")
public class SendTransacSms {
    public static final String JSON_PROPERTY_SENDER = "sender";
    @Nonnull
    private String sender;
    public static final String JSON_PROPERTY_RECIPIENT = "recipient";
    @Nonnull
    private String recipient;
    public static final String JSON_PROPERTY_CONTENT = "content";
    @Nonnull
    private String content;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private TypeEnum type = TypeEnum.TRANSACTIONAL;
    public static final String JSON_PROPERTY_TAG = "tag";
    @Nullable
    private String tag;
    public static final String JSON_PROPERTY_WEB_URL = "webUrl";
    @Nullable
    private String webUrl;
    public static final String JSON_PROPERTY_UNICODE_ENABLED = "unicodeEnabled";
    @Nullable
    private Boolean unicodeEnabled = false;
    public static final String JSON_PROPERTY_ORGANISATION_PREFIX = "organisationPrefix";
    @Nullable
    private String organisationPrefix;

    public SendTransacSms sender(@Nonnull String sender) {
        this.sender = sender;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSender() {
        return this.sender;
    }

    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSender(@Nonnull String sender) {
        this.sender = sender;
    }

    public SendTransacSms recipient(@Nonnull String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Nonnull
    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRecipient() {
        return this.recipient;
    }

    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipient(@Nonnull String recipient) {
        this.recipient = recipient;
    }

    public SendTransacSms content(@Nonnull String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContent(@Nonnull String content) {
        this.content = content;
    }

    public SendTransacSms type(@Nullable TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable TypeEnum type) {
        this.type = type;
    }

    public SendTransacSms tag(@Nullable String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTag(@Nullable String tag) {
        this.tag = tag;
    }

    public SendTransacSms webUrl(@Nullable String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="webUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebUrl() {
        return this.webUrl;
    }

    @JsonProperty(value="webUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebUrl(@Nullable String webUrl) {
        this.webUrl = webUrl;
    }

    public SendTransacSms unicodeEnabled(@Nullable Boolean unicodeEnabled) {
        this.unicodeEnabled = unicodeEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="unicodeEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUnicodeEnabled() {
        return this.unicodeEnabled;
    }

    @JsonProperty(value="unicodeEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnicodeEnabled(@Nullable Boolean unicodeEnabled) {
        this.unicodeEnabled = unicodeEnabled;
    }

    public SendTransacSms organisationPrefix(@Nullable String organisationPrefix) {
        this.organisationPrefix = organisationPrefix;
        return this;
    }

    @Nullable
    @JsonProperty(value="organisationPrefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrganisationPrefix() {
        return this.organisationPrefix;
    }

    @JsonProperty(value="organisationPrefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrganisationPrefix(@Nullable String organisationPrefix) {
        this.organisationPrefix = organisationPrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendTransacSms sendTransacSms = (SendTransacSms)o;
        return Objects.equals(this.sender, sendTransacSms.sender) && Objects.equals(this.recipient, sendTransacSms.recipient) && Objects.equals(this.content, sendTransacSms.content) && Objects.equals((Object)this.type, (Object)sendTransacSms.type) && Objects.equals(this.tag, sendTransacSms.tag) && Objects.equals(this.webUrl, sendTransacSms.webUrl) && Objects.equals(this.unicodeEnabled, sendTransacSms.unicodeEnabled) && Objects.equals(this.organisationPrefix, sendTransacSms.organisationPrefix);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sender, this.recipient, this.content, this.type, this.tag, this.webUrl, this.unicodeEnabled, this.organisationPrefix});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendTransacSms {\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    webUrl: ").append(this.toIndentedString(this.webUrl)).append("\n");
        sb.append("    unicodeEnabled: ").append(this.toIndentedString(this.unicodeEnabled)).append("\n");
        sb.append("    organisationPrefix: ").append(this.toIndentedString(this.organisationPrefix)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSender() != null) {
            try {
                joiner.add(String.format("%ssender%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSender()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRecipient() != null) {
            try {
                joiner.add(String.format("%srecipient%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRecipient()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getContent() != null) {
            try {
                joiner.add(String.format("%scontent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContent()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTag() != null) {
            try {
                joiner.add(String.format("%stag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTag()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getWebUrl() != null) {
            try {
                joiner.add(String.format("%swebUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getWebUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUnicodeEnabled() != null) {
            try {
                joiner.add(String.format("%sunicodeEnabled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUnicodeEnabled()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOrganisationPrefix() != null) {
            try {
                joiner.add(String.format("%sorganisationPrefix%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOrganisationPrefix()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        TRANSACTIONAL(String.valueOf("transactional")),
        MARKETING(String.valueOf("marketing"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

