/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.SendReportEmail;

@JsonPropertyOrder(value={"language", "email"})
@JsonTypeName(value="sendReport")
public class SendReport {
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    @Nullable
    private LanguageEnum language = LanguageEnum.FR;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nonnull
    private SendReportEmail email;

    public SendReport language(@Nullable LanguageEnum language) {
        this.language = language;
        return this;
    }

    @Nullable
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LanguageEnum getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(@Nullable LanguageEnum language) {
        this.language = language;
    }

    public SendReport email(@Nonnull SendReportEmail email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SendReportEmail getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(@Nonnull SendReportEmail email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendReport sendReport = (SendReport)o;
        return Objects.equals((Object)this.language, (Object)sendReport.language) && Objects.equals(this.email, sendReport.email);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.email});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendReport {\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLanguage() != null) {
            try {
                joiner.add(String.format("%slanguage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getLanguage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEmail() != null) {
            joiner.add(this.getEmail().toUrlQueryString((String)prefix + JSON_PROPERTY_EMAIL + suffix));
        }
        return joiner.toString();
    }

    public static enum LanguageEnum {
        FR(String.valueOf("fr")),
        ES(String.valueOf("es")),
        PT(String.valueOf("pt")),
        IT(String.valueOf("it")),
        DE(String.valueOf("de")),
        EN(String.valueOf("en"));

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            for (LanguageEnum b : LanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

