/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.PipelineStage;

@JsonPropertyOrder(value={"pipeline_name", "pipeline", "stages"})
public class Pipeline {
    public static final String JSON_PROPERTY_PIPELINE_NAME = "pipeline_name";
    @Nullable
    private String pipelineName;
    public static final String JSON_PROPERTY_PIPELINE = "pipeline";
    @Nullable
    private String pipeline;
    public static final String JSON_PROPERTY_STAGES = "stages";
    @Nullable
    private List<PipelineStage> stages = new ArrayList<PipelineStage>();

    public Pipeline pipelineName(@Nullable String pipelineName) {
        this.pipelineName = pipelineName;
        return this;
    }

    @Nullable
    @JsonProperty(value="pipeline_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPipelineName() {
        return this.pipelineName;
    }

    @JsonProperty(value="pipeline_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPipelineName(@Nullable String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public Pipeline pipeline(@Nullable String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Nullable
    @JsonProperty(value="pipeline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPipeline() {
        return this.pipeline;
    }

    @JsonProperty(value="pipeline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPipeline(@Nullable String pipeline) {
        this.pipeline = pipeline;
    }

    public Pipeline stages(@Nullable List<PipelineStage> stages) {
        this.stages = stages;
        return this;
    }

    public Pipeline addStagesItem(PipelineStage stagesItem) {
        if (this.stages == null) {
            this.stages = new ArrayList<PipelineStage>();
        }
        this.stages.add(stagesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="stages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PipelineStage> getStages() {
        return this.stages;
    }

    @JsonProperty(value="stages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStages(@Nullable List<PipelineStage> stages) {
        this.stages = stages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline pipeline = (Pipeline)o;
        return Objects.equals(this.pipelineName, pipeline.pipelineName) && Objects.equals(this.pipeline, pipeline.pipeline) && Objects.equals(this.stages, pipeline.stages);
    }

    public int hashCode() {
        return Objects.hash(this.pipelineName, this.pipeline, this.stages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pipeline {\n");
        sb.append("    pipelineName: ").append(this.toIndentedString(this.pipelineName)).append("\n");
        sb.append("    pipeline: ").append(this.toIndentedString(this.pipeline)).append("\n");
        sb.append("    stages: ").append(this.toIndentedString(this.stages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPipelineName() != null) {
            try {
                joiner.add(String.format("%spipeline_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPipelineName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPipeline() != null) {
            try {
                joiner.add(String.format("%spipeline%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPipeline()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStages() != null) {
            for (int i = 0; i < this.getStages().size(); ++i) {
                if (this.getStages().get(i) == null) continue;
                joiner.add(this.getStages().get(i).toUrlQueryString(String.format("%sstages%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

