/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.Order;

@JsonPropertyOrder(value={"orders", "notifyUrl", "historical"})
@JsonTypeName(value="orderBatch")
public class OrderBatch {
    public static final String JSON_PROPERTY_ORDERS = "orders";
    @Nonnull
    private List<Order> orders = new ArrayList<Order>();
    public static final String JSON_PROPERTY_NOTIFY_URL = "notifyUrl";
    @Nullable
    private String notifyUrl;
    public static final String JSON_PROPERTY_HISTORICAL = "historical";
    @Nullable
    private Boolean historical = true;

    public OrderBatch orders(@Nonnull List<Order> orders) {
        this.orders = orders;
        return this;
    }

    public OrderBatch addOrdersItem(Order ordersItem) {
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.orders.add(ordersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="orders")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Order> getOrders() {
        return this.orders;
    }

    @JsonProperty(value="orders")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrders(@Nonnull List<Order> orders) {
        this.orders = orders;
    }

    public OrderBatch notifyUrl(@Nullable String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="notifyUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    @JsonProperty(value="notifyUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyUrl(@Nullable String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public OrderBatch historical(@Nullable Boolean historical) {
        this.historical = historical;
        return this;
    }

    @Nullable
    @JsonProperty(value="historical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHistorical() {
        return this.historical;
    }

    @JsonProperty(value="historical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHistorical(@Nullable Boolean historical) {
        this.historical = historical;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderBatch orderBatch = (OrderBatch)o;
        return Objects.equals(this.orders, orderBatch.orders) && Objects.equals(this.notifyUrl, orderBatch.notifyUrl) && Objects.equals(this.historical, orderBatch.historical);
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.notifyUrl, this.historical);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderBatch {\n");
        sb.append("    orders: ").append(this.toIndentedString(this.orders)).append("\n");
        sb.append("    notifyUrl: ").append(this.toIndentedString(this.notifyUrl)).append("\n");
        sb.append("    historical: ").append(this.toIndentedString(this.historical)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOrders() != null) {
            for (int i = 0; i < this.getOrders().size(); ++i) {
                if (this.getOrders().get(i) == null) continue;
                joiner.add(this.getOrders().get(i).toUrlQueryString(String.format("%sorders%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getNotifyUrl() != null) {
            try {
                joiner.add(String.format("%snotifyUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNotifyUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getHistorical() != null) {
            try {
                joiner.add(String.format("%shistorical%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getHistorical()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

