/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.OrderBilling;
import software.xdev.brevo.model.OrderIdentifiers;
import software.xdev.brevo.model.OrderMetaInfoValue;
import software.xdev.brevo.model.OrderProductsInner;

@JsonPropertyOrder(value={"id", "createdAt", "updatedAt", "status", "amount", "storeId", "identifiers", "products", "billing", "coupons", "metaInfo"})
@JsonTypeName(value="order")
public class Order {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    @Nonnull
    private String createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nonnull
    private String updatedAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private String status;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    @Nonnull
    private BigDecimal amount;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    @Nullable
    private String storeId;
    public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
    @Nullable
    private OrderIdentifiers identifiers;
    public static final String JSON_PROPERTY_PRODUCTS = "products";
    @Nonnull
    private List<OrderProductsInner> products = new ArrayList<OrderProductsInner>();
    public static final String JSON_PROPERTY_BILLING = "billing";
    @Nullable
    private OrderBilling billing;
    public static final String JSON_PROPERTY_COUPONS = "coupons";
    @Nullable
    private List<String> coupons = new ArrayList<String>();
    public static final String JSON_PROPERTY_META_INFO = "metaInfo";
    @Nullable
    private Map<String, OrderMetaInfoValue> metaInfo = new HashMap<String, OrderMetaInfoValue>();

    public Order id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Order createdAt(@Nonnull String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(@Nonnull String createdAt) {
        this.createdAt = createdAt;
    }

    public Order updatedAt(@Nonnull String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUpdatedAt(@Nonnull String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Order status(@Nonnull String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull String status) {
        this.status = status;
    }

    public Order amount(@Nonnull BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(@Nonnull BigDecimal amount) {
        this.amount = amount;
    }

    public Order storeId(@Nullable String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(@Nullable String storeId) {
        this.storeId = storeId;
    }

    public Order identifiers(@Nullable OrderIdentifiers identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    @Nullable
    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrderIdentifiers getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifiers(@Nullable OrderIdentifiers identifiers) {
        this.identifiers = identifiers;
    }

    public Order products(@Nonnull List<OrderProductsInner> products) {
        this.products = products;
        return this;
    }

    public Order addProductsItem(OrderProductsInner productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<OrderProductsInner>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="products")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OrderProductsInner> getProducts() {
        return this.products;
    }

    @JsonProperty(value="products")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProducts(@Nonnull List<OrderProductsInner> products) {
        this.products = products;
    }

    public Order billing(@Nullable OrderBilling billing) {
        this.billing = billing;
        return this;
    }

    @Nullable
    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrderBilling getBilling() {
        return this.billing;
    }

    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBilling(@Nullable OrderBilling billing) {
        this.billing = billing;
    }

    public Order coupons(@Nullable List<String> coupons) {
        this.coupons = coupons;
        return this;
    }

    public Order addCouponsItem(String couponsItem) {
        if (this.coupons == null) {
            this.coupons = new ArrayList<String>();
        }
        this.coupons.add(couponsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="coupons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCoupons() {
        return this.coupons;
    }

    @JsonProperty(value="coupons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoupons(@Nullable List<String> coupons) {
        this.coupons = coupons;
    }

    public Order metaInfo(@Nullable Map<String, OrderMetaInfoValue> metaInfo) {
        this.metaInfo = metaInfo;
        return this;
    }

    public Order putMetaInfoItem(String key, OrderMetaInfoValue metaInfoItem) {
        if (this.metaInfo == null) {
            this.metaInfo = new HashMap<String, OrderMetaInfoValue>();
        }
        this.metaInfo.put(key, metaInfoItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metaInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, OrderMetaInfoValue> getMetaInfo() {
        return this.metaInfo;
    }

    @JsonProperty(value="metaInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetaInfo(@Nullable Map<String, OrderMetaInfoValue> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.id, order.id) && Objects.equals(this.createdAt, order.createdAt) && Objects.equals(this.updatedAt, order.updatedAt) && Objects.equals(this.status, order.status) && Objects.equals(this.amount, order.amount) && Objects.equals(this.storeId, order.storeId) && Objects.equals(this.identifiers, order.identifiers) && Objects.equals(this.products, order.products) && Objects.equals(this.billing, order.billing) && Objects.equals(this.coupons, order.coupons) && Objects.equals(this.metaInfo, order.metaInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.status, this.amount, this.storeId, this.identifiers, this.products, this.billing, this.coupons, this.metaInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Order {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifiers)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    billing: ").append(this.toIndentedString(this.billing)).append("\n");
        sb.append("    coupons: ").append(this.toIndentedString(this.coupons)).append("\n");
        sb.append("    metaInfo: ").append(this.toIndentedString(this.metaInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCreatedAt() != null) {
            try {
                joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUpdatedAt() != null) {
            try {
                joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStatus() != null) {
            try {
                joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatus()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAmount() != null) {
            try {
                joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStoreId() != null) {
            try {
                joiner.add(String.format("%sstoreId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStoreId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIdentifiers() != null) {
            joiner.add(this.getIdentifiers().toUrlQueryString((String)prefix + JSON_PROPERTY_IDENTIFIERS + suffix));
        }
        if (this.getProducts() != null) {
            for (i = 0; i < this.getProducts().size(); ++i) {
                if (this.getProducts().get(i) == null) continue;
                joiner.add(this.getProducts().get(i).toUrlQueryString(String.format("%sproducts%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getBilling() != null) {
            joiner.add(this.getBilling().toUrlQueryString((String)prefix + JSON_PROPERTY_BILLING + suffix));
        }
        if (this.getCoupons() != null) {
            for (i = 0; i < this.getCoupons().size(); ++i) {
                try {
                    joiner.add(String.format("%scoupons%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCoupons().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getMetaInfo() != null) {
            for (String _key : this.getMetaInfo().keySet()) {
                if (this.getMetaInfo().get(_key) == null) continue;
                joiner.add(this.getMetaInfo().get(_key).toUrlQueryString(String.format("%smetaInfo%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

