/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"text", "contactIds", "dealIds", "companyIds"})
public class NoteData {
    public static final String JSON_PROPERTY_TEXT = "text";
    @Nonnull
    private String text;
    public static final String JSON_PROPERTY_CONTACT_IDS = "contactIds";
    @Nullable
    private List<Integer> contactIds = new ArrayList<Integer>();
    public static final String JSON_PROPERTY_DEAL_IDS = "dealIds";
    @Nullable
    private List<String> dealIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_COMPANY_IDS = "companyIds";
    @Nullable
    private List<String> companyIds = new ArrayList<String>();

    public NoteData text(@Nonnull String text) {
        this.text = text;
        return this;
    }

    @Nonnull
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setText(@Nonnull String text) {
        this.text = text;
    }

    public NoteData contactIds(@Nullable List<Integer> contactIds) {
        this.contactIds = contactIds;
        return this;
    }

    public NoteData addContactIdsItem(Integer contactIdsItem) {
        if (this.contactIds == null) {
            this.contactIds = new ArrayList<Integer>();
        }
        this.contactIds.add(contactIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="contactIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getContactIds() {
        return this.contactIds;
    }

    @JsonProperty(value="contactIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactIds(@Nullable List<Integer> contactIds) {
        this.contactIds = contactIds;
    }

    public NoteData dealIds(@Nullable List<String> dealIds) {
        this.dealIds = dealIds;
        return this;
    }

    public NoteData addDealIdsItem(String dealIdsItem) {
        if (this.dealIds == null) {
            this.dealIds = new ArrayList<String>();
        }
        this.dealIds.add(dealIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dealIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDealIds() {
        return this.dealIds;
    }

    @JsonProperty(value="dealIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDealIds(@Nullable List<String> dealIds) {
        this.dealIds = dealIds;
    }

    public NoteData companyIds(@Nullable List<String> companyIds) {
        this.companyIds = companyIds;
        return this;
    }

    public NoteData addCompanyIdsItem(String companyIdsItem) {
        if (this.companyIds == null) {
            this.companyIds = new ArrayList<String>();
        }
        this.companyIds.add(companyIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="companyIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCompanyIds() {
        return this.companyIds;
    }

    @JsonProperty(value="companyIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyIds(@Nullable List<String> companyIds) {
        this.companyIds = companyIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteData noteData = (NoteData)o;
        return Objects.equals(this.text, noteData.text) && Objects.equals(this.contactIds, noteData.contactIds) && Objects.equals(this.dealIds, noteData.dealIds) && Objects.equals(this.companyIds, noteData.companyIds);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.contactIds, this.dealIds, this.companyIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NoteData {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    contactIds: ").append(this.toIndentedString(this.contactIds)).append("\n");
        sb.append("    dealIds: ").append(this.toIndentedString(this.dealIds)).append("\n");
        sb.append("    companyIds: ").append(this.toIndentedString(this.companyIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getText() != null) {
            try {
                joiner.add(String.format("%stext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getText()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getContactIds() != null) {
            for (i = 0; i < this.getContactIds().size(); ++i) {
                try {
                    joiner.add(String.format("%scontactIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getContactIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getDealIds() != null) {
            for (i = 0; i < this.getDealIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sdealIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getDealIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCompanyIds() != null) {
            for (i = 0; i < this.getCompanyIds().size(); ++i) {
                try {
                    joiner.add(String.format("%scompanyIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCompanyIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

