/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "text", "contactIds", "dealIds", "authorId", "createdAt", "updatedAt"})
public class Note {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_TEXT = "text";
    @Nonnull
    private String text;
    public static final String JSON_PROPERTY_CONTACT_IDS = "contactIds";
    @Nullable
    private List<Integer> contactIds = new ArrayList<Integer>();
    public static final String JSON_PROPERTY_DEAL_IDS = "dealIds";
    @Nullable
    private List<String> dealIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_AUTHOR_ID = "authorId";
    @Nullable
    private Object authorId;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    @Nullable
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private OffsetDateTime updatedAt;

    public Note id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public Note text(@Nonnull String text) {
        this.text = text;
        return this;
    }

    @Nonnull
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setText(@Nonnull String text) {
        this.text = text;
    }

    public Note contactIds(@Nullable List<Integer> contactIds) {
        this.contactIds = contactIds;
        return this;
    }

    public Note addContactIdsItem(Integer contactIdsItem) {
        if (this.contactIds == null) {
            this.contactIds = new ArrayList<Integer>();
        }
        this.contactIds.add(contactIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="contactIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Integer> getContactIds() {
        return this.contactIds;
    }

    @JsonProperty(value="contactIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactIds(@Nullable List<Integer> contactIds) {
        this.contactIds = contactIds;
    }

    public Note dealIds(@Nullable List<String> dealIds) {
        this.dealIds = dealIds;
        return this;
    }

    public Note addDealIdsItem(String dealIdsItem) {
        if (this.dealIds == null) {
            this.dealIds = new ArrayList<String>();
        }
        this.dealIds.add(dealIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dealIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDealIds() {
        return this.dealIds;
    }

    @JsonProperty(value="dealIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDealIds(@Nullable List<String> dealIds) {
        this.dealIds = dealIds;
    }

    public Note authorId(@Nullable Object authorId) {
        this.authorId = authorId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAuthorId() {
        return this.authorId;
    }

    @JsonProperty(value="authorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorId(@Nullable Object authorId) {
        this.authorId = authorId;
    }

    public Note createdAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Note updatedAt(@Nullable OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return Objects.equals(this.id, note.id) && Objects.equals(this.text, note.text) && Objects.equals(this.contactIds, note.contactIds) && Objects.equals(this.dealIds, note.dealIds) && Objects.equals(this.authorId, note.authorId) && Objects.equals(this.createdAt, note.createdAt) && Objects.equals(this.updatedAt, note.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text, this.contactIds, this.dealIds, this.authorId, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Note {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    contactIds: ").append(this.toIndentedString(this.contactIds)).append("\n");
        sb.append("    dealIds: ").append(this.toIndentedString(this.dealIds)).append("\n");
        sb.append("    authorId: ").append(this.toIndentedString(this.authorId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getText() != null) {
            try {
                joiner.add(String.format("%stext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getText()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getContactIds() != null) {
            for (i = 0; i < this.getContactIds().size(); ++i) {
                try {
                    joiner.add(String.format("%scontactIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getContactIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getDealIds() != null) {
            for (i = 0; i < this.getDealIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sdealIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getDealIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getAuthorId() != null) {
            try {
                joiner.add(String.format("%sauthorId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthorId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCreatedAt() != null) {
            try {
                joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUpdatedAt() != null) {
            try {
                joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

