/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"category", "price", "productId", "quantity", "variantId"})
@JsonTypeName(value="main.productPayload")
public class MainProductPayload {
    public static final String JSON_PROPERTY_CATEGORY = "category";
    @Nullable
    private List<String> category = new ArrayList<String>();
    public static final String JSON_PROPERTY_PRICE = "price";
    @Nullable
    private BigDecimal price;
    public static final String JSON_PROPERTY_PRODUCT_ID = "productId";
    @Nullable
    private String productId;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    @Nullable
    private BigDecimal quantity;
    public static final String JSON_PROPERTY_VARIANT_ID = "variantId";
    @Nullable
    private String variantId;

    public MainProductPayload category(@Nullable List<String> category) {
        this.category = category;
        return this;
    }

    public MainProductPayload addCategoryItem(String categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<String>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(@Nullable List<String> category) {
        this.category = category;
    }

    public MainProductPayload price(@Nullable BigDecimal price) {
        this.price = price;
        return this;
    }

    @Nullable
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(@Nullable BigDecimal price) {
        this.price = price;
    }

    public MainProductPayload productId(@Nullable String productId) {
        this.productId = productId;
        return this;
    }

    @Nullable
    @JsonProperty(value="productId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductId() {
        return this.productId;
    }

    @JsonProperty(value="productId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductId(@Nullable String productId) {
        this.productId = productId;
    }

    public MainProductPayload quantity(@Nullable BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(@Nullable BigDecimal quantity) {
        this.quantity = quantity;
    }

    public MainProductPayload variantId(@Nullable String variantId) {
        this.variantId = variantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="variantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVariantId() {
        return this.variantId;
    }

    @JsonProperty(value="variantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariantId(@Nullable String variantId) {
        this.variantId = variantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainProductPayload mainProductPayload = (MainProductPayload)o;
        return Objects.equals(this.category, mainProductPayload.category) && Objects.equals(this.price, mainProductPayload.price) && Objects.equals(this.productId, mainProductPayload.productId) && Objects.equals(this.quantity, mainProductPayload.quantity) && Objects.equals(this.variantId, mainProductPayload.variantId);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.price, this.productId, this.quantity, this.variantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MainProductPayload {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    variantId: ").append(this.toIndentedString(this.variantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCategory() != null) {
            for (int i = 0; i < this.getCategory().size(); ++i) {
                try {
                    joiner.add(String.format("%scategory%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCategory().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getPrice() != null) {
            try {
                joiner.add(String.format("%sprice%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrice()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProductId() != null) {
            try {
                joiner.add(String.format("%sproductId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProductId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getQuantity() != null) {
            try {
                joiner.add(String.format("%squantity%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getQuantity()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVariantId() != null) {
            try {
                joiner.add(String.format("%svariantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVariantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

