/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.MainBillingPayload;
import software.xdev.brevo.model.MainIdentifiersPayload;
import software.xdev.brevo.model.MainProductPayload;

@JsonPropertyOrder(value={"amount", "billing", "contact_id", "coupons", "createdAt", "email", "id", "identifiers", "products", "status", "storeId", "updatedAt"})
@JsonTypeName(value="main.orderPayload")
public class MainOrderPayload {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    @Nullable
    private BigDecimal amount;
    public static final String JSON_PROPERTY_BILLING = "billing";
    @Nullable
    private MainBillingPayload billing;
    public static final String JSON_PROPERTY_CONTACT_ID = "contact_id";
    @Nullable
    private Long contactId;
    public static final String JSON_PROPERTY_COUPONS = "coupons";
    @Nullable
    private List<String> coupons = new ArrayList<String>();
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    @Nullable
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nullable
    private String email;
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
    @Nullable
    private MainIdentifiersPayload identifiers;
    public static final String JSON_PROPERTY_PRODUCTS = "products";
    @Nullable
    private List<MainProductPayload> products = new ArrayList<MainProductPayload>();
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nullable
    private String status;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    @Nullable
    private String storeId;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private OffsetDateTime updatedAt;

    public MainOrderPayload amount(@Nullable BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(@Nullable BigDecimal amount) {
        this.amount = amount;
    }

    public MainOrderPayload billing(@Nullable MainBillingPayload billing) {
        this.billing = billing;
        return this;
    }

    @Nullable
    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MainBillingPayload getBilling() {
        return this.billing;
    }

    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBilling(@Nullable MainBillingPayload billing) {
        this.billing = billing;
    }

    public MainOrderPayload contactId(@Nullable Long contactId) {
        this.contactId = contactId;
        return this;
    }

    @Nullable
    @JsonProperty(value="contact_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="contact_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactId(@Nullable Long contactId) {
        this.contactId = contactId;
    }

    public MainOrderPayload coupons(@Nullable List<String> coupons) {
        this.coupons = coupons;
        return this;
    }

    public MainOrderPayload addCouponsItem(String couponsItem) {
        if (this.coupons == null) {
            this.coupons = new ArrayList<String>();
        }
        this.coupons.add(couponsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="coupons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCoupons() {
        return this.coupons;
    }

    @JsonProperty(value="coupons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoupons(@Nullable List<String> coupons) {
        this.coupons = coupons;
    }

    public MainOrderPayload createdAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public MainOrderPayload email(@Nullable String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    public MainOrderPayload id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public MainOrderPayload identifiers(@Nullable MainIdentifiersPayload identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    @Nullable
    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MainIdentifiersPayload getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifiers(@Nullable MainIdentifiersPayload identifiers) {
        this.identifiers = identifiers;
    }

    public MainOrderPayload products(@Nullable List<MainProductPayload> products) {
        this.products = products;
        return this;
    }

    public MainOrderPayload addProductsItem(MainProductPayload productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<MainProductPayload>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="products")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MainProductPayload> getProducts() {
        return this.products;
    }

    @JsonProperty(value="products")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProducts(@Nullable List<MainProductPayload> products) {
        this.products = products;
    }

    public MainOrderPayload status(@Nullable String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(@Nullable String status) {
        this.status = status;
    }

    public MainOrderPayload storeId(@Nullable String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(@Nullable String storeId) {
        this.storeId = storeId;
    }

    public MainOrderPayload updatedAt(@Nullable OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainOrderPayload mainOrderPayload = (MainOrderPayload)o;
        return Objects.equals(this.amount, mainOrderPayload.amount) && Objects.equals(this.billing, mainOrderPayload.billing) && Objects.equals(this.contactId, mainOrderPayload.contactId) && Objects.equals(this.coupons, mainOrderPayload.coupons) && Objects.equals(this.createdAt, mainOrderPayload.createdAt) && Objects.equals(this.email, mainOrderPayload.email) && Objects.equals(this.id, mainOrderPayload.id) && Objects.equals(this.identifiers, mainOrderPayload.identifiers) && Objects.equals(this.products, mainOrderPayload.products) && Objects.equals(this.status, mainOrderPayload.status) && Objects.equals(this.storeId, mainOrderPayload.storeId) && Objects.equals(this.updatedAt, mainOrderPayload.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.billing, this.contactId, this.coupons, this.createdAt, this.email, this.id, this.identifiers, this.products, this.status, this.storeId, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MainOrderPayload {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billing: ").append(this.toIndentedString(this.billing)).append("\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    coupons: ").append(this.toIndentedString(this.coupons)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifiers)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            try {
                joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBilling() != null) {
            joiner.add(this.getBilling().toUrlQueryString((String)prefix + JSON_PROPERTY_BILLING + suffix));
        }
        if (this.getContactId() != null) {
            try {
                joiner.add(String.format("%scontact_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContactId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCoupons() != null) {
            for (i = 0; i < this.getCoupons().size(); ++i) {
                try {
                    joiner.add(String.format("%scoupons%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCoupons().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCreatedAt() != null) {
            try {
                joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEmail() != null) {
            try {
                joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIdentifiers() != null) {
            joiner.add(this.getIdentifiers().toUrlQueryString((String)prefix + JSON_PROPERTY_IDENTIFIERS + suffix));
        }
        if (this.getProducts() != null) {
            for (i = 0; i < this.getProducts().size(); ++i) {
                if (this.getProducts().get(i) == null) continue;
                joiner.add(this.getProducts().get(i).toUrlQueryString(String.format("%sproducts%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getStatus() != null) {
            try {
                joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatus()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStoreId() != null) {
            try {
                joiner.add(String.format("%sstoreId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStoreId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUpdatedAt() != null) {
            try {
                joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

