/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"address", "city", "countryCode", "paymentMethod", "phone", "postCode", "region"})
@JsonTypeName(value="main.billingPayload")
public class MainBillingPayload {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nullable
    private String address;
    public static final String JSON_PROPERTY_CITY = "city";
    @Nullable
    private String city;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    @Nullable
    private String countryCode;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    @Nullable
    private String paymentMethod;
    public static final String JSON_PROPERTY_PHONE = "phone";
    @Nullable
    private Long phone;
    public static final String JSON_PROPERTY_POST_CODE = "postCode";
    @Nullable
    private Long postCode;
    public static final String JSON_PROPERTY_REGION = "region";
    @Nullable
    private String region;

    public MainBillingPayload address(@Nullable String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(@Nullable String address) {
        this.address = address;
    }

    public MainBillingPayload city(@Nullable String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(@Nullable String city) {
        this.city = city;
    }

    public MainBillingPayload countryCode(@Nullable String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(@Nullable String countryCode) {
        this.countryCode = countryCode;
    }

    public MainBillingPayload paymentMethod(@Nullable String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Nullable
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(@Nullable String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public MainBillingPayload phone(@Nullable Long phone) {
        this.phone = phone;
        return this;
    }

    @Nullable
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhone(@Nullable Long phone) {
        this.phone = phone;
    }

    public MainBillingPayload postCode(@Nullable Long postCode) {
        this.postCode = postCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="postCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPostCode() {
        return this.postCode;
    }

    @JsonProperty(value="postCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostCode(@Nullable Long postCode) {
        this.postCode = postCode;
    }

    public MainBillingPayload region(@Nullable String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegion(@Nullable String region) {
        this.region = region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainBillingPayload mainBillingPayload = (MainBillingPayload)o;
        return Objects.equals(this.address, mainBillingPayload.address) && Objects.equals(this.city, mainBillingPayload.city) && Objects.equals(this.countryCode, mainBillingPayload.countryCode) && Objects.equals(this.paymentMethod, mainBillingPayload.paymentMethod) && Objects.equals(this.phone, mainBillingPayload.phone) && Objects.equals(this.postCode, mainBillingPayload.postCode) && Objects.equals(this.region, mainBillingPayload.region);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.city, this.countryCode, this.paymentMethod, this.phone, this.postCode, this.region);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MainBillingPayload {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    postCode: ").append(this.toIndentedString(this.postCode)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAddress() != null) {
            try {
                joiner.add(String.format("%saddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAddress()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCity() != null) {
            try {
                joiner.add(String.format("%scity%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCity()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCountryCode() != null) {
            try {
                joiner.add(String.format("%scountryCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCountryCode()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPaymentMethod() != null) {
            try {
                joiner.add(String.format("%spaymentMethod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPaymentMethod()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPhone() != null) {
            try {
                joiner.add(String.format("%sphone%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPhone()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPostCode() != null) {
            try {
                joiner.add(String.format("%spostCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPostCode()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRegion() != null) {
            try {
                joiner.add(String.format("%sregion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRegion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

