/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"feature", "permissions"})
@JsonTypeName(value="inviteuser_privileges_inner")
public class InviteuserPrivilegesInner {
    public static final String JSON_PROPERTY_FEATURE = "feature";
    @Nullable
    private FeatureEnum feature;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    @Nullable
    private List<PermissionsEnum> permissions = new ArrayList<PermissionsEnum>();

    public InviteuserPrivilegesInner feature(@Nullable FeatureEnum feature) {
        this.feature = feature;
        return this;
    }

    @Nullable
    @JsonProperty(value="feature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FeatureEnum getFeature() {
        return this.feature;
    }

    @JsonProperty(value="feature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeature(@Nullable FeatureEnum feature) {
        this.feature = feature;
    }

    public InviteuserPrivilegesInner permissions(@Nullable List<PermissionsEnum> permissions) {
        this.permissions = permissions;
        return this;
    }

    public InviteuserPrivilegesInner addPermissionsItem(PermissionsEnum permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionsEnum>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PermissionsEnum> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(@Nullable List<PermissionsEnum> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InviteuserPrivilegesInner inviteuserPrivilegesInner = (InviteuserPrivilegesInner)o;
        return Objects.equals((Object)this.feature, (Object)inviteuserPrivilegesInner.feature) && Objects.equals(this.permissions, inviteuserPrivilegesInner.permissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feature, this.permissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InviteuserPrivilegesInner {\n");
        sb.append("    feature: ").append(this.toIndentedString((Object)this.feature)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getFeature() != null) {
            try {
                joiner.add(String.format("%sfeature%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getFeature()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPermissions() != null) {
            for (int i = 0; i < this.getPermissions().size(); ++i) {
                try {
                    joiner.add(String.format("%spermissions%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getPermissions().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum FeatureEnum {
        EMAIL_CAMPAIGNS(String.valueOf("email_campaigns")),
        SMS_CAMPAIGNS(String.valueOf("sms_campaigns")),
        CONTACTS(String.valueOf("contacts")),
        TEMPLATES(String.valueOf("templates")),
        WORKFLOWS(String.valueOf("workflows")),
        LANDING_PAGES(String.valueOf("landing_pages")),
        TRANSACTIONAL_EMAILS(String.valueOf("transactional_emails")),
        SMTP_API(String.valueOf("smtp_api")),
        USER_MANAGEMENT(String.valueOf("user_management")),
        SALES_PLATFORM(String.valueOf("sales_platform")),
        PHONE(String.valueOf("phone")),
        CONVERSATIONS(String.valueOf("conversations")),
        SENDERS_DOMAINS_DEDICATED_IPS(String.valueOf("senders_domains_dedicated_ips")),
        PUSH_NOTIFICATIONS(String.valueOf("push_notifications")),
        COMPANIES(String.valueOf("companies"));

        private String value;

        private FeatureEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeatureEnum fromValue(String value) {
            for (FeatureEnum b : FeatureEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PermissionsEnum {
        CREATE_EDIT_DELETE(String.valueOf("create_edit_delete")),
        SEND_SCHEDULE_SUSPEND(String.valueOf("send_schedule_suspend")),
        VIEW(String.valueOf("view")),
        IMPORT(String.valueOf("import")),
        EXPORT(String.valueOf("export")),
        LIST_AND_ATTRIBUTES(String.valueOf("list_and_attributes")),
        FORMS(String.valueOf("forms")),
        ACTIVATE_DEACTIVATE(String.valueOf("activate_deactivate")),
        ACTIVATE_DEACTIVATE_PAUSE(String.valueOf("activate_deactivate_pause")),
        SETTINGS(String.valueOf("settings")),
        SCHEDULE_PAUSE(String.valueOf("schedule_pause")),
        ALL(String.valueOf("all")),
        LOGS(String.valueOf("logs")),
        ACCESS(String.valueOf("access")),
        ASSIGN(String.valueOf("assign")),
        CONFIGURE(String.valueOf("configure")),
        CREATE_EDIT_DEALS(String.valueOf("create_edit_deals")),
        DELETE_DEALS(String.valueOf("delete_deals")),
        MANAGE_OTHERS_DEALS_TASKS(String.valueOf("manage_others_deals_tasks")),
        MANAGE_OWNED_COMPANIES(String.valueOf("manage_owned_companies")),
        MANAGE_OTHERS_COMPANIES(String.valueOf("manage_others_companies")),
        REPORTS(String.valueOf("reports")),
        SENDERS_MANAGEMENT(String.valueOf("senders_management")),
        DOMAINS_MANAGEMENT(String.valueOf("domains_management")),
        DEDICATED_IPS_MANAGEMENT(String.valueOf("dedicated_ips_management")),
        SEND(String.valueOf("send")),
        SMTP(String.valueOf("smtp")),
        API_KEYS(String.valueOf("api_keys")),
        AUTHORIZED_IPS(String.valueOf("authorized_ips")),
        NONE(String.valueOf("none"));

        private String value;

        private PermissionsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionsEnum fromValue(String value) {
            for (PermissionsEnum b : PermissionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

