/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"feature", "permissions"})
@JsonTypeName(value="inviteAdminUser_privileges_inner")
public class InviteAdminUserPrivilegesInner {
    public static final String JSON_PROPERTY_FEATURE = "feature";
    @Nullable
    private FeatureEnum feature;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    @Nullable
    private List<PermissionsEnum> permissions = new ArrayList<PermissionsEnum>();

    public InviteAdminUserPrivilegesInner feature(@Nullable FeatureEnum feature) {
        this.feature = feature;
        return this;
    }

    @Nullable
    @JsonProperty(value="feature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FeatureEnum getFeature() {
        return this.feature;
    }

    @JsonProperty(value="feature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeature(@Nullable FeatureEnum feature) {
        this.feature = feature;
    }

    public InviteAdminUserPrivilegesInner permissions(@Nullable List<PermissionsEnum> permissions) {
        this.permissions = permissions;
        return this;
    }

    public InviteAdminUserPrivilegesInner addPermissionsItem(PermissionsEnum permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionsEnum>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PermissionsEnum> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(@Nullable List<PermissionsEnum> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InviteAdminUserPrivilegesInner inviteAdminUserPrivilegesInner = (InviteAdminUserPrivilegesInner)o;
        return Objects.equals((Object)this.feature, (Object)inviteAdminUserPrivilegesInner.feature) && Objects.equals(this.permissions, inviteAdminUserPrivilegesInner.permissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feature, this.permissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InviteAdminUserPrivilegesInner {\n");
        sb.append("    feature: ").append(this.toIndentedString((Object)this.feature)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getFeature() != null) {
            try {
                joiner.add(String.format("%sfeature%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getFeature()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPermissions() != null) {
            for (int i = 0; i < this.getPermissions().size(); ++i) {
                try {
                    joiner.add(String.format("%spermissions%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getPermissions().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum FeatureEnum {
        MY_PLAN(String.valueOf("my_plan")),
        API(String.valueOf("api")),
        USER_MANAGEMENT(String.valueOf("user_management")),
        APP_MANAGEMENT(String.valueOf("app_management")),
        SUB_ORGANIZATION_GROUPS(String.valueOf("sub_organization_groups")),
        CREATE_SUB_ORGANIZATIONS(String.valueOf("create_sub_organizations")),
        MANAGE_SUB_ORGANIZATIONS(String.valueOf("manage_sub_organizations")),
        ANALYTICS(String.valueOf("analytics")),
        SECURITY(String.valueOf("security"));

        private String value;

        private FeatureEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeatureEnum fromValue(String value) {
            for (FeatureEnum b : FeatureEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PermissionsEnum {
        ALL(String.valueOf("all")),
        NONE(String.valueOf("none")),
        CREATE(String.valueOf("create")),
        EDIT_DELETE(String.valueOf("edit_delete")),
        DOWNLOAD_DATA(String.valueOf("download_data")),
        CREATE_ALERTS(String.valueOf("create_alerts"));

        private String value;

        private PermissionsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionsEnum fromValue(String value) {
            for (PermissionsEnum b : PermissionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

