/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"url", "id", "description", "events", "type", "channel", "createdAt", "modifiedAt", "batched", "auth", "headers"})
@JsonTypeName(value="getWebhook")
public class GetWebhook {
    public static final String JSON_PROPERTY_URL = "url";
    @Nonnull
    private String url;
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private Long id;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_EVENTS = "events";
    @Nonnull
    private List<String> events = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_CHANNEL = "channel";
    @Nullable
    private ChannelEnum channel = ChannelEnum.EMAIL;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    @Nonnull
    private String createdAt;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modifiedAt";
    @Nonnull
    private String modifiedAt;
    public static final String JSON_PROPERTY_BATCHED = "batched";
    @Nullable
    private Boolean batched;
    public static final String JSON_PROPERTY_AUTH = "auth";
    @Nullable
    private Object auth;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    @Nullable
    private List<Object> headers = new ArrayList<Object>();

    public GetWebhook url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    public GetWebhook id(@Nonnull Long id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull Long id) {
        this.id = id;
    }

    public GetWebhook description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public GetWebhook events(@Nonnull List<String> events) {
        this.events = events;
        return this;
    }

    public GetWebhook addEventsItem(String eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEvents(@Nonnull List<String> events) {
        this.events = events;
    }

    public GetWebhook type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public GetWebhook channel(@Nullable ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @Nullable
    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelEnum getChannel() {
        return this.channel;
    }

    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannel(@Nullable ChannelEnum channel) {
        this.channel = channel;
    }

    public GetWebhook createdAt(@Nonnull String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(@Nonnull String createdAt) {
        this.createdAt = createdAt;
    }

    public GetWebhook modifiedAt(@Nonnull String modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="modifiedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="modifiedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setModifiedAt(@Nonnull String modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public GetWebhook batched(@Nullable Boolean batched) {
        this.batched = batched;
        return this;
    }

    @Nullable
    @JsonProperty(value="batched")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBatched() {
        return this.batched;
    }

    @JsonProperty(value="batched")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBatched(@Nullable Boolean batched) {
        this.batched = batched;
    }

    public GetWebhook auth(@Nullable Object auth) {
        this.auth = auth;
        return this;
    }

    @Nullable
    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAuth() {
        return this.auth;
    }

    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuth(@Nullable Object auth) {
        this.auth = auth;
    }

    public GetWebhook headers(@Nullable List<Object> headers) {
        this.headers = headers;
        return this;
    }

    public GetWebhook addHeadersItem(Object headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<Object>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(@Nullable List<Object> headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWebhook getWebhook = (GetWebhook)o;
        return Objects.equals(this.url, getWebhook.url) && Objects.equals(this.id, getWebhook.id) && Objects.equals(this.description, getWebhook.description) && Objects.equals(this.events, getWebhook.events) && Objects.equals((Object)this.type, (Object)getWebhook.type) && Objects.equals((Object)this.channel, (Object)getWebhook.channel) && Objects.equals(this.createdAt, getWebhook.createdAt) && Objects.equals(this.modifiedAt, getWebhook.modifiedAt) && Objects.equals(this.batched, getWebhook.batched) && Objects.equals(this.auth, getWebhook.auth) && Objects.equals(this.headers, getWebhook.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.id, this.description, this.events, this.type, this.channel, this.createdAt, this.modifiedAt, this.batched, this.auth, this.headers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetWebhook {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    batched: ").append(this.toIndentedString(this.batched)).append("\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUrl() != null) {
            try {
                joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEvents() != null) {
            for (i = 0; i < this.getEvents().size(); ++i) {
                try {
                    joiner.add(String.format("%sevents%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getEvents().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getChannel() != null) {
            try {
                joiner.add(String.format("%schannel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getChannel()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCreatedAt() != null) {
            try {
                joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getModifiedAt() != null) {
            try {
                joiner.add(String.format("%smodifiedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getModifiedAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBatched() != null) {
            try {
                joiner.add(String.format("%sbatched%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBatched()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAuth() != null) {
            try {
                joiner.add(String.format("%sauth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuth()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getHeaders() != null) {
            for (i = 0; i < this.getHeaders().size(); ++i) {
                try {
                    joiner.add(String.format("%sheaders%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getHeaders().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum ChannelEnum {
        SMS(String.valueOf("sms")),
        EMAIL(String.valueOf("email"));

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelEnum fromValue(String value) {
            for (ChannelEnum b : ChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        MARKETING(String.valueOf("marketing")),
        TRANSACTIONAL(String.valueOf("transactional"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

