/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.GetDeviceBrowserStats;

@JsonPropertyOrder(value={"desktop", "mobile", "tablet", "unknown"})
@JsonTypeName(value="getStatsByDevice")
public class GetStatsByDevice {
    public static final String JSON_PROPERTY_DESKTOP = "desktop";
    @Nullable
    private Map<String, GetDeviceBrowserStats> desktop = new HashMap<String, GetDeviceBrowserStats>();
    public static final String JSON_PROPERTY_MOBILE = "mobile";
    @Nullable
    private Map<String, GetDeviceBrowserStats> mobile = new HashMap<String, GetDeviceBrowserStats>();
    public static final String JSON_PROPERTY_TABLET = "tablet";
    @Nullable
    private Map<String, GetDeviceBrowserStats> tablet = new HashMap<String, GetDeviceBrowserStats>();
    public static final String JSON_PROPERTY_UNKNOWN = "unknown";
    @Nullable
    private Map<String, GetDeviceBrowserStats> unknown = new HashMap<String, GetDeviceBrowserStats>();

    public GetStatsByDevice desktop(@Nullable Map<String, GetDeviceBrowserStats> desktop) {
        this.desktop = desktop;
        return this;
    }

    public GetStatsByDevice putDesktopItem(String key, GetDeviceBrowserStats desktopItem) {
        if (this.desktop == null) {
            this.desktop = new HashMap<String, GetDeviceBrowserStats>();
        }
        this.desktop.put(key, desktopItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="desktop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, GetDeviceBrowserStats> getDesktop() {
        return this.desktop;
    }

    @JsonProperty(value="desktop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDesktop(@Nullable Map<String, GetDeviceBrowserStats> desktop) {
        this.desktop = desktop;
    }

    public GetStatsByDevice mobile(@Nullable Map<String, GetDeviceBrowserStats> mobile) {
        this.mobile = mobile;
        return this;
    }

    public GetStatsByDevice putMobileItem(String key, GetDeviceBrowserStats mobileItem) {
        if (this.mobile == null) {
            this.mobile = new HashMap<String, GetDeviceBrowserStats>();
        }
        this.mobile.put(key, mobileItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="mobile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, GetDeviceBrowserStats> getMobile() {
        return this.mobile;
    }

    @JsonProperty(value="mobile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMobile(@Nullable Map<String, GetDeviceBrowserStats> mobile) {
        this.mobile = mobile;
    }

    public GetStatsByDevice tablet(@Nullable Map<String, GetDeviceBrowserStats> tablet) {
        this.tablet = tablet;
        return this;
    }

    public GetStatsByDevice putTabletItem(String key, GetDeviceBrowserStats tabletItem) {
        if (this.tablet == null) {
            this.tablet = new HashMap<String, GetDeviceBrowserStats>();
        }
        this.tablet.put(key, tabletItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tablet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, GetDeviceBrowserStats> getTablet() {
        return this.tablet;
    }

    @JsonProperty(value="tablet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTablet(@Nullable Map<String, GetDeviceBrowserStats> tablet) {
        this.tablet = tablet;
    }

    public GetStatsByDevice unknown(@Nullable Map<String, GetDeviceBrowserStats> unknown) {
        this.unknown = unknown;
        return this;
    }

    public GetStatsByDevice putUnknownItem(String key, GetDeviceBrowserStats unknownItem) {
        if (this.unknown == null) {
            this.unknown = new HashMap<String, GetDeviceBrowserStats>();
        }
        this.unknown.put(key, unknownItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="unknown")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, GetDeviceBrowserStats> getUnknown() {
        return this.unknown;
    }

    @JsonProperty(value="unknown")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnknown(@Nullable Map<String, GetDeviceBrowserStats> unknown) {
        this.unknown = unknown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStatsByDevice getStatsByDevice = (GetStatsByDevice)o;
        return Objects.equals(this.desktop, getStatsByDevice.desktop) && Objects.equals(this.mobile, getStatsByDevice.mobile) && Objects.equals(this.tablet, getStatsByDevice.tablet) && Objects.equals(this.unknown, getStatsByDevice.unknown);
    }

    public int hashCode() {
        return Objects.hash(this.desktop, this.mobile, this.tablet, this.unknown);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetStatsByDevice {\n");
        sb.append("    desktop: ").append(this.toIndentedString(this.desktop)).append("\n");
        sb.append("    mobile: ").append(this.toIndentedString(this.mobile)).append("\n");
        sb.append("    tablet: ").append(this.toIndentedString(this.tablet)).append("\n");
        sb.append("    unknown: ").append(this.toIndentedString(this.unknown)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDesktop() != null) {
            for (String _key : this.getDesktop().keySet()) {
                if (this.getDesktop().get(_key) == null) continue;
                joiner.add(this.getDesktop().get(_key).toUrlQueryString(String.format("%sdesktop%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getMobile() != null) {
            for (String _key : this.getMobile().keySet()) {
                if (this.getMobile().get(_key) == null) continue;
                joiner.add(this.getMobile().get(_key).toUrlQueryString(String.format("%smobile%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getTablet() != null) {
            for (String _key : this.getTablet().keySet()) {
                if (this.getTablet().get(_key) == null) continue;
                joiner.add(this.getTablet().get(_key).toUrlQueryString(String.format("%stablet%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getUnknown() != null) {
            for (String _key : this.getUnknown().keySet()) {
                if (this.getUnknown().get(_key) == null) continue;
                joiner.add(this.getUnknown().get(_key).toUrlQueryString(String.format("%sunknown%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

