/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.brevo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.brevo.model.GetProductDetails;

@JsonPropertyOrder(value={"products", "count"})
@JsonTypeName(value="getProducts")
public class GetProducts {
    public static final String JSON_PROPERTY_PRODUCTS = "products";
    @Nonnull
    private List<GetProductDetails> products = new ArrayList<GetProductDetails>();
    public static final String JSON_PROPERTY_COUNT = "count";
    @Nonnull
    private Long count;

    public GetProducts products(@Nonnull List<GetProductDetails> products) {
        this.products = products;
        return this;
    }

    public GetProducts addProductsItem(GetProductDetails productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<GetProductDetails>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="products")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<GetProductDetails> getProducts() {
        return this.products;
    }

    @JsonProperty(value="products")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProducts(@Nonnull List<GetProductDetails> products) {
        this.products = products;
    }

    public GetProducts count(@Nonnull Long count) {
        this.count = count;
        return this;
    }

    @Nonnull
    @JsonProperty(value="count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getCount() {
        return this.count;
    }

    @JsonProperty(value="count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCount(@Nonnull Long count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetProducts getProducts = (GetProducts)o;
        return Objects.equals(this.products, getProducts.products) && Objects.equals(this.count, getProducts.count);
    }

    public int hashCode() {
        return Objects.hash(this.products, this.count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetProducts {\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getProducts() != null) {
            for (int i = 0; i < this.getProducts().size(); ++i) {
                if (this.getProducts().get(i) == null) continue;
                joiner.add(this.getProducts().get(i).toUrlQueryString(String.format("%sproducts%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getCount() != null) {
            try {
                joiner.add(String.format("%scount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCount()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

